/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AntPathStringMatcher {
    private static final Pattern GLOB_PATTERN = Pattern.compile("\\?|\\*|\\{((?:\\{[^/]+?\\}|[^/{}]|\\\\[{}])+?)\\}");
    private static final String DEFAULT_VARIABLE_PATTERN = "(.*)";
    private final Pattern pattern;
    private final List<String> variableNames = new LinkedList<String>();

    AntPathStringMatcher(String pattern) {
        this.pattern = this.createPattern(pattern);
    }

    private Pattern createPattern(String pattern) {
        StringBuilder patternBuilder = new StringBuilder();
        Matcher m = GLOB_PATTERN.matcher(pattern);
        int end = 0;
        while (m.find()) {
            patternBuilder.append(this.quote(pattern, end, m.start()));
            String match2 = m.group();
            if ("?".equals(match2)) {
                patternBuilder.append('.');
            } else if ("*".equals(match2)) {
                patternBuilder.append(".*");
            } else if (match2.startsWith("{") && match2.endsWith("}")) {
                int colonIdx = match2.indexOf(58);
                if (colonIdx == -1) {
                    patternBuilder.append(DEFAULT_VARIABLE_PATTERN);
                    this.variableNames.add(m.group(1));
                } else {
                    String variablePattern = match2.substring(colonIdx + 1, match2.length() - 1);
                    patternBuilder.append('(');
                    patternBuilder.append(variablePattern);
                    patternBuilder.append(')');
                    String variableName = match2.substring(1, colonIdx);
                    this.variableNames.add(variableName);
                }
            }
            end = m.end();
        }
        patternBuilder.append(this.quote(pattern, end, pattern.length()));
        return Pattern.compile(patternBuilder.toString());
    }

    private String quote(String s, int start, int end) {
        if (start == end) {
            return "";
        }
        return Pattern.quote(s.substring(start, end));
    }

    public boolean matchStrings(String str2, Map<String, String> uriTemplateVariables) {
        Matcher matcher = this.pattern.matcher(str2);
        if (matcher.matches()) {
            if (uriTemplateVariables != null) {
                Assert.isTrue(this.variableNames.size() == matcher.groupCount(), "The number of capturing groups in the pattern segment " + this.pattern + " does not match the number of URI template variables it defines, which can occur if " + " capturing groups are used in a URI template regex. Use non-capturing groups instead.");
                int i = 1;
                while (i <= matcher.groupCount()) {
                    String name = this.variableNames.get(i - 1);
                    String value = matcher.group(i);
                    uriTemplateVariables.put(name, value);
                    ++i;
                }
            }
            return true;
        }
        return false;
    }
}

