/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.util.UriComponents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OpaqueUriComponents
extends UriComponents {
    private static final MultiValueMap<String, String> QUERY_PARAMS_NONE = new LinkedMultiValueMap<String, String>(0);
    private final String ssp;

    OpaqueUriComponents(String scheme, String schemeSpecificPart, String fragment) {
        super(scheme, fragment);
        this.ssp = schemeSpecificPart;
    }

    @Override
    public String getSchemeSpecificPart() {
        return this.ssp;
    }

    @Override
    public String getUserInfo() {
        return null;
    }

    @Override
    public String getHost() {
        return null;
    }

    @Override
    public int getPort() {
        return -1;
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public List<String> getPathSegments() {
        return Collections.emptyList();
    }

    @Override
    public String getQuery() {
        return null;
    }

    @Override
    public MultiValueMap<String, String> getQueryParams() {
        return QUERY_PARAMS_NONE;
    }

    @Override
    public UriComponents encode(String encoding) throws UnsupportedEncodingException {
        return this;
    }

    @Override
    protected UriComponents expandInternal(UriComponents.UriTemplateVariables uriVariables) {
        String expandedScheme = OpaqueUriComponents.expandUriComponent(this.getScheme(), uriVariables);
        String expandedSSp = OpaqueUriComponents.expandUriComponent(this.ssp, uriVariables);
        String expandedFragment = OpaqueUriComponents.expandUriComponent(this.getFragment(), uriVariables);
        return new OpaqueUriComponents(expandedScheme, expandedSSp, expandedFragment);
    }

    @Override
    public String toUriString() {
        StringBuilder uriBuilder = new StringBuilder();
        if (this.getScheme() != null) {
            uriBuilder.append(this.getScheme());
            uriBuilder.append(':');
        }
        if (this.ssp != null) {
            uriBuilder.append(this.ssp);
        }
        if (this.getFragment() != null) {
            uriBuilder.append('#');
            uriBuilder.append(this.getFragment());
        }
        return uriBuilder.toString();
    }

    @Override
    public URI toUri() {
        try {
            return new URI(this.getScheme(), this.ssp, this.getFragment());
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Could not create URI object: " + ex.getMessage(), ex);
        }
    }

    @Override
    public UriComponents normalize() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OpaqueUriComponents)) {
            return false;
        }
        OpaqueUriComponents other = (OpaqueUriComponents)obj;
        if (ObjectUtils.nullSafeEquals(this.getScheme(), other.getScheme())) {
            return false;
        }
        if (ObjectUtils.nullSafeEquals(this.ssp, other.ssp)) {
            return false;
        }
        return !ObjectUtils.nullSafeEquals(this.getFragment(), other.getFragment());
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.getScheme());
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.ssp);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.getFragment());
        return result;
    }
}

