/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.MutableInteger;
import org.w3c.tidy.Node;
import org.w3c.tidy.PPrint;
import org.w3c.tidy.TagTable;

public class Report {
    public static final String ACCESS_URL = "http://www.w3.org/WAI/GL";
    public static final String RELEASE_DATE = "4th August 2000";
    public static String currentFile;
    public static final short MISSING_SEMICOLON = 1;
    public static final short UNKNOWN_ENTITY = 2;
    public static final short UNESCAPED_AMPERSAND = 3;
    public static final short MISSING_ENDTAG_FOR = 1;
    public static final short MISSING_ENDTAG_BEFORE = 2;
    public static final short DISCARDING_UNEXPECTED = 3;
    public static final short NESTED_EMPHASIS = 4;
    public static final short NON_MATCHING_ENDTAG = 5;
    public static final short TAG_NOT_ALLOWED_IN = 6;
    public static final short MISSING_STARTTAG = 7;
    public static final short UNEXPECTED_ENDTAG = 8;
    public static final short USING_BR_INPLACE_OF = 9;
    public static final short INSERTING_TAG = 10;
    public static final short SUSPECTED_MISSING_QUOTE = 11;
    public static final short MISSING_TITLE_ELEMENT = 12;
    public static final short DUPLICATE_FRAMESET = 13;
    public static final short CANT_BE_NESTED = 14;
    public static final short OBSOLETE_ELEMENT = 15;
    public static final short PROPRIETARY_ELEMENT = 16;
    public static final short UNKNOWN_ELEMENT = 17;
    public static final short TRIM_EMPTY_ELEMENT = 18;
    public static final short COERCE_TO_ENDTAG = 19;
    public static final short ILLEGAL_NESTING = 20;
    public static final short NOFRAMES_CONTENT = 21;
    public static final short CONTENT_AFTER_BODY = 22;
    public static final short INCONSISTENT_VERSION = 23;
    public static final short MALFORMED_COMMENT = 24;
    public static final short BAD_COMMENT_CHARS = 25;
    public static final short BAD_XML_COMMENT = 26;
    public static final short BAD_CDATA_CONTENT = 27;
    public static final short INCONSISTENT_NAMESPACE = 28;
    public static final short DOCTYPE_AFTER_TAGS = 29;
    public static final short MALFORMED_DOCTYPE = 30;
    public static final short UNEXPECTED_END_OF_FILE = 31;
    public static final short DTYPE_NOT_UPPER_CASE = 32;
    public static final short TOO_MANY_ELEMENTS = 33;
    public static final short UNKNOWN_ATTRIBUTE = 1;
    public static final short MISSING_ATTRIBUTE = 2;
    public static final short MISSING_ATTR_VALUE = 3;
    public static final short BAD_ATTRIBUTE_VALUE = 4;
    public static final short UNEXPECTED_GT = 5;
    public static final short PROPRIETARY_ATTR_VALUE = 6;
    public static final short REPEATED_ATTRIBUTE = 7;
    public static final short MISSING_IMAGEMAP = 8;
    public static final short XML_ATTRIBUTE_VALUE = 9;
    public static final short UNEXPECTED_QUOTEMARK = 10;
    public static final short ID_NAME_MISMATCH = 11;
    public static final short MISSING_IMAGE_ALT = 1;
    public static final short MISSING_LINK_ALT = 2;
    public static final short MISSING_SUMMARY = 4;
    public static final short MISSING_IMAGE_MAP = 8;
    public static final short USING_FRAMES = 16;
    public static final short USING_NOFRAMES = 32;
    public static final short USING_SPACER = 1;
    public static final short USING_LAYER = 2;
    public static final short USING_NOBR = 4;
    public static final short USING_FONT = 8;
    public static final short USING_BODY = 16;
    public static final short WINDOWS_CHARS = 1;
    public static final short NON_ASCII = 2;
    public static final short FOUND_UTF16 = 4;
    private static short optionerrors;
    private static ResourceBundle res;

    static {
        res = null;
        try {
            res = ResourceBundle.getBundle("org/w3c/tidy/TidyMessages");
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error(missingResourceException.toString());
        }
    }

    public static void attrError(Lexer lexer, Node node, String string, short s) {
        lexer.warnings = (short)(lexer.warnings + 1);
        if (lexer.errors > 6) {
            return;
        }
        if (lexer.configuration.ShowWarnings) {
            if (s == 31) {
                lexer.lines = lexer.in.curline;
                lexer.columns = lexer.in.curcol;
            }
            Report.position(lexer);
            if (s == 1) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("unknown_attribute"), string));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 2) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("missing_attribute"), string));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 3) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("missing_attr_value"), string));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 8) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, res.getString("missing_imagemap"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                lexer.badAccess = (short)(lexer.badAccess | 8);
            } else if (s == 4) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("bad_attribute_value"), string));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 9) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("xml_attribute_value"), string));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 5) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("error"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, res.getString("unexpected_gt"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                lexer.errors = (short)(lexer.errors + 1);
            } else if (s == 10) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, res.getString("unexpected_quotemark"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 7) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, res.getString("repeated_attribute"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 6) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("proprietary_attr_value"), string));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 31) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("unexpected_end_of_file"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 11) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, res.getString("id_name_mismatch"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            Report.tidyPrintln(lexer.errout);
        } else if (s == 5) {
            Report.position(lexer);
            try {
                Report.tidyPrint(lexer.errout, res.getString("error"));
                Report.tag(lexer, node);
                Report.tidyPrint(lexer.errout, res.getString("unexpected_gt"));
            }
            catch (MissingResourceException missingResourceException) {
                lexer.errout.println(missingResourceException.toString());
            }
            Report.tidyPrintln(lexer.errout);
            lexer.errors = (short)(lexer.errors + 1);
        }
    }

    public static void badArgument(String string) {
        optionerrors = (short)(optionerrors + 1);
        try {
            System.err.println(MessageFormat.format(res.getString("bad_argument"), string));
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(missingResourceException.toString());
        }
    }

    public static void badTree(PrintWriter printWriter) {
        try {
            Report.tidyPrintln(printWriter, res.getString("bad_tree"));
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
        }
    }

    public static void encodingError(Lexer lexer, short s, int n) {
        lexer.warnings = (short)(lexer.warnings + 1);
        if (lexer.configuration.ShowWarnings) {
            Report.position(lexer);
            if (s == 1) {
                lexer.badChars = (short)(lexer.badChars | 1);
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("illegal_char"), new Integer(n)));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            Report.tidyPrintln(lexer.errout);
        }
    }

    public static void entityError(Lexer lexer, short s, String string, int n) {
        lexer.warnings = (short)(lexer.warnings + 1);
        if (lexer.configuration.ShowWarnings) {
            Report.position(lexer);
            if (s == 1) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("missing_semicolon"), string));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 2) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("unknown_entity"), string));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 3) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("unescaped_ampersand"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            Report.tidyPrintln(lexer.errout);
        }
    }

    public static void error(Lexer lexer, Node node, Node node2, short s) {
        lexer.warnings = (short)(lexer.warnings + 1);
        if (lexer.errors > 6) {
            return;
        }
        lexer.errors = (short)(lexer.errors + 1);
        Report.position(lexer);
        if (s == 11) {
            try {
                Report.tidyPrint(lexer.errout, res.getString("suspected_missing_quote"));
            }
            catch (MissingResourceException missingResourceException) {
                lexer.errout.println(missingResourceException.toString());
            }
        } else if (s == 13) {
            try {
                Report.tidyPrint(lexer.errout, res.getString("duplicate_frameset"));
            }
            catch (MissingResourceException missingResourceException) {
                lexer.errout.println(missingResourceException.toString());
            }
        } else if (s == 17) {
            try {
                Report.tidyPrint(lexer.errout, res.getString("error"));
            }
            catch (MissingResourceException missingResourceException) {
                lexer.errout.println(missingResourceException.toString());
            }
            Report.tag(lexer, node2);
            try {
                Report.tidyPrint(lexer.errout, res.getString("unknown_element"));
            }
            catch (MissingResourceException missingResourceException) {
                lexer.errout.println(missingResourceException.toString());
            }
        } else if (s == 8) {
            try {
                Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("unexpected_endtag"), node2.element));
                if (node != null) {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("unexpected_endtag_suffix"), node.element));
                }
            }
            catch (MissingResourceException missingResourceException) {
                lexer.errout.println(missingResourceException.toString());
            }
        }
        Report.tidyPrintln(lexer.errout);
    }

    public static void errorSummary(Lexer lexer) {
        block40: {
            if ((lexer.badAccess & 0x30) != 0 && ((lexer.badAccess & 0x10) == 0 || (lexer.badAccess & 0x20) != 0)) {
                lexer.badAccess = (short)(lexer.badAccess & 0xFFFFFFCF);
            }
            if (lexer.badChars != 0 && (lexer.badChars & 1) != 0) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("badchars_summary"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            if (lexer.badForm != 0) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("badform_summary"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            if (lexer.badAccess != 0) {
                if ((lexer.badAccess & 4) != 0) {
                    try {
                        Report.tidyPrint(lexer.errout, res.getString("badaccess_missing_summary"));
                    }
                    catch (MissingResourceException missingResourceException) {
                        lexer.errout.println(missingResourceException.toString());
                    }
                }
                if ((lexer.badAccess & 1) != 0) {
                    try {
                        Report.tidyPrint(lexer.errout, res.getString("badaccess_missing_image_alt"));
                    }
                    catch (MissingResourceException missingResourceException) {
                        lexer.errout.println(missingResourceException.toString());
                    }
                }
                if ((lexer.badAccess & 8) != 0) {
                    try {
                        Report.tidyPrint(lexer.errout, res.getString("badaccess_missing_image_map"));
                    }
                    catch (MissingResourceException missingResourceException) {
                        lexer.errout.println(missingResourceException.toString());
                    }
                }
                if ((lexer.badAccess & 2) != 0) {
                    try {
                        Report.tidyPrint(lexer.errout, res.getString("badaccess_missing_link_alt"));
                    }
                    catch (MissingResourceException missingResourceException) {
                        lexer.errout.println(missingResourceException.toString());
                    }
                }
                if ((lexer.badAccess & 0x10) != 0 && (lexer.badAccess & 0x20) == 0) {
                    try {
                        Report.tidyPrint(lexer.errout, res.getString("badaccess_frames"));
                    }
                    catch (MissingResourceException missingResourceException) {
                        lexer.errout.println(missingResourceException.toString());
                    }
                }
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("badaccess_summary"), ACCESS_URL));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            if (lexer.badLayout == 0) break block40;
            if ((lexer.badLayout & 2) != 0) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("badlayout_using_layer"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            if ((lexer.badLayout & 1) != 0) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("badlayout_using_spacer"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            if ((lexer.badLayout & 8) != 0) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("badlayout_using_font"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            if ((lexer.badLayout & 4) != 0) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("badlayout_using_nobr"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
            if ((lexer.badLayout & 0x10) != 0) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("badlayout_using_body"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            }
        }
    }

    public static void generalInfo(PrintWriter printWriter) {
        try {
            Report.tidyPrintln(printWriter, res.getString("general_info"));
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
        }
    }

    public static void helloMessage(PrintWriter printWriter, String string, String string2) {
        currentFile = string2;
        try {
            Report.tidyPrintln(printWriter, MessageFormat.format(res.getString("hello_message"), string, string2));
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
        }
    }

    public static void helpText(PrintWriter printWriter, String string) {
        try {
            Report.tidyPrintln(printWriter, MessageFormat.format(res.getString("help_text"), string, RELEASE_DATE));
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
        }
    }

    public static void missingBody(PrintWriter printWriter) {
        try {
            Report.tidyPrintln(printWriter, res.getString("missing_body"));
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
        }
    }

    public static void needsAuthorIntervention(PrintWriter printWriter) {
        try {
            Report.tidyPrintln(printWriter, res.getString("needs_author_intervention"));
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
        }
    }

    public static void position(Lexer lexer) {
        try {
            if (lexer.configuration.Emacs) {
                Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("emacs_format"), currentFile, new Integer(lexer.lines), new Integer(lexer.columns)));
                Report.tidyPrint(lexer.errout, " ");
            } else {
                Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("line_column"), new Integer(lexer.lines), new Integer(lexer.columns)));
            }
        }
        catch (MissingResourceException missingResourceException) {
            lexer.errout.println(missingResourceException.toString());
        }
    }

    public static void reportNumWarnings(PrintWriter printWriter, Lexer lexer) {
        if (lexer.warnings > 0) {
            try {
                Report.tidyPrintln(printWriter, MessageFormat.format(res.getString("num_warnings"), new Integer(lexer.warnings)));
            }
            catch (MissingResourceException missingResourceException) {
                printWriter.println(missingResourceException.toString());
            }
        } else {
            try {
                Report.tidyPrintln(printWriter, res.getString("no_warnings"));
            }
            catch (MissingResourceException missingResourceException) {
                printWriter.println(missingResourceException.toString());
            }
        }
    }

    public static void reportNumberOfSlides(PrintWriter printWriter, int n) {
        try {
            Report.tidyPrintln(printWriter, MessageFormat.format(res.getString("slides_found"), new Integer(n)));
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
        }
    }

    public static void reportVersion(PrintWriter printWriter, Lexer lexer, String string, Node node) {
        int n = 0;
        String string2 = lexer.HTMLVersionName();
        MutableInteger mutableInteger = new MutableInteger();
        try {
            if (node != null) {
                Report.tidyPrint(printWriter, MessageFormat.format(res.getString("doctype_given"), string));
                int n2 = node.start;
                while (n2 < node.end) {
                    int n4 = node.textarray[n2];
                    if (n4 < 0) {
                        n2 += PPrint.getUTF8(node.textarray, n2, mutableInteger);
                        n4 = mutableInteger.value;
                    }
                    if (n4 == 34) {
                        ++n;
                    } else if (n == 1) {
                        printWriter.print((char)n4);
                    }
                    ++n2;
                }
                printWriter.print('\"');
            }
            Report.tidyPrintln(printWriter, MessageFormat.format(res.getString("report_version"), string, string2 != null ? string2 : "HTML proprietary"));
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
        }
    }

    public static void showVersion(PrintWriter printWriter) {
        Report.tidyPrintln(printWriter, "Java HTML Tidy release date: 4th August 2000");
        Report.tidyPrintln(printWriter, "See http://www.w3.org/People/Raggett for details");
    }

    public static void tag(Lexer lexer, Node node) {
        if (node != null) {
            if (node.type == 5) {
                Report.tidyPrint(lexer.errout, "<" + node.element + ">");
            } else if (node.type == 6) {
                Report.tidyPrint(lexer.errout, "</" + node.element + ">");
            } else if (node.type == 1) {
                Report.tidyPrint(lexer.errout, "<!DOCTYPE>");
            } else if (node.type == 4) {
                Report.tidyPrint(lexer.errout, "plain text");
            } else {
                Report.tidyPrint(lexer.errout, node.element);
            }
        }
    }

    public static void tidyPrint(PrintWriter printWriter, String string) {
        printWriter.print(string);
    }

    public static void tidyPrintln(PrintWriter printWriter) {
        printWriter.println();
    }

    public static void tidyPrintln(PrintWriter printWriter, String string) {
        printWriter.println(string);
    }

    public static void unknownFile(PrintWriter printWriter, String string, String string2) {
        try {
            Report.tidyPrintln(printWriter, MessageFormat.format(res.getString("unknown_file"), string, string2));
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
        }
    }

    public static void unknownOption(PrintWriter printWriter, char c) {
        try {
            Report.tidyPrintln(printWriter, MessageFormat.format(res.getString("unrecognized_option"), new String(new char[]{c})));
        }
        catch (MissingResourceException missingResourceException) {
            printWriter.println(missingResourceException.toString());
        }
    }

    public static void unknownOption(String string) {
        optionerrors = (short)(optionerrors + 1);
        try {
            System.err.println(MessageFormat.format(res.getString("unknown_option"), string));
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(missingResourceException.toString());
        }
    }

    public static void warning(Lexer lexer, Node node, Node node2, short s) {
        TagTable tagTable = lexer.configuration.tt;
        lexer.warnings = (short)(lexer.warnings + 1);
        if (lexer.errors > 6) {
            return;
        }
        if (lexer.configuration.ShowWarnings) {
            if (s == 31) {
                lexer.lines = lexer.in.curline;
                lexer.columns = lexer.in.curcol;
            }
            Report.position(lexer);
            if (s == 1) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("missing_endtag_for"), node.element));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 2) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("missing_endtag_before"), node.element));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
            } else if (s == 3) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("discarding_unexpected"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
            } else if (s == 4) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("nested_emphasis"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
            } else if (s == 19) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("coerce_to_endtag"), node.element));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 5) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("non_matching_endtag_1"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("non_matching_endtag_2"), node.element));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 6) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("tag_not_allowed_in"), node.element));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 29) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("doctype_after_tags"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 7) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("missing_starttag"), node2.element));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 8) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("unexpected_endtag"), node2.element));
                    if (node != null) {
                        Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("unexpected_endtag_suffix"), node.element));
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 33) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("too_many_elements"), node2.element));
                    if (node != null) {
                        Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("too_many_elements_suffix"), node.element));
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 9) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("using_br_inplace_of"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
            } else if (s == 10) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("inserting_tag"), node2.element));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 14) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
                try {
                    Report.tidyPrint(lexer.errout, res.getString("cant_be_nested"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 16) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
                try {
                    Report.tidyPrint(lexer.errout, res.getString("proprietary_element"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                if (node2.tag == tagTable.tagLayer) {
                    lexer.badLayout = (short)(lexer.badLayout | 2);
                } else if (node2.tag == tagTable.tagSpacer) {
                    lexer.badLayout = (short)(lexer.badLayout | 1);
                } else if (node2.tag == tagTable.tagNobr) {
                    lexer.badLayout = (short)(lexer.badLayout | 4);
                }
            } else if (s == 15) {
                try {
                    if (node.tag != null && (node.tag.model & 0x80000) != 0) {
                        Report.tidyPrint(lexer.errout, res.getString("obsolete_element"));
                    } else {
                        Report.tidyPrint(lexer.errout, res.getString("replacing_element"));
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node);
                try {
                    Report.tidyPrint(lexer.errout, res.getString("by"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
            } else if (s == 18) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("trim_empty_element"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node);
            } else if (s == 12) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("missing_title_element"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 20) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node);
                try {
                    Report.tidyPrint(lexer.errout, res.getString("illegal_nesting"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 21) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node2);
                try {
                    Report.tidyPrint(lexer.errout, res.getString("noframes_content"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 23) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("inconsistent_version"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 30) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("malformed_doctype"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 22) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("content_after_body"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 24) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("malformed_comment"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 25) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("bad_comment_chars"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 26) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("bad_xml_comment"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 27) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("bad_cdata_content"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 28) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("inconsistent_namespace"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 32) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("dtype_not_upper_case"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
            } else if (s == 31) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("unexpected_end_of_file"));
                }
                catch (MissingResourceException missingResourceException) {
                    lexer.errout.println(missingResourceException.toString());
                }
                Report.tag(lexer, node);
            }
            Report.tidyPrintln(lexer.errout);
        }
    }
}

