/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.CMap;
import com.hazelcast.impl.NearCacheRecord;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.concurrentmap.RecordFactory;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Data;
import com.hazelcast.util.Clock;
import com.hazelcast.util.SortedHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NearCache {
    private final ILogger logger;
    private final Map<Data, Object> sortedMap;
    private final ConcurrentMap<Object, CacheEntry> cache;
    private final CMap cmap;
    private final SortedHashMap.OrderingType orderingType;
    private final int maxSize;
    private final long ttl;
    private final long maxIdleTime;
    private final boolean invalidateOnChange;
    private final RecordFactory recordFactory;

    public NearCache(CMap cmap, SortedHashMap.OrderingType orderingType, int maxSize, long ttl, long maxIdleTime, boolean invalidateOnChange) {
        this.cmap = cmap;
        this.orderingType = orderingType;
        this.logger = cmap.concurrentMapManager.node.getLogger(NearCache.class.getName());
        this.maxSize = maxSize == 0 ? Integer.MAX_VALUE : maxSize;
        this.ttl = ttl;
        this.maxIdleTime = maxIdleTime;
        this.invalidateOnChange = invalidateOnChange;
        int size = maxSize == 0 || maxSize > 50000 ? 10000 : maxSize;
        this.sortedMap = orderingType == SortedHashMap.OrderingType.NONE ? new HashMap() : new SortedHashMap(size, orderingType);
        this.cache = new ConcurrentHashMap<Object, CacheEntry>(size, 0.75f, 1);
        this.recordFactory = cmap.concurrentMapManager.recordFactory;
    }

    boolean shouldInvalidateOnChange() {
        return this.invalidateOnChange;
    }

    public boolean containsKey(Object key) {
        long now2 = Clock.currentTimeMillis();
        CacheEntry entry = (CacheEntry)this.cache.get(key);
        return entry != null && !entry.isValid(now2);
    }

    public void setContainsKey(Object key, Data dataKey) {
        CacheEntry entry = (CacheEntry)this.cache.get(key);
        if (entry == null) {
            this.put(key, dataKey, null);
        }
    }

    public Object get(Object key) {
        long now2 = Clock.currentTimeMillis();
        CacheEntry entry = (CacheEntry)this.cache.get(key);
        if (entry == null) {
            return null;
        }
        if (entry.isValid(now2)) {
            Object value = null;
            value = ThreadContext.get().isClient() ? entry.getValueData() : entry.getValue();
            if (this.orderingType != SortedHashMap.OrderingType.NONE) {
                this.cmap.concurrentMapManager.enqueueAndReturn(entry);
            }
            entry.touch(now2);
            return value;
        }
        return null;
    }

    private List<Data> getInvalidEntries(long now2) {
        ArrayList<Data> lsKeysToInvalidate = null;
        if (this.ttl != 0L || this.maxIdleTime != 0L) {
            lsKeysToInvalidate = new ArrayList<Data>();
            Collection entries = this.cache.values();
            for (CacheEntry entry : entries) {
                if (entry.isValid(now2)) continue;
                lsKeysToInvalidate.add(entry.record.getKeyData());
            }
        }
        return lsKeysToInvalidate;
    }

    public void evict(long now2, boolean serviceThread) {
        if (serviceThread) {
            this.checkThread();
        }
        if (this.maxSize == Integer.MAX_VALUE && this.maxIdleTime == 0L && this.ttl == 0L) {
            return;
        }
        final List<Data> lsKeysToInvalidate = this.getInvalidEntries(now2);
        if (lsKeysToInvalidate != null && lsKeysToInvalidate.size() > 0) {
            if (serviceThread) {
                for (Data key : lsKeysToInvalidate) {
                    this.invalidate(key);
                }
            } else {
                this.cmap.concurrentMapManager.enqueueAndReturn(new Processable(){

                    public void process() {
                        for (Data key : lsKeysToInvalidate) {
                            NearCache.this.invalidate(key);
                        }
                    }
                });
            }
        }
    }

    public void put(Object key, Data keyData, Data value) {
        CacheEntry cacheEntry;
        this.checkThread();
        if (this.cache.size() != this.sortedMap.size()) {
            this.logger.log(Level.WARNING, this.cmap.getName() + " cache and sorted map size should be the same: " + this.cache.size() + " vs. " + this.sortedMap.size() + "/nCheck equals and hashCode of key object!");
        }
        if (this.cache.size() + 1 >= this.maxSize) {
            this.startEviction();
        }
        if (this.cache.size() + 1 >= this.maxSize) {
            return;
        }
        if (!this.sortedMap.containsKey(keyData)) {
            this.sortedMap.put(keyData, key);
        }
        if ((cacheEntry = (CacheEntry)this.cache.get(key)) == null) {
            cacheEntry = new CacheEntry(key, keyData, value);
        } else {
            cacheEntry.setValueData(value);
        }
        this.cache.put(key, cacheEntry);
    }

    void startEviction() {
        this.checkThread();
        int evictionCount = (int)((double)this.cache.size() * 0.25);
        ArrayList<Data> lsRemoves = new ArrayList<Data>(evictionCount);
        int count = 0;
        for (Data key : this.sortedMap.keySet()) {
            lsRemoves.add(key);
            if (count++ < evictionCount) continue;
            break;
        }
        for (Data key : lsRemoves) {
            this.invalidate(key);
        }
        lsRemoves.clear();
    }

    public void invalidate(Data key) {
        this.checkThread();
        Object theKey = this.sortedMap.remove(key);
        if (theKey != null) {
            CacheEntry removedCacheEntry = (CacheEntry)this.cache.remove(theKey);
            if (removedCacheEntry != null) {
                removedCacheEntry.invalidate();
            } else {
                this.logger.log(Level.WARNING, this.cmap.name + " removed CacheEntry cannot be null");
            }
        }
    }

    void checkThread() {
        if (this.cmap.concurrentMapManager.node.serviceThread != Thread.currentThread()) {
            throw new RuntimeException("Only ServiceThread can update the cache! " + Thread.currentThread().getName());
        }
    }

    public void appendState(StringBuffer sbState) {
        sbState.append(", n.sorted:").append(this.sortedMap.size());
        sbState.append(", n.cache:").append(this.cache.size());
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public void reset() {
        this.sortedMap.clear();
        for (CacheEntry entry : this.cache.values()) {
            entry.invalidate();
        }
        this.cache.clear();
    }

    private class CacheEntry
    implements Processable {
        private final NearCacheRecord record;
        private final long createTime;
        private volatile long lastAccessTime;

        private CacheEntry(Object key, Data keyData, Data valueData) {
            if (key == null) {
                throw new IllegalStateException("key cannot be null");
            }
            if (keyData == null) {
                throw new IllegalStateException("keyData cannot be null");
            }
            this.record = NearCache.this.recordFactory.createNewNearCacheRecord(NearCache.this.cmap, keyData, valueData);
            this.createTime = Clock.currentTimeMillis();
            this.touch(this.createTime);
        }

        public void touch(long now2) {
            this.lastAccessTime = now2;
        }

        public boolean isValid(long now2) {
            if (NearCache.this.ttl != 0L && now2 - this.createTime > NearCache.this.ttl) {
                return false;
            }
            return NearCache.this.maxIdleTime == 0L || now2 - this.lastAccessTime <= NearCache.this.maxIdleTime;
        }

        public void setValueData(Data valueData) {
            this.record.setValueData(valueData);
        }

        public Object getValue() {
            return this.record.getValue();
        }

        public Data getValueData() {
            return this.record.getValueData();
        }

        public void process() {
            NearCache.this.sortedMap.get(this.record.getKeyData());
        }

        public void invalidate() {
            this.record.invalidate();
        }
    }
}

