/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.AssemblerHelp;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.exceptions.CannotConstructException;
import com.hp.hpl.jena.assembler.exceptions.CannotLoadClassException;
import com.hp.hpl.jena.assembler.exceptions.NotUniqueException;
import com.hp.hpl.jena.assembler.exceptions.PropertyRequiredException;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.List;

public abstract class AssemblerBase
implements Assembler {
    static final Map1 getObject = new Map1(){

        public Object map1(Object o) {
            return ((Statement)o).getObject();
        }
    };

    public final Object open(Resource root2) {
        return this.open(this, root2);
    }

    public final Object open(Assembler a, Resource root2) {
        return this.open(a, root2, Mode.DEFAULT);
    }

    public abstract Object open(Assembler var1, Resource var2, Mode var3);

    protected static Resource getUniqueResource(Resource root2, Property property) {
        return (Resource)AssemblerBase.getUnique(root2, property);
    }

    protected static Literal getUniqueLiteral(Resource root2, Property property) {
        return (Literal)AssemblerBase.getUnique(root2, property);
    }

    protected static Statement getUniqueStatement(Resource root2, Property property) {
        List statements = IteratorCollection.iteratorToList(root2.listProperties(property));
        if (statements.size() == 0) {
            return null;
        }
        if (statements.size() == 1) {
            return (Statement)statements.get(0);
        }
        throw new NotUniqueException(root2, property);
    }

    protected static RDFNode getUnique(Resource root2, Property property) {
        List nodes = IteratorCollection.iteratorToList(root2.listProperties(property).mapWith(getObject));
        if (nodes.size() == 0) {
            return null;
        }
        if (nodes.size() == 1) {
            return (RDFNode)nodes.get(0);
        }
        throw new NotUniqueException(root2, property);
    }

    protected void checkType(Resource root2, Resource type) {
        if (!root2.hasProperty(RDF.type, type)) {
            throw new CannotConstructException(this.getClass(), root2, type);
        }
    }

    public Model openModel(Resource root2, Mode mode) {
        return (Model)this.open(this, root2, mode);
    }

    public Model openModel(Resource root2) {
        return this.openModel(root2, Mode.DEFAULT);
    }

    public static Resource getRequiredResource(Resource root2, Property p) {
        Resource R = AssemblerBase.getUniqueResource(root2, p);
        if (R == null) {
            throw new PropertyRequiredException(root2, p);
        }
        return R;
    }

    protected Literal getRequiredLiteral(Resource root2, Property p) {
        Literal L = AssemblerBase.getUniqueLiteral(root2, p);
        if (L == null) {
            throw new PropertyRequiredException(root2, p);
        }
        return L;
    }

    protected static Resource getResource(Statement s) {
        return AssemblerHelp.getResource(s);
    }

    protected static String getString(Statement s) {
        return AssemblerHelp.getString(s);
    }

    protected static String getUniqueString(Resource root2, Property property) {
        Statement s = AssemblerBase.getUniqueStatement(root2, property);
        return s == null ? null : AssemblerHelp.getString(s);
    }

    protected static Class loadClass(Resource root2, String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e2) {
            throw new CannotLoadClassException(root2, className, e2);
        }
    }

    public static String getOptionalClassName(Resource root2, Property classProperty) {
        RDFNode classNode = AssemblerBase.getUnique(root2, classProperty);
        return classNode == null ? null : (classNode.isLiteral() ? classNode.asNode().getLiteralLexicalForm() : (classNode.isResource() ? AssemblerBase.mustBeJava(classNode.asNode().getURI()) : null));
    }

    private static String mustBeJava(String uri) {
        if (uri.startsWith("java:")) {
            return uri.substring(5);
        }
        throw new JenaException("class name URI must start with 'java:': " + uri);
    }

    protected static class MapObjectToContent
    implements Map1 {
        protected final Assembler a;

        public MapObjectToContent(Assembler a) {
            this.a = a;
        }

        public Object map1(Object o) {
            return this.a.open(AssemblerBase.getResource((Statement)o));
        }
    }
}

