/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.ConnectionDescription;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;

public class ConnectionAssembler
extends AssemblerBase
implements Assembler {
    public final String defaultURL;
    public final String defaultUser;
    public final String defaultPassword;
    public final String defaultType;
    protected static final Resource emptyRoot = ModelFactory.createDefaultModel().createResource();

    public ConnectionAssembler(Resource init) {
        this.defaultUser = this.get(init, "dbUser", null);
        this.defaultPassword = this.get(init, "dbPassword", null);
        this.defaultURL = this.get(init, "dbURL", null);
        this.defaultType = this.get(init, "dbType", null);
    }

    public ConnectionAssembler() {
        this(emptyRoot);
    }

    public Object open(Assembler a, Resource root2, Mode irrelevant) {
        this.checkType(root2, JA.Connection);
        String dbUser = this.getUser(root2);
        String dbPassword = this.getPassword(root2);
        String dbURL = this.getURL(root2);
        String dbType = this.getType(root2);
        this.loadClasses(root2);
        return this.createConnection(root2.getURI(), dbURL, dbType, dbUser, dbPassword);
    }

    private void loadClasses(Resource root2) {
        StmtIterator it = root2.listProperties(JA.dbClassProperty);
        while (it.hasNext()) {
            String propertyName = ConnectionAssembler.getString(it.nextStatement());
            String className = JenaRuntime.getSystemProperty(propertyName);
            ConnectionAssembler.loadClass(root2, className);
        }
        it = root2.listProperties(JA.dbClass);
        while (it.hasNext()) {
            String className = ConnectionAssembler.getString(it.nextStatement());
            ConnectionAssembler.loadClass(root2, className);
        }
    }

    protected ConnectionDescription createConnection(String subject, String dbURL, String dbType, String dbUser, String dbPassword) {
        return ConnectionDescription.create(subject, dbURL, dbUser, dbPassword, dbType);
    }

    public String getUser(Resource root2) {
        return this.get(root2, "dbUser", this.defaultUser);
    }

    public String getPassword(Resource root2) {
        return this.get(root2, "dbPassword", this.defaultPassword);
    }

    public String getURL(Resource root2) {
        return this.get(root2, "dbURL", this.defaultURL);
    }

    public String getType(Resource root2) {
        return this.get(root2, "dbType", this.defaultType);
    }

    protected String get(Resource root2, String label, String ifAbsent) {
        Property property = JA.property(label);
        RDFNode L = ConnectionAssembler.getUnique(root2, property);
        return L == null ? this.getIndirect(root2, label, ifAbsent) : (L.isLiteral() ? ((Literal)L).getLexicalForm() : ((Resource)L).getURI());
    }

    private String getIndirect(Resource root2, String label, String ifAbsent) {
        Property property = JA.property(label + "Property");
        Literal name = ConnectionAssembler.getUniqueLiteral(root2, property);
        return name == null ? ifAbsent : JenaRuntime.getSystemProperty(name.getLexicalForm());
    }
}

