/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.ResourceUtils;

public class DocumentManagerAssembler
extends AssemblerBase {
    public Object open(Assembler a, Resource root2, Mode irrelevant) {
        this.checkType(root2, JA.DocumentManager);
        OntDocumentManager result = this.createDocumentManager();
        result.setMetadataSearchPath(this.getPath(a, root2), false);
        result.configure(ResourceUtils.reachableClosure(root2), false);
        result.setFileManager(this.getFileManager(a, root2));
        return result;
    }

    private String getPath(Assembler a, Resource root2) {
        String s = DocumentManagerAssembler.getUniqueString(root2, JA.policyPath);
        return s == null ? "file:ont-policy.rdf;file:etc/ont-policy.rdf" : s;
    }

    private FileManager getFileManager(Assembler a, Resource root2) {
        Resource fm = DocumentManagerAssembler.getUniqueResource(root2, JA.fileManager);
        return fm == null ? FileManager.get() : (FileManager)a.open(fm);
    }

    protected OntDocumentManager createDocumentManager() {
        return new OntDocumentManager("");
    }
}

