/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.NamedModelAssembler;
import com.hp.hpl.jena.graph.impl.FileGraph;
import com.hp.hpl.jena.graph.impl.FileGraphMaker;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.FileUtils;
import java.io.File;

public class FileModelAssembler
extends NamedModelAssembler
implements Assembler {
    protected Model openEmptyModel(Assembler a, Resource root2, Mode mode) {
        this.checkType(root2, JA.FileModel);
        File fullName = this.getFileName(root2);
        boolean mayCreate = mode.permitCreateNew(root2, fullName.toString());
        boolean mayReuse = mode.permitUseExisting(root2, fullName.toString());
        boolean create = mayCreate;
        boolean strict = mayCreate != mayReuse;
        String lang = this.getLanguage(root2, fullName);
        ReificationStyle style = FileModelAssembler.getReificationStyle(root2);
        return this.createFileModel(fullName, lang, create, strict, style);
    }

    public Model createFileModel(File fullName, String lang, boolean create, boolean strict, ReificationStyle style) {
        FileGraph.NotifyOnClose notify = FileGraph.NotifyOnClose.ignore;
        FileGraph fileGraph = new FileGraph(notify, fullName, lang, create, strict, style);
        return ModelFactory.createModelForGraph(fileGraph);
    }

    protected String getLanguage(Resource root2, File fullName) {
        Statement s = FileModelAssembler.getUniqueStatement(root2, JA.fileEncoding);
        return s == null ? FileUtils.guessLang(fullName.toString()) : FileModelAssembler.getString(s);
    }

    protected File getFileName(Resource root2) {
        String name = this.getModelName(root2);
        boolean mapName = this.getBoolean(root2, JA.mapName, false);
        String dir = this.getDirectoryName(root2);
        return new File(dir, mapName ? FileGraphMaker.toFilename(name) : name);
    }

    private boolean getBoolean(Resource root2, Property p, boolean ifAbsent) {
        Resource r = FileModelAssembler.getUniqueResource(root2, p);
        return r == null ? ifAbsent : ((Object)r).equals(JA.True);
    }

    private String getDirectoryName(Resource root2) {
        return FileModelAssembler.getRequiredResource(root2, JA.directory).getURI().replaceFirst("file:", "");
    }
}

