/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.assemblers.InfModelAssembler;
import com.hp.hpl.jena.assembler.exceptions.NotUniqueException;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasonerFactory;

public class TestInfModelAssembler
extends AssemblerTestBase {
    public TestInfModelAssembler(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        return InfModelAssembler.class;
    }

    public void testLocationMapperAssemblerType() {
        this.testDemandsMinimalType(new InfModelAssembler(), JA.InfModel);
    }

    public void testMockReasonersDifferent() {
        Reasoner R = GenericRuleReasonerFactory.theInstance().create(null);
        TestInfModelAssembler.assertNotSame((Object)this.mockReasonerFactory(R), (Object)this.mockReasonerFactory(R));
    }

    public void testInfModel() {
        Assembler a = Assembler.infModel;
        Model m = a.openModel(this.resourceInModel("x rdf:type ja:InfModel"));
        TestInfModelAssembler.assertInstanceOf(InfModel.class, m);
    }

    public void testInfModelType() {
        this.testDemandsMinimalType(Assembler.infModel, JA.InfModel);
    }

    public void testGetsReasoner() {
        Reasoner R = GenericRuleReasonerFactory.theInstance().create(null);
        ReasonerFactory RF = this.mockReasonerFactory(R);
        AssemblerTestBase.FixedObjectAssembler mock = new AssemblerTestBase.FixedObjectAssembler(RF);
        Resource root2 = this.resourceInModel("x rdf:type ja:InfModel; x ja:reasoner R");
        InfModel m = (InfModel)Assembler.infModel.open(mock, root2);
        TestInfModelAssembler.assertSame((Object)R, (Object)m.getReasoner());
    }

    protected ReasonerFactory mockReasonerFactory(final Reasoner R) {
        return new ReasonerFactory(){

            public Reasoner create(Resource configuration) {
                return R;
            }

            public Model getCapabilities() {
                throw new RuntimeException("mock doesn't do getCapabilities");
            }

            public String getURI() {
                throw new RuntimeException("mock doesn't do getURI");
            }
        };
    }

    public void testGetsSpecifiedModel() {
        Model base = ModelFactory.createDefaultModel();
        Resource root2 = this.resourceInModel("x rdf:type ja:InfModel; x ja:baseModel M");
        AssemblerTestBase.NamedObjectAssembler mock = new AssemblerTestBase.NamedObjectAssembler(TestInfModelAssembler.resource("M"), base);
        InfModel inf = (InfModel)Assembler.infModel.open(mock, root2);
        TestInfModelAssembler.assertSame((Object)base.getGraph(), (Object)inf.getRawModel().getGraph());
    }

    public void testDetectsMultipleBaseModels() {
        Model base = ModelFactory.createDefaultModel();
        Resource root2 = this.resourceInModel("x rdf:type ja:InfModel; x ja:baseModel M; x ja:baseModel M2");
        AssemblerTestBase.FixedObjectAssembler mock = new AssemblerTestBase.FixedObjectAssembler(base);
        try {
            Assembler.infModel.open(mock, root2);
            TestInfModelAssembler.fail((String)"should detect multiple baseModels");
        }
        catch (NotUniqueException e2) {
            TestInfModelAssembler.assertEquals((Object)JA.baseModel, (Object)e2.getProperty());
            TestInfModelAssembler.assertEquals((Object)TestInfModelAssembler.resource("x"), (Object)e2.getRoot());
        }
    }

    public void testDetectsMultipleReasoners() {
        Resource root2 = this.resourceInModel("x rdf:type ja:InfModel; x ja:reasoner R; x ja:reasoner R2");
        AssemblerTestBase.FixedObjectAssembler mock = new AssemblerTestBase.FixedObjectAssembler(null);
        try {
            Assembler.infModel.open(mock, root2);
            TestInfModelAssembler.fail((String)"should detect multiple reasoners");
        }
        catch (NotUniqueException e2) {
            TestInfModelAssembler.assertEquals((Object)JA.reasoner, (Object)e2.getProperty());
            TestInfModelAssembler.assertEquals((Object)TestInfModelAssembler.resource("x"), (Object)e2.getRoot());
        }
    }
}

