/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.SQLCache;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.FilterIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetIterator
implements ExtendedIterator {
    protected ResultSet m_resultSet;
    protected SQLCache m_sqlCache;
    protected PreparedStatement m_statement;
    protected boolean m_statementClean = true;
    protected String m_opname;
    protected ArrayList m_row;
    protected int m_nCols;
    protected boolean m_finished = false;
    protected boolean m_prefetched = false;
    protected static Log logger = LogFactory.getLog(ResultSetIterator.class);

    public ResultSetIterator() {
        this.m_finished = true;
    }

    public ResultSetIterator(ResultSet resultSet, PreparedStatement sourceStatement, SQLCache cache, String opname) {
        this.m_resultSet = resultSet;
        this.m_sqlCache = cache;
        this.m_statement = sourceStatement;
        this.m_opname = opname;
    }

    public ResultSetIterator(ResultSet resultSet, PreparedStatement sourceStatement) {
        this.m_resultSet = resultSet;
        this.m_statement = sourceStatement;
    }

    public void reset(ResultSet resultSet, PreparedStatement sourceStatement, SQLCache cache, String opname) {
        this.m_resultSet = resultSet;
        this.m_sqlCache = cache;
        this.m_statement = sourceStatement;
        this.m_opname = opname;
        this.m_finished = false;
        this.m_prefetched = false;
        this.m_row = null;
        this.m_statementClean = true;
    }

    public void reset(ResultSet resultSet, PreparedStatement sourceStatement) {
        this.m_resultSet = resultSet;
        this.m_sqlCache = null;
        this.m_statement = sourceStatement;
        this.m_opname = null;
        this.m_finished = false;
        this.m_prefetched = false;
        this.m_row = null;
        this.m_statementClean = false;
    }

    public boolean hasNext() {
        if (!this.m_finished && !this.m_prefetched) {
            this.moveForward();
        }
        return !this.m_finished;
    }

    public Object removeNext() {
        this.cantRemove();
        return null;
    }

    public Object next() {
        if (!this.m_finished && !this.m_prefetched) {
            this.moveForward();
        }
        this.m_prefetched = false;
        if (this.m_finished) {
            throw new NoSuchElementException();
        }
        return this.getRow();
    }

    public void remove() {
        this.cantRemove();
    }

    protected void cantRemove() {
        throw new UnsupportedOperationException("ResultSetIterator can't remove database rows");
    }

    protected void moveForward() {
        try {
            if (!this.m_finished && this.m_resultSet.next()) {
                this.extractRow();
                this.m_prefetched = true;
            } else {
                this.close();
            }
        }
        catch (Exception e2) {
            logger.warn("Problem in iterator over db result set, op = " + this.m_opname, e2);
            throw new JenaException(e2);
        }
    }

    protected void extractRow() throws Exception {
        int i;
        if (this.m_row == null) {
            this.m_nCols = this.m_resultSet.getMetaData().getColumnCount();
            this.m_row = new ArrayList(this.m_nCols);
            for (i = 0; i < this.m_nCols; ++i) {
                this.m_row.add(null);
            }
        }
        for (i = 0; i < this.m_nCols; ++i) {
            this.m_row.set(i, this.m_resultSet.getObject(i + 1));
        }
    }

    protected Object getRow() {
        return this.m_row;
    }

    public void close() {
        if (!this.m_finished) {
            if (this.m_resultSet != null) {
                try {
                    this.m_resultSet.close();
                    this.m_resultSet = null;
                }
                catch (SQLException e2) {
                    logger.warn("Error while finalizing result set iterator", e2);
                }
            }
            if (this.m_statementClean) {
                if (this.m_sqlCache != null && this.m_opname != null) {
                    this.m_sqlCache.returnPreparedSQLStatement(this.m_statement);
                } else {
                    try {
                        this.m_statement.close();
                    }
                    catch (SQLException e3) {
                        logger.warn("Error while finalizing result set iterator", e3);
                    }
                }
            }
        }
        this.m_finished = true;
    }

    public Object getSingleton() throws SQLException {
        List row = (List)this.next();
        this.close();
        return row.get(0);
    }

    protected void finalize() throws SQLException {
        if (!this.m_finished && this.m_resultSet != null) {
            this.close();
        }
    }

    public ExtendedIterator andThen(ClosableIterator other) {
        return NiceIterator.andThen(this, other);
    }

    public Set toSet() {
        return NiceIterator.asSet(this);
    }

    public List toList() {
        return NiceIterator.asList(this);
    }

    public ExtendedIterator filterKeep(Filter f) {
        return new FilterIterator(f, this);
    }

    public ExtendedIterator filterDrop(final Filter f) {
        Filter notF = new Filter(){

            public boolean accept(Object x) {
                return !f.accept(x);
            }
        };
        return new FilterIterator(notF, this);
    }

    public ExtendedIterator mapWith(Map1 map1) {
        return new Map1Iterator(map1, this);
    }
}

