/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import junit.framework.TestSuite;

public class TestNsPrefix
extends ModelTestBase {
    public TestNsPrefix(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestNsPrefix.class);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    protected PrefixMapping getMapping() {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        return ModelRDB.createModel(conn);
    }

    public void testSinglePrefix() throws Exception {
        String testPrefix = "testPrefix";
        String testURI = "http://someTestURI#";
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel(conn);
        TestNsPrefix.assertEquals((int)0, (int)m.getNsPrefixMap().size());
        m.setNsPrefix(testPrefix, testURI);
        TestNsPrefix.assertEquals((int)1, (int)m.getNsPrefixMap().size());
        TestNsPrefix.assertEquals((String)testURI, (String)m.getNsPrefixURI(testPrefix));
        m.close();
        conn.close();
    }

    public void testDuplicatePrefix() throws Exception {
        String testPrefix = "testPrefix";
        String testURI = "http://someTestURI#";
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel(conn);
        TestNsPrefix.assertEquals((int)0, (int)m.getNsPrefixMap().size());
        m.setNsPrefix(testPrefix, testURI);
        m.setNsPrefix(testPrefix, testURI);
        TestNsPrefix.assertEquals((int)1, (int)m.getNsPrefixMap().size());
        TestNsPrefix.assertEquals((String)testURI, (String)m.getNsPrefixURI(testPrefix));
        m.close();
        conn.close();
    }

    public void testChangingPrefixMapping() throws Exception {
        String testPrefix = "testPrefix";
        String testURI = "http://someTestURI#";
        String someOtherTestURI = "http://someOtherTestURI#";
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel(conn);
        TestNsPrefix.assertEquals((int)0, (int)m.getNsPrefixMap().size());
        m.setNsPrefix(testPrefix, testURI);
        m.setNsPrefix(testPrefix, someOtherTestURI);
        TestNsPrefix.assertEquals((int)1, (int)m.getNsPrefixMap().size());
        TestNsPrefix.assertDiffer(testURI, m.getNsPrefixURI(testPrefix));
        TestNsPrefix.assertEquals((String)someOtherTestURI, (String)m.getNsPrefixURI(testPrefix));
        m.close();
        conn.close();
    }

    public void testPersistenceOfPrefixes() throws Exception {
        String testPrefix = "testPrefix";
        String testURI = "http://someTestURI#";
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel(conn);
        TestNsPrefix.assertEquals((int)0, (int)m.getNsPrefixMap().size());
        m.setNsPrefix(testPrefix, testURI);
        TestNsPrefix.assertEquals((int)1, (int)m.getNsPrefixMap().size());
        TestNsPrefix.assertEquals((String)testURI, (String)m.getNsPrefixURI(testPrefix));
        m.close();
        ModelRDB m2 = ModelRDB.createModel(conn, "myName");
        TestNsPrefix.assertEquals((int)0, (int)m2.getNsPrefixMap().size());
        m2.remove();
        m2.close();
        ModelRDB m3 = ModelRDB.open(conn);
        TestNsPrefix.assertEquals((int)1, (int)m3.getNsPrefixMap().size());
        TestNsPrefix.assertEquals((String)testURI, (String)m3.getNsPrefixURI(testPrefix));
        m3.close();
        conn.close();
    }

    public void testIdependenceOfPrefixes() throws Exception {
        String testPrefix1 = "testPrefix1";
        String testURI1 = "http://someTestURI1#";
        String testPrefix2 = "testPrefix2";
        String testURI2 = "http://someTestURI2#";
        String testPrefix3 = "testPrefix3";
        String testURI3 = "http://someTestURI3#";
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel(conn);
        TestNsPrefix.assertEquals((int)0, (int)m.getNsPrefixMap().size());
        m.setNsPrefix(testPrefix1, testURI1);
        m.setNsPrefix(testPrefix2, testURI2);
        TestNsPrefix.assertEquals((int)2, (int)m.getNsPrefixMap().size());
        TestNsPrefix.assertEquals((String)testURI1, (String)m.getNsPrefixURI(testPrefix1));
        TestNsPrefix.assertEquals((String)testURI2, (String)m.getNsPrefixURI(testPrefix2));
        ModelRDB m2 = ModelRDB.createModel(conn, "secondGraph");
        TestNsPrefix.assertEquals((int)0, (int)m2.getNsPrefixMap().size());
        m2.setNsPrefix(testPrefix2, testURI2);
        m2.setNsPrefix(testPrefix3, testURI3);
        TestNsPrefix.assertEquals((int)2, (int)m2.getNsPrefixMap().size());
        TestNsPrefix.assertEquals((String)testURI2, (String)m2.getNsPrefixURI(testPrefix2));
        TestNsPrefix.assertEquals((String)testURI3, (String)m2.getNsPrefixURI(testPrefix3));
        TestNsPrefix.assertEquals((int)2, (int)m.getNsPrefixMap().size());
        TestNsPrefix.assertEquals((String)testURI1, (String)m.getNsPrefixURI(testPrefix1));
        TestNsPrefix.assertEquals((String)testURI2, (String)m.getNsPrefixURI(testPrefix2));
        m2.remove();
        m2.close();
        m2 = null;
        TestNsPrefix.assertEquals((int)2, (int)m.getNsPrefixMap().size());
        TestNsPrefix.assertEquals((String)testURI1, (String)m.getNsPrefixURI(testPrefix1));
        TestNsPrefix.assertEquals((String)testURI2, (String)m.getNsPrefixURI(testPrefix2));
        m.close();
        m = null;
        ModelRDB m3 = ModelRDB.open(conn);
        TestNsPrefix.assertEquals((int)2, (int)m3.getNsPrefixMap().size());
        TestNsPrefix.assertEquals((String)testURI1, (String)m3.getNsPrefixURI(testPrefix1));
        TestNsPrefix.assertEquals((String)testURI2, (String)m3.getNsPrefixURI(testPrefix2));
        m3.close();
        conn.close();
    }

    public void testPersistedChangedPrefixes() throws Exception {
        String testPrefix1 = "testPrefix1";
        String testURI1 = "http://someTestURI/1#";
        String testURI1b = "http://someTestURI/1b#";
        String testPrefix2 = "testPrefix2";
        String testURI2 = "http://someTestURI/2#";
        String testPrefix3 = "testPrefix3";
        String testURI3 = "http://someTestURI/3#";
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel(conn);
        TestNsPrefix.assertEquals((int)0, (int)m.getNsPrefixMap().size());
        m.setNsPrefix(testPrefix1, testURI1);
        m.setNsPrefix(testPrefix2, testURI2);
        TestNsPrefix.assertEquals((int)2, (int)m.getNsPrefixMap().size());
        TestNsPrefix.assertEquals((String)testURI1, (String)m.getNsPrefixURI(testPrefix1));
        TestNsPrefix.assertEquals((String)testURI2, (String)m.getNsPrefixURI(testPrefix2));
        m.close();
        m = null;
        ModelRDB m2 = ModelRDB.open(conn);
        TestNsPrefix.assertEquals((int)2, (int)m2.getNsPrefixMap().size());
        TestNsPrefix.assertEquals((String)testURI1, (String)m2.getNsPrefixURI(testPrefix1));
        TestNsPrefix.assertEquals((String)testURI2, (String)m2.getNsPrefixURI(testPrefix2));
        m2.setNsPrefix(testPrefix1, testURI1b);
        m2.setNsPrefix(testPrefix3, testURI3);
        TestNsPrefix.assertEquals((int)3, (int)m2.getNsPrefixMap().size());
        TestNsPrefix.assertEquals((String)testURI1b, (String)m2.getNsPrefixURI(testPrefix1));
        TestNsPrefix.assertEquals((String)testURI2, (String)m2.getNsPrefixURI(testPrefix2));
        TestNsPrefix.assertEquals((String)testURI3, (String)m2.getNsPrefixURI(testPrefix3));
        m2.close();
        m2 = null;
        ModelRDB m3 = ModelRDB.open(conn);
        TestNsPrefix.assertEquals((int)3, (int)m3.getNsPrefixMap().size());
        TestNsPrefix.assertEquals((String)testURI1b, (String)m3.getNsPrefixURI(testPrefix1));
        TestNsPrefix.assertEquals((String)testURI2, (String)m3.getNsPrefixURI(testPrefix2));
        TestNsPrefix.assertEquals((String)testURI3, (String)m3.getNsPrefixURI(testPrefix3));
        m3.close();
        conn.close();
    }

    public void testCopyPersistentPrefixMapping() throws Exception {
        String testPrefix1 = "testPrefix1";
        String testPrefix2 = "testPrefix2";
        String testURI1 = "http://someTestURI/1#";
        String testURI2 = "http://someTestURI/2#";
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel(conn);
        TestNsPrefix.assertEquals((int)0, (int)m.getNsPrefixMap().size());
        m.setNsPrefix(testPrefix1, testURI1);
        m.setNsPrefix(testPrefix2, testURI2);
        TestNsPrefix.assertEquals((int)2, (int)m.getNsPrefixMap().size());
        TestNsPrefix.assertEquals((String)testURI1, (String)m.getNsPrefixURI(testPrefix1));
        TestNsPrefix.assertEquals((String)testURI2, (String)m.getNsPrefixURI(testPrefix2));
        ModelRDB m2 = ModelRDB.createModel(conn, "secondModel");
        TestNsPrefix.assertEquals((int)0, (int)m2.getNsPrefixMap().size());
        m2.setNsPrefixes(m.getNsPrefixMap());
        TestNsPrefix.assertEquals((int)2, (int)m2.getNsPrefixMap().size());
        TestNsPrefix.assertEquals((String)testURI1, (String)m2.getNsPrefixURI(testPrefix1));
        TestNsPrefix.assertEquals((String)testURI2, (String)m2.getNsPrefixURI(testPrefix2));
        m.close();
        m2.close();
        conn.close();
    }

    public void testCopyMemoryPrefixMapping() throws Exception {
        String testPrefix1 = "testPrefix1";
        String testPrefix2 = "testPrefix2";
        String testURI1 = "http://someTestURI/1#";
        String testURI2 = "http://someTestURI/2#";
        PrefixMappingImpl myMap = new PrefixMappingImpl();
        myMap.setNsPrefix(testPrefix1, testURI1);
        myMap.setNsPrefix(testPrefix2, testURI2);
        TestNsPrefix.assertEquals((int)2, (int)myMap.getNsPrefixMap().size());
        TestNsPrefix.assertEquals((String)testURI1, (String)myMap.getNsPrefixURI(testPrefix1));
        TestNsPrefix.assertEquals((String)testURI2, (String)myMap.getNsPrefixURI(testPrefix2));
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel(conn);
        TestNsPrefix.assertEquals((int)0, (int)m.getNsPrefixMap().size());
        m.setNsPrefixes(myMap);
        TestNsPrefix.assertEquals((int)2, (int)m.getNsPrefixMap().size());
        TestNsPrefix.assertEquals((String)testURI1, (String)m.getNsPrefixURI(testPrefix1));
        TestNsPrefix.assertEquals((String)testURI2, (String)m.getNsPrefixURI(testPrefix2));
        m.close();
        conn.close();
    }

    public void testSecondPrefixDoesNotRemoveSharedURI() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel(conn);
        String someURI = "urn:x-hp:db-unit-testing:xxx";
        m.setNsPrefix("p1", someURI);
        m.setNsPrefix("p2", someURI);
        m.close();
        conn.close();
        IDBConnection conn2 = TestConnection.makeTestConnection();
        ModelRDB m2 = ModelRDB.open(conn2);
        TestNsPrefix.assertEquals((String)someURI, (String)m2.getNsPrefixURI("p1"));
        TestNsPrefix.assertEquals((String)someURI, (String)m2.getNsPrefixURI("p2"));
        m2.close();
        conn2.close();
    }
}

