/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.ConnectionDescription;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactoryBase;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.HashMap;
import java.util.Map;

public class TestRDBAssemblerContents
extends AssemblerTestBase {
    private static final String url = ModelFactoryBase.guessDBURL();
    private static final String user = ModelFactoryBase.guessDBUser();
    private static final String password = ModelFactoryBase.guessDBPassword();
    private static final String type = ModelFactoryBase.guessDBType();
    private static final String driver = ModelFactoryBase.guessDBDriver();

    public TestRDBAssemblerContents(String name) {
        super(name);
    }

    public void testCreatesEmptyModel() {
        ConnectionDescription cd = new ConnectionDescription("db", url, user, password, type);
        Resource root2 = this.resourceInModel("db rdf:type ja:RDBModel; db ja:connection C; db ja:modelName 'CreatesEmptyModel'");
        AssemblerTestBase.NamedObjectAssembler ca = new AssemblerTestBase.NamedObjectAssembler(TestRDBAssemblerContents.resource("C"), cd);
        Model assembled = (Model)Assembler.rdbModel.open(ca, root2, Mode.ANY);
        TestRDBAssemblerContents.assertIsoModels(TestRDBAssemblerContents.modelWithStatements(""), assembled);
        assembled.close();
    }

    public void testCreatesInitialisedModel() {
        ConnectionDescription cd = new ConnectionDescription("db", url, user, password, type);
        Resource root2 = this.resourceInModel("db rdf:type ja:RDBModel; db ja:connection C; db ja:modelName 'CreatesInitialisedModel'; db ja:quotedContent X; X rdf:type T");
        AssistantAssembler ca = new AssistantAssembler(Assembler.content).with(TestRDBAssemblerContents.resource("C"), cd);
        Model assembled = (Model)Assembler.rdbModel.open(ca, root2, Mode.ANY);
        TestRDBAssemblerContents.assertIsoModels(TestRDBAssemblerContents.modelWithStatements("X rdf:type T"), assembled);
        assembled.close();
    }

    public void testOpensAndInitialisesModel() {
        ConnectionDescription cd = new ConnectionDescription("db", url, user, password, type);
        Resource root2 = this.resourceInModel("db rdf:type ja:RDBModel; db ja:connection C; db ja:modelName 'OpensAndInitialisesModel'; db ja:quotedContent X; X rdf:type T");
        AssistantAssembler ca = new AssistantAssembler(Assembler.content).with(TestRDBAssemblerContents.resource("C"), cd);
        Model assembled = (Model)Assembler.rdbModel.open(ca, root2, Mode.ANY);
        TestRDBAssemblerContents.assertIsoModels(TestRDBAssemblerContents.modelWithStatements("X rdf:type T"), assembled);
        assembled.close();
    }

    public void testCreatesAndInitialisesModel() {
        ConnectionDescription cd = new ConnectionDescription("db", url, user, password, type);
        this.ensureAbsent(cd, "CreatesAndInitialisesModel");
        Resource root2 = this.resourceInModel("db rdf:type ja:RDBModel; db ja:connection C; db ja:modelName 'CreatesAndInitialisesModel'; db ja:initialContent Q; Q ja:quotedContent X; X rdf:type T");
        AssistantAssembler ca = new AssistantAssembler(Assembler.content).with(TestRDBAssemblerContents.resource("C"), cd);
        Model assembled = (Model)Assembler.rdbModel.open(ca, root2, Mode.ANY);
        TestRDBAssemblerContents.assertIsoModels(TestRDBAssemblerContents.modelWithStatements("X rdf:type T"), assembled);
        assembled.close();
    }

    public void testOpensAndDoesNotInitialiseModel() {
        ConnectionDescription cd = new ConnectionDescription("db", url, user, password, type);
        this.ensurePresent(cd, "OpensAndDoesNotInitialiseModel");
        Resource root2 = this.resourceInModel("db rdf:type ja:RDBModel; db ja:connection C; db ja:modelName 'OpensAndDoesNotInitialiseModel'; db ja:initialContent Q; Q ja:quotedContent X; X rdf:type T");
        AssistantAssembler ca = new AssistantAssembler(Assembler.content).with(TestRDBAssemblerContents.resource("C"), cd);
        Model assembled = (Model)Assembler.rdbModel.open(ca, root2, Mode.ANY);
        TestRDBAssemblerContents.assertIsoModels(TestRDBAssemblerContents.modelWithStatements(""), assembled);
        assembled.close();
    }

    private void ensurePresent(ConnectionDescription cd, String modelName) {
        IDBConnection ic = cd.getConnection();
        if (!ic.containsModel(modelName)) {
            ModelRDB.createModel(ic, modelName).close();
        }
    }

    private void ensureAbsent(ConnectionDescription cd, String modelName) {
        IDBConnection ic = cd.getConnection();
        if (ic.containsModel(modelName)) {
            ModelRDB.open(ic, modelName).remove();
        }
    }

    static {
        try {
            Class.forName(driver);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    static class AssistantAssembler
    extends AssemblerBase {
        protected final Assembler general;
        protected final Map map = new HashMap();

        public AssistantAssembler(Assembler general) {
            this.general = general;
        }

        public AssistantAssembler with(Resource name, Object value) {
            this.map.put(name, value);
            return this;
        }

        public Object open(Assembler a, Resource root2, Mode mode) {
            Object fromMap = this.map.get(root2);
            return fromMap == null ? this.general.open(a, root2, mode) : fromMap;
        }
    }
}

