/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.BaseGraphMaker;
import com.hp.hpl.jena.graph.impl.FileGraph;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FileGraphMaker
extends BaseGraphMaker
implements FileGraph.NotifyOnClose {
    protected String fileBase;
    protected boolean deleteOnClose;
    protected Map created = CollectionFactory.createHashedMap();
    protected Set toDelete = CollectionFactory.createHashedSet();
    private static Map1 unconvert = new Map1(){

        public Object map1(Object x) {
            return FileGraphMaker.toGraphname((String)x);
        }
    };

    public FileGraphMaker(String root2) {
        this(root2, ReificationStyle.Minimal);
    }

    public FileGraphMaker(String root2, ReificationStyle style) {
        this(root2, style, false);
    }

    public FileGraphMaker(String root2, ReificationStyle style, boolean deleteOnClose) {
        super(style);
        this.fileBase = root2;
        this.deleteOnClose = deleteOnClose;
    }

    public Node getMakerClass() {
        return JenaModelSpec.FileMakerSpec.asNode();
    }

    public String getFileBase() {
        return this.fileBase;
    }

    protected void augmentDescription(Graph g, Node self) {
        g.add(Triple.create(self, JenaModelSpec.fileBase.asNode(), Node.createLiteral(this.fileBase, "", false)));
    }

    public Graph createGraph() {
        return FileGraph.create();
    }

    public Graph createGraph(String name, boolean strict) {
        File f = this.withRoot(name);
        FileGraph already = (FileGraph)this.created.get(f);
        if (already == null) {
            return this.remember(f, new FileGraph(this, f, true, strict, this.style));
        }
        if (strict) {
            throw new AlreadyExistsException(name);
        }
        return already.openAgain();
    }

    public Graph openGraph(String name, boolean strict) {
        File f = this.withRoot(name);
        return this.created.containsKey(f) ? ((FileGraph)this.created.get(f)).openAgain() : this.remember(f, new FileGraph(this, f, false, strict, this.style));
    }

    public void notifyClosed(File f) {
        this.toDelete.add(f);
        this.created.remove(f);
    }

    private File withRoot(String name) {
        return new File(this.fileBase, FileGraphMaker.toFilename(name));
    }

    public static String toFilename(String name) {
        return name.replaceAll("_", "_U").replaceAll("/", "_S").replaceAll(":", "_C");
    }

    public static String toGraphname(String fileName) {
        return fileName.replaceAll("_C", ":").replaceAll("_S", "/").replaceAll("_U", "_");
    }

    public void removeGraph(String name) {
        this.forget(this.withRoot(name)).delete();
    }

    private FileGraph remember(File f, FileGraph g) {
        this.created.put(f, g);
        return g;
    }

    private File forget(File f) {
        this.created.remove(f);
        return f;
    }

    public boolean hasGraph(String name) {
        File f = this.withRoot(name);
        return this.created.containsKey(f) || f.exists();
    }

    public void close() {
        if (this.deleteOnClose) {
            this.deleteFiles(this.created.keySet().iterator());
            this.deleteFiles(this.toDelete.iterator());
        }
    }

    protected void deleteFiles(Iterator it) {
        while (it.hasNext()) {
            ((File)it.next()).delete();
        }
    }

    public static FilenameFilter graphName() {
        return new FilenameFilter(){

            public boolean accept(File file, String name) {
                return !new File(file, name).isDirectory() && FileGraph.isPlausibleGraphName(name);
            }
        };
    }

    public ExtendedIterator listGraphs() {
        String[] fileNames = new File(this.fileBase).list(FileGraphMaker.graphName());
        Set allNames = CollectionFactory.createHashedSet(Arrays.asList(fileNames));
        Iterator it = this.created.keySet().iterator();
        while (it.hasNext()) {
            allNames.add(((File)it.next()).getName());
        }
        return WrappedIterator.create(allNames.iterator()).mapWith(unconvert);
    }
}

