/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.test.QueryTestBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestQueryReification
extends QueryTestBase {
    public TestQueryReification(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestQueryReification.class);
    }

    public Graph getGraph() {
        return Factory.createDefaultGraph();
    }

    public Graph getGraph(String triples) {
        return TestQueryReification.graphAdd(this.getGraph(), triples);
    }

    public void testS() {
        Graph g = this.geGraphSPO();
        Query q = new Query().addMatch(Query.X, RDF.Nodes.subject, Query.S);
        ExtendedIterator it = q.executeBindings(g, new Node[]{Query.X, Query.S}).mapWith(this.select(1));
        TestQueryReification.assertEquals((Object)this.nodeSet("S"), (Object)TestQueryReification.iteratorToSet(it));
    }

    public void testP() {
        Graph g = this.geGraphSPO();
        Query q = new Query().addMatch(Query.X, RDF.Nodes.predicate, Query.P);
        ExtendedIterator it = q.executeBindings(g, new Node[]{Query.X, Query.P}).mapWith(this.select(1));
        TestQueryReification.assertEquals((Object)this.nodeSet("P"), (Object)TestQueryReification.iteratorToSet(it));
    }

    public void testO() {
        Graph g = this.geGraphSPO();
        Query q = new Query().addMatch(Query.X, RDF.Nodes.object, Query.O);
        ExtendedIterator it = q.executeBindings(g, new Node[]{Query.X, Query.O}).mapWith(this.select(1));
        TestQueryReification.assertEquals((Object)this.nodeSet("O"), (Object)TestQueryReification.iteratorToSet(it));
    }

    protected Graph geGraphSPO() {
        return this.getGraph("_x rdf:subject S; _x rdf:predicate P; _x rdf:object O; _x rdf:type rdf:Statement");
    }
}

