/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIException;
import com.hp.hpl.jena.iri.IRIFactoryI;
import com.hp.hpl.jena.iri.ViolationCodes;
import com.hp.hpl.jena.iri.impl.IRIFactoryImpl;
import java.io.UnsupportedEncodingException;

public class IRIFactory
extends IRIFactoryImpl
implements IRIFactoryI {
    private static IRIFactory jenaFactory;
    private static IRIFactory theSemWebFactory;
    private static IRIFactory theURIFactory;
    private static IRIFactory theIRIFactory;
    private boolean usingSpecXMLSchema = false;

    public static IRIFactory iriImplementation() {
        return theIRIFactory;
    }

    public static IRIFactory uriImplementation() {
        return theURIFactory;
    }

    public static IRIFactory semanticWebImplementation() {
        return theSemWebFactory;
    }

    public static IRIFactory jenaImplementation() {
        return jenaFactory;
    }

    public IRIFactory() {
    }

    public IRIFactory(IRIFactory template) {
        super(template);
        this.usingSpecXMLSchema = template.usingSpecXMLSchema;
    }

    public void setSameSchemeRelativeReferences(String scheme) {
        super.setSameSchemeRelativeReferences(scheme);
    }

    public void allowUnwiseCharacters() {
        boolean warning = this.getAsErrors(2) || this.getAsWarnings(2);
        this.setIsError(4, false);
        this.setIsError(17, false);
        this.setIsWarning(4, warning);
        this.setIsWarning(17, warning);
        if (!this.usingSpecXMLSchema) {
            this.setIsError(18, false);
            this.setIsWarning(18, warning);
        }
    }

    public void setQueryCharacterRestrictions(boolean restrict) {
        throw new UnsupportedOperationException("unimplemented");
    }

    public void setEncoding(String enc) throws UnsupportedEncodingException {
        super.setEncoding(enc);
    }

    public IRI create(String scheme, String userInfo, String host, int port, String path, String query2, String fragment) {
        return null;
    }

    public IRI create(String scheme, String authority, String path, String query2, String fragment) {
        return null;
    }

    public IRI construct(String scheme, String userInfo, String host, int port, String path, String query2, String fragment) throws IRIException {
        return this.throwAnyErrors(this.create(scheme, userInfo, host, port, path, query2, fragment));
    }

    public IRI construct(String scheme, String authority, String path, String query2, String fragment) throws IRIException {
        return this.throwAnyErrors(this.create(scheme, authority, path, query2, fragment));
    }

    public boolean isError(int code) {
        return (this.errors & 1L << code) != 0L;
    }

    public boolean isWarning(int code) {
        return (this.warnings & 1L << code) != 0L;
    }

    public void setIsError(int code, boolean set) {
        this.initializing();
        if (set) {
            this.errors |= 1L << code;
            this.setIsWarning(code, false);
        } else {
            this.errors &= 1L << code ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public void setIsWarning(int code, boolean set) {
        this.initializing();
        if (set) {
            this.warnings |= 1L << code;
            this.setIsError(code, false);
        } else {
            this.warnings &= 1L << code ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public boolean ignoring(int code) {
        return !this.isError(code) && !this.isWarning(code);
    }

    public void useSpecificationURI(boolean asErrors) {
        this.useSpec("URI", asErrors);
    }

    public void useSpecificationIRI(boolean asErrors) {
        this.useSpec("IRI", asErrors);
    }

    public void useSpecificationRDF(boolean asErrors) {
        this.useSpec("RDF", asErrors);
    }

    public void useSpecificationXMLSchema(boolean asErrors) {
        this.usingSpecXMLSchema = true;
        this.useSpec("Schema", asErrors);
    }

    public void useSpecificationXMLSystemID(boolean asErrors) {
        this.useSpec("XML", asErrors);
    }

    public void useSpecificationXLink(boolean asErrors) {
        this.useSpec("XLink", asErrors);
    }

    public void shouldViolation(boolean isError, boolean isWarning) {
        this.setViolation(0, isError, isWarning);
    }

    public void securityViolation(boolean isError, boolean isWarning) {
        this.setViolation(3, isError, isWarning);
    }

    public void dnsViolation(boolean isError, boolean isWarning) {
        this.setViolation(1, isError, isWarning);
    }

    public void mintingViolation(boolean isError, boolean isWarning) {
        this.setViolation(2, isError, isWarning);
    }

    public void useSchemeSpecificRules(String scheme, boolean asErrors) {
        super.useSchemeSpecificRules(scheme, asErrors);
    }

    static {
        new ViolationCodes.Initialize();
        theIRIFactory = new IRIFactory();
        theIRIFactory.useSpecificationIRI(true);
        theIRIFactory.useSchemeSpecificRules("*", true);
        theIRIFactory.create("");
        jenaFactory = new IRIFactory();
        jenaFactory.shouldViolation(false, false);
        jenaFactory.securityViolation(false, false);
        jenaFactory.useSpecificationRDF(false);
        jenaFactory.setIsError(45, false);
        jenaFactory.setIsWarning(45, false);
        jenaFactory.setIsError(5, false);
        jenaFactory.setIsWarning(5, false);
        jenaFactory.useSchemeSpecificRules("http", true);
        jenaFactory.create("");
        theURIFactory = new IRIFactory();
        theURIFactory.useSpecificationURI(true);
        theURIFactory.useSchemeSpecificRules("*", true);
        theURIFactory.create("");
        theSemWebFactory = new IRIFactory();
        theSemWebFactory.useSpecificationRDF(true);
        theSemWebFactory.useSpecificationIRI(true);
        theSemWebFactory.useSpecificationXLink(true);
        theSemWebFactory.useSchemeSpecificRules("*", true);
        theSemWebFactory.setIsError(8, true);
        theSemWebFactory.create("");
    }
}

