/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OntTools {
    private static Log log = LogFactory.getLog(OntTools.class);

    public static OntClass getLCA(OntModel m, OntClass u, OntClass v) {
        Resource root2 = m.getProfile().THING();
        if (root2 == null) {
            throw new JenaException("The given OntModel has a language profile that does not define a generic root class (such as owl:Thing)");
        }
        root2 = (Resource)root2.inModel(m);
        return OntTools.getLCA(m, (OntClass)root2.as(OntClass.class), u, v);
    }

    public static OntClass getLCA(OntModel m, OntClass root2, OntClass u, OntClass v) {
        if (u.equals(root2) || v.equals(root2)) {
            return root2;
        }
        if (u.hasSubClass(v)) {
            return u;
        }
        if (v.hasSubClass(u)) {
            return v;
        }
        LCAIndex index = new LCAIndex();
        OntTools.lca(root2, u, v, index);
        return (OntClass)index.getLCA(u, v);
    }

    public static Path findShortestPath(Model m, Resource start, RDFNode end, Filter onPath) {
        LinkedList<Path> bfs = new LinkedList<Path>();
        HashSet<Resource> seen = new HashSet<Resource>();
        ExtendedIterator i = m.listStatements(start, null, (RDFNode)null).filterKeep(onPath);
        while (i.hasNext()) {
            bfs.add(new Path().append((Statement)i.next()));
        }
        Path solution = null;
        while (solution == null && !bfs.isEmpty()) {
            Path candidate = (Path)bfs.remove(0);
            if (candidate.hasTerminus(end)) {
                solution = candidate;
                continue;
            }
            Resource terminus = candidate.getTerminalResource();
            if (terminus == null) continue;
            seen.add(terminus);
            ExtendedIterator i2 = terminus.listProperties().filterKeep(onPath);
            while (i2.hasNext()) {
                Statement link = (Statement)i2.next();
                if (seen.contains(link.getObject())) continue;
                bfs.add(candidate.append(link));
            }
        }
        return solution;
    }

    public static List namedHierarchyRoots(OntModel m) {
        ArrayList nhr = new ArrayList();
        ArrayList ahr = new ArrayList();
        OntTools.partitionByNamed(m.listHierarchyRootClasses(), nhr, ahr);
        while (!ahr.isEmpty()) {
            OntClass c = (OntClass)ahr.remove(0);
            OntTools.partitionByNamed(c.listSubClasses(true), nhr, ahr);
        }
        return nhr;
    }

    protected static DisjointSet lca(OntClass cls, OntClass uCls, OntClass vCls, LCAIndex index) {
        log.debug("Entering lca(), cls = " + cls);
        DisjointSet clsSet = index.getSet(cls);
        if (clsSet.isBlack()) {
            return clsSet;
        }
        clsSet.setAncestor(clsSet);
        ExtendedIterator i = cls.listSubClasses(true);
        while (i.hasNext()) {
            OntClass child = (OntClass)i.next();
            if (child.equals(cls) || child.equals(cls.getProfile().NOTHING())) continue;
            DisjointSet v = OntTools.lca(child, uCls, vCls, index);
            clsSet.union(v);
            clsSet.find().setAncestor(clsSet);
        }
        clsSet.setBlack();
        if (cls.equals(uCls)) {
            OntTools.checkSolution(uCls, vCls, index);
        } else if (cls.equals(vCls)) {
            OntTools.checkSolution(vCls, uCls, index);
        }
        return clsSet;
    }

    protected static void checkSolution(OntClass uCls, OntClass vCls, LCAIndex index) {
        DisjointSet vSet = index.getSet(vCls);
        DisjointSet uSet = index.getSet(uCls);
        if (vSet != null && vSet.isBlack() && !vSet.used() && uSet != null && uSet.isBlack() && !uSet.used()) {
            vSet.setUsed();
            uSet.setUsed();
            log.debug("Found LCA: u = " + uCls + ", v = " + vCls);
            OntClass lca = (OntClass)vSet.find().getAncestor().getNode();
            log.debug("Found LCA: lca = " + lca);
            index.setLCA(uCls, vCls, lca);
        }
    }

    protected static void partitionByNamed(Iterator i, List named, List anon) {
        while (i.hasNext()) {
            OntClass c = (OntClass)i.next();
            (c.isAnon() ? anon : named).add(c);
        }
    }

    public static class PredicatesFilter
    extends Filter {
        public Collection m_preds;

        public PredicatesFilter(Collection preds) {
            this.m_preds = preds;
        }

        public PredicatesFilter(Property[] preds) {
            this.m_preds = new HashSet();
            for (int i = 0; i < preds.length; ++i) {
                this.m_preds.add(preds[i]);
            }
        }

        public PredicatesFilter(Property pred) {
            this.m_preds = new HashSet();
            this.m_preds.add(pred);
        }

        public boolean accept(Object s) {
            return this.m_preds.contains(((Statement)s).getPredicate());
        }
    }

    public static class Path
    extends ArrayList {
        public Path() {
        }

        public Path(Path basePath) {
            super(basePath);
        }

        public Statement getStatement(int i) {
            return (Statement)this.get(i);
        }

        public Path append(Statement s) {
            Path newPath = new Path(this);
            newPath.add(s);
            return newPath;
        }

        public boolean hasTerminus(RDFNode n) {
            return n != null && n.equals(this.getTerminal());
        }

        public RDFNode getTerminal() {
            return this.size() > 0 ? ((Statement)this.get(this.size() - 1)).getObject() : null;
        }

        public Resource getTerminalResource() {
            RDFNode n = this.getTerminal();
            return n != null && n.isResource() ? (Resource)n : null;
        }
    }

    public static class LCAIndex {
        private Map m_setIndex = new HashMap();
        private Map m_lcaIndex = new HashMap();

        public Resource getLCA(Resource u, Resource v) {
            Resource lca;
            Map map = (Map)this.m_lcaIndex.get(u);
            Resource resource = lca = map == null ? null : (Resource)map.get(v);
            if (lca == null) {
                map = (Map)this.m_lcaIndex.get(v);
                lca = map == null ? null : (Resource)map.get(u);
            }
            return lca;
        }

        public void setLCA(Resource u, Resource v, Resource lca) {
            HashMap<Resource, Resource> uMap = (HashMap<Resource, Resource>)this.m_lcaIndex.get(u);
            if (uMap == null) {
                uMap = new HashMap<Resource, Resource>();
                this.m_lcaIndex.put(u, uMap);
            }
            uMap.put(v, lca);
        }

        public DisjointSet getSet(Resource r) {
            DisjointSet s = (DisjointSet)this.m_setIndex.get(r);
            if (s == null) {
                log.debug("Generating new set for " + r);
                s = new DisjointSet(r);
                this.m_setIndex.put(r, s);
            } else {
                log.debug("Retrieving old set for " + r);
            }
            return s;
        }
    }

    public static class DisjointSet {
        private Resource m_node;
        private DisjointSet m_parent;
        private int m_rank;
        private DisjointSet m_ancestor;
        private boolean m_black = false;
        private boolean m_used = false;

        public DisjointSet(Resource node) {
            this.m_node = node;
            this.m_rank = 0;
            this.m_parent = this;
        }

        public Resource getNode() {
            return this.m_node;
        }

        public DisjointSet getParent() {
            return this.m_parent;
        }

        public void setParent(DisjointSet parent) {
            this.m_parent = parent;
        }

        public int getRank() {
            return this.m_rank;
        }

        public void incrementRank() {
            ++this.m_rank;
        }

        public DisjointSet getAncestor() {
            return this.m_ancestor;
        }

        public void setAncestor(DisjointSet anc) {
            this.m_ancestor = anc;
        }

        public void setBlack() {
            this.m_black = true;
        }

        public boolean isBlack() {
            return this.m_black;
        }

        public boolean used() {
            return this.m_used;
        }

        public void setUsed() {
            this.m_used = true;
        }

        public DisjointSet find() {
            DisjointSet root2;
            if (this.getParent() == this) {
                root2 = this;
            } else {
                root2 = this.getParent().find();
                this.setParent(root2);
            }
            return root2;
        }

        public void union(DisjointSet y) {
            DisjointSet xRoot = this.find();
            DisjointSet yRoot = y.find();
            if (xRoot.getRank() > yRoot.getRank()) {
                yRoot.setParent(xRoot);
            } else if (yRoot.getRank() > xRoot.getRank()) {
                xRoot.setParent(yRoot);
            } else if (xRoot != yRoot) {
                yRoot.setParent(xRoot);
                xRoot.incrementRank();
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("DisjointSet{node=");
            buf.append(this.m_node);
            buf.append(",anc=");
            buf.append(this.getAncestor() == this ? "self" : (this.getAncestor() == null ? "null" : this.getAncestor().toShortString()));
            buf.append(",parent=");
            buf.append(this.getParent() == this ? "self" : (this.getParent() == null ? "null" : this.getParent().toShortString()));
            buf.append(",rank=");
            buf.append(this.getRank());
            buf.append(this.m_black ? ",black" : ",white");
            buf.append("}");
            return buf.toString();
        }

        public String toShortString() {
            StringBuffer buf = new StringBuffer();
            buf.append("DisjointSet{node=");
            buf.append(this.m_node);
            buf.append(",parent=");
            buf.append(this.getParent() == this ? "self" : (this.getParent() == null ? "null" : this.getParent().toShortString()));
            buf.append("...}");
            return buf.toString();
        }
    }
}

