/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.Resource;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCreate
extends TestCase {
    public static final String BASE = "http://jena.hpl.hp.com/testing/ontology";
    public static final String NS = "http://jena.hpl.hp.com/testing/ontology#";
    protected static CreateTestCase[] testCases = new CreateTestCase[]{new CreateTestCase("OWL create ontology", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology"){

        public OntResource doCreate(OntModel m) {
            return m.createOntology(TestCreate.BASE);
        }

        public boolean test(OntResource r) {
            return r instanceof Ontology;
        }
    }, new CreateTestCase("DAML create ontology", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology"){

        public OntResource doCreate(OntModel m) {
            return m.createOntology(TestCreate.BASE);
        }

        public boolean test(OntResource r) {
            return r instanceof Ontology;
        }
    }, new CreateTestCase("OWL create class", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#C"){

        public OntResource doCreate(OntModel m) {
            return m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        }

        public boolean test(OntResource r) {
            return r instanceof OntClass;
        }
    }, new CreateTestCase("OWL create anon complement class", ProfileRegistry.OWL_LANG, null){

        public OntResource doCreate(OntModel m) {
            return m.createComplementClass(null, m.createClass("http://jena.hpl.hp.com/testing/ontology#A"));
        }

        public boolean test(OntResource r) {
            return r instanceof OntClass && r instanceof ComplementClass;
        }
    }, new CreateTestCase("OWL create anon enumeration class", ProfileRegistry.OWL_LANG, null){

        public OntResource doCreate(OntModel m) {
            OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
            Individual a0 = m.createIndividual(A);
            Individual a1 = m.createIndividual(A);
            Individual a2 = m.createIndividual(A);
            RDFList l = m.createList(new OntResource[]{a0, a1, a2});
            return m.createEnumeratedClass(null, l);
        }

        public boolean test(OntResource r) {
            return r instanceof OntClass && r instanceof EnumeratedClass;
        }
    }, new CreateTestCase("OWL create anon union class", ProfileRegistry.OWL_LANG, null){

        public OntResource doCreate(OntModel m) {
            OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
            Individual a0 = m.createIndividual(A);
            Individual a1 = m.createIndividual(A);
            Individual a2 = m.createIndividual(A);
            RDFList l = m.createList(new OntResource[]{a0, a1, a2});
            return m.createUnionClass(null, l);
        }

        public boolean test(OntResource r) {
            return r instanceof OntClass && r instanceof UnionClass;
        }
    }, new CreateTestCase("OWL create anon intersection class", ProfileRegistry.OWL_LANG, null){

        public OntResource doCreate(OntModel m) {
            OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
            Individual a0 = m.createIndividual(A);
            Individual a1 = m.createIndividual(A);
            Individual a2 = m.createIndividual(A);
            RDFList l = m.createList(new OntResource[]{a0, a1, a2});
            return m.createIntersectionClass(null, l);
        }

        public boolean test(OntResource r) {
            return r instanceof OntClass && r instanceof IntersectionClass;
        }
    }, new CreateTestCase("OWL create class", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#C"){

        public OntResource doCreate(OntModel m) {
            return m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        }

        public boolean test(OntResource r) {
            return r instanceof OntClass;
        }
    }, new CreateTestCase("DAML create class", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#C"){

        public OntResource doCreate(OntModel m) {
            return m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        }

        public boolean test(OntResource r) {
            return r instanceof OntClass;
        }
    }, new CreateTestCase("DAML create anon class", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel m) {
            return m.createClass();
        }

        public boolean test(OntResource r) {
            return r instanceof OntClass;
        }
    }, new CreateTestCase("DAML create anon complement class", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel m) {
            return m.createComplementClass(null, m.createClass("http://jena.hpl.hp.com/testing/ontology#A"));
        }

        public boolean test(OntResource r) {
            return r instanceof OntClass && r instanceof ComplementClass;
        }
    }, new CreateTestCase("DAML create anon enumeration class", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel m) {
            OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
            Individual a0 = m.createIndividual(A);
            Individual a1 = m.createIndividual(A);
            Individual a2 = m.createIndividual(A);
            RDFList l = m.createList(new OntResource[]{a0, a1, a2});
            return m.createEnumeratedClass(null, l);
        }

        public boolean test(OntResource r) {
            return r instanceof OntClass && r instanceof EnumeratedClass;
        }
    }, new CreateTestCase("DAML create anon union class", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel m) {
            OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
            Individual a0 = m.createIndividual(A);
            Individual a1 = m.createIndividual(A);
            Individual a2 = m.createIndividual(A);
            RDFList l = m.createList(new OntResource[]{a0, a1, a2});
            return m.createUnionClass(null, l);
        }

        public boolean test(OntResource r) {
            return r instanceof OntClass && r instanceof UnionClass;
        }
    }, new CreateTestCase("DAML create anon intersection class", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel m) {
            OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
            Individual a0 = m.createIndividual(A);
            Individual a1 = m.createIndividual(A);
            Individual a2 = m.createIndividual(A);
            RDFList l = m.createList(new OntResource[]{a0, a1, a2});
            return m.createIntersectionClass(null, l);
        }

        public boolean test(OntResource r) {
            return r instanceof OntClass && r instanceof IntersectionClass;
        }
    }, new CreateTestCase("OWL create individual", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#a"){

        public OntResource doCreate(OntModel m) {
            OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return m.createIndividual("http://jena.hpl.hp.com/testing/ontology#a", c);
        }

        public boolean test(OntResource r) {
            return r instanceof Individual;
        }
    }, new CreateTestCase("OWL create anon individual", ProfileRegistry.OWL_LANG, null){

        public OntResource doCreate(OntModel m) {
            OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return m.createIndividual(c);
        }

        public boolean test(OntResource r) {
            return r instanceof Individual;
        }
    }, new CreateTestCase("DAML create individual", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#a"){

        public OntResource doCreate(OntModel m) {
            OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return m.createIndividual("http://jena.hpl.hp.com/testing/ontology#a", c);
        }

        public boolean test(OntResource r) {
            return r instanceof Individual;
        }
    }, new CreateTestCase("DAML create anon individual", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel m) {
            OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return m.createIndividual(c);
        }

        public boolean test(OntResource r) {
            return r instanceof Individual;
        }
    }, new CreateTestCase("OWL create object property", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty;
        }
    }, new CreateTestCase("OWL create object property non-F", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && !r.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create object property F", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && r.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create transitive property", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createTransitiveProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && r instanceof TransitiveProperty;
        }
    }, new CreateTestCase("OWL create transitive property non-F", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createTransitiveProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && r instanceof TransitiveProperty && !r.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create transitive property F", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createTransitiveProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && r instanceof TransitiveProperty && r.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create symmetric property", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createSymmetricProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && r instanceof SymmetricProperty;
        }
    }, new CreateTestCase("OWL create symmetric property non-F", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createSymmetricProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && r instanceof SymmetricProperty && !r.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create symmetric property F", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createSymmetricProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && r instanceof SymmetricProperty && r.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create inverse functional property", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createInverseFunctionalProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && r instanceof InverseFunctionalProperty;
        }
    }, new CreateTestCase("OWL create inverse functional property non-F", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createInverseFunctionalProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && r instanceof InverseFunctionalProperty && !r.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create inverse functional property F", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createInverseFunctionalProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && r instanceof InverseFunctionalProperty && r.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create datatype property", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource r) {
            return r instanceof DatatypeProperty;
        }
    }, new CreateTestCase("OWL create datatype property non-F", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
        }

        public boolean test(OntResource r) {
            return r instanceof DatatypeProperty && !r.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create datatype property F", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
        }

        public boolean test(OntResource r) {
            return r instanceof DatatypeProperty && r.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create annotation property", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createAnnotationProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource r) {
            return r instanceof AnnotationProperty;
        }
    }, new CreateTestCase("DAML create object property", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty;
        }
    }, new CreateTestCase("DAML create object property non-F", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && !r.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("DAML create object property F", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && r.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("DAML create transitive property", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createTransitiveProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && r instanceof TransitiveProperty;
        }
    }, new CreateTestCase("DAML create transitive property non-F", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createTransitiveProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && r instanceof TransitiveProperty && !r.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("DAML create transitive property F", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createTransitiveProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && r instanceof TransitiveProperty && r.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("DAML create inverse functional property", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createInverseFunctionalProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && r instanceof InverseFunctionalProperty;
        }
    }, new CreateTestCase("DAML create inverse functional property non-F", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createInverseFunctionalProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && r instanceof InverseFunctionalProperty && !r.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("DAML create inverse functional property F", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createInverseFunctionalProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
        }

        public boolean test(OntResource r) {
            return r instanceof ObjectProperty && r instanceof InverseFunctionalProperty && r.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("DAML create datatype property", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource r) {
            return r instanceof DatatypeProperty;
        }
    }, new CreateTestCase("DAML create datatype property non-F", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
        }

        public boolean test(OntResource r) {
            return r instanceof DatatypeProperty && !r.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("DAML create datatype property F", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel m) {
            return m.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
        }

        public boolean test(OntResource r) {
            return r instanceof DatatypeProperty && r.canAs(class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = TestCreate.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty);
        }
    }, new CreateTestCase("OWL create allDifferent", ProfileRegistry.OWL_LANG, null){

        public OntResource doCreate(OntModel m) {
            return m.createAllDifferent();
        }

        public boolean test(OntResource r) {
            return r instanceof AllDifferent;
        }
    }, new CreateTestCase("OWL create restriction", ProfileRegistry.OWL_LANG, "http://jena.hpl.hp.com/testing/ontology#C"){

        public OntResource doCreate(OntModel m) {
            return m.createRestriction("http://jena.hpl.hp.com/testing/ontology#C", null);
        }

        public boolean test(OntResource r) {
            return r instanceof Restriction;
        }
    }, new CreateTestCase("OWL create anon restriction", ProfileRegistry.OWL_LANG, null){

        public OntResource doCreate(OntModel m) {
            return m.createRestriction(null);
        }

        public boolean test(OntResource r) {
            return r instanceof Restriction;
        }
    }, new CreateTestCase("OWL create has value restriction", ProfileRegistry.OWL_LANG, null){

        public OntResource doCreate(OntModel m) {
            ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            Resource x = m.createResource("http://jena.hpl.hp.com/testing/ontology#x");
            return m.createHasValueRestriction(null, p, x);
        }

        public boolean test(OntResource r) {
            return r instanceof HasValueRestriction;
        }
    }, new CreateTestCase("OWL create has value restriction (literal)", ProfileRegistry.OWL_LANG, null){

        public OntResource doCreate(OntModel m) {
            DatatypeProperty p = m.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p");
            Literal x = m.createTypedLiteral(new Integer(42));
            return m.createHasValueRestriction(null, p, x);
        }

        public boolean test(OntResource r) {
            return r instanceof HasValueRestriction;
        }
    }, new CreateTestCase("OWL create all values from restriction", ProfileRegistry.OWL_LANG, null){

        public OntResource doCreate(OntModel m) {
            ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return m.createAllValuesFromRestriction(null, p, c);
        }

        public boolean test(OntResource r) {
            return r instanceof AllValuesFromRestriction;
        }
    }, new CreateTestCase("OWL create some values from restriction", ProfileRegistry.OWL_LANG, null){

        public OntResource doCreate(OntModel m) {
            ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return m.createSomeValuesFromRestriction(null, p, c);
        }

        public boolean test(OntResource r) {
            return r instanceof SomeValuesFromRestriction;
        }
    }, new CreateTestCase("OWL create cardinality restriction", ProfileRegistry.OWL_LANG, null){

        public OntResource doCreate(OntModel m) {
            ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            return m.createCardinalityRestriction(null, p, 17);
        }

        public boolean test(OntResource r) {
            return r instanceof CardinalityRestriction;
        }
    }, new CreateTestCase("OWL create min cardinality restriction", ProfileRegistry.OWL_LANG, null){

        public OntResource doCreate(OntModel m) {
            ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            return m.createMinCardinalityRestriction(null, p, 1);
        }

        public boolean test(OntResource r) {
            return r instanceof MinCardinalityRestriction;
        }
    }, new CreateTestCase("OWL create max cardinality restriction", ProfileRegistry.OWL_LANG, null){

        public OntResource doCreate(OntModel m) {
            ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            return m.createMaxCardinalityRestriction(null, p, 4);
        }

        public boolean test(OntResource r) {
            return r instanceof MaxCardinalityRestriction;
        }
    }, new CreateTestCase("DAML create restriction", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#C"){

        public OntResource doCreate(OntModel m) {
            return m.createRestriction("http://jena.hpl.hp.com/testing/ontology#C", null);
        }

        public boolean test(OntResource r) {
            return r instanceof Restriction;
        }
    }, new CreateTestCase("DAML create anon restriction", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel m) {
            return m.createRestriction(null);
        }

        public boolean test(OntResource r) {
            return r instanceof Restriction;
        }
    }, new CreateTestCase("DAML create has value restriction", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel m) {
            ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            Resource x = m.createResource("http://jena.hpl.hp.com/testing/ontology#x");
            return m.createHasValueRestriction(null, p, x);
        }

        public boolean test(OntResource r) {
            return r instanceof HasValueRestriction;
        }
    }, new CreateTestCase("DAML create has value restriction (literal)", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel m) {
            DatatypeProperty p = m.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p");
            Literal x = m.createTypedLiteral(new Integer(42));
            return m.createHasValueRestriction(null, p, x);
        }

        public boolean test(OntResource r) {
            return r instanceof HasValueRestriction;
        }
    }, new CreateTestCase("DAML create all values from restriction", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel m) {
            ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return m.createAllValuesFromRestriction(null, p, c);
        }

        public boolean test(OntResource r) {
            return r instanceof AllValuesFromRestriction;
        }
    }, new CreateTestCase("DAML create some values from restriction", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel m) {
            ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            OntClass c = m.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return m.createSomeValuesFromRestriction(null, p, c);
        }

        public boolean test(OntResource r) {
            return r instanceof SomeValuesFromRestriction;
        }
    }, new CreateTestCase("DAML create cardinality restriction", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel m) {
            ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            return m.createCardinalityRestriction(null, p, 17);
        }

        public boolean test(OntResource r) {
            return r instanceof CardinalityRestriction;
        }
    }, new CreateTestCase("DAML create min cardinality restriction", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel m) {
            ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            return m.createMinCardinalityRestriction(null, p, 1);
        }

        public boolean test(OntResource r) {
            return r instanceof MinCardinalityRestriction;
        }
    }, new CreateTestCase("DAML create max cardinality restriction", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel m) {
            ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
            return m.createMaxCardinalityRestriction(null, p, 4);
        }

        public boolean test(OntResource r) {
            return r instanceof MaxCardinalityRestriction;
        }
    }};
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$FunctionalProperty;

    public TestCreate(String name) {
        super(name);
    }

    protected String getTestName() {
        return "TestCreate";
    }

    public static TestSuite suite() {
        TestSuite s = new TestSuite("TestCreate");
        for (int i = 0; i < testCases.length; ++i) {
            s.addTest((Test)testCases[i]);
        }
        return s;
    }

    protected static class CreateTestCase
    extends TestCase {
        protected String m_lang;
        protected String m_uri;

        public CreateTestCase(String name, String lang, String uri) {
            super(name);
            this.m_lang = lang;
            this.m_uri = uri;
        }

        public void runTest() {
            OntModel m = ModelFactory.createOntologyModel(this.m_lang);
            OntResource r = this.doCreate(m);
            CreateTestCase.assertNotNull((String)"Result of creation step should not be null", (Object)r);
            if (this.m_uri == null) {
                CreateTestCase.assertTrue((String)"Created resource should be anonymous", (boolean)r.isAnon());
            } else {
                CreateTestCase.assertEquals((String)"Created resource has wrong uri", (String)this.m_uri, (String)r.getURI());
            }
            CreateTestCase.assertTrue((String)"Result test failed", (boolean)this.test(r));
        }

        public void setUp() {
            OntDocumentManager.getInstance().reset(true);
        }

        public OntResource doCreate(OntModel m) {
            return null;
        }

        public boolean test(OntResource r) {
            return true;
        }
    }
}

