/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDFS;

public class TestOntClass
extends ModelTestBase {
    private static final String NS = "http://example.com/test#";

    public TestOntClass(String name) {
        super(name);
    }

    public void testSuperClassNE() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntClass a = m.createClass("http://example.com/test#A");
        TestOntClass.assertNull((Object)a.getSuperClass());
        TestOntClass.assertFalse((boolean)a.hasSuperClass());
    }

    public void testSubClassNE() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntClass a = m.createClass("http://example.com/test#A");
        TestOntClass.assertNull((Object)a.getSubClass());
        TestOntClass.assertFalse((boolean)a.hasSubClass());
    }

    public void testCreateIndividual() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntClass a = m.createClass("http://example.com/test#A");
        Individual i = a.createIndividual("http://example.com/test#i");
        TestOntClass.assertTrue((boolean)i.hasRDFType(a));
        Individual j = a.createIndividual();
        TestOntClass.assertTrue((boolean)j.hasRDFType(a));
    }

    public void testIsHierarchyRoot0() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass(b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testIsHierarchyRoot1() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass(b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testIsHierarchyRoot2() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RDFS_INF);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass(b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testIsHierarchyRoot3() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_TRANS_INF);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass(b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testIsHierarchyRoot4() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass(b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testIsHierarchyRoot5() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_LITE_MEM);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass(b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testIsHierarchyRoot6() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass(b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testIsHierarchyRoot7() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM_RULE_INF);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass(b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testIsHierarchyRoot8() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.RDFS_MEM);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass(b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testIsHierarchyRoot9() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.RDFS_MEM_RDFS_INF);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        a.addSubClass(b);
        TestOntClass.assertTrue((boolean)a.isHierarchyRoot());
        TestOntClass.assertFalse((boolean)b.isHierarchyRoot());
    }

    public void testListSubClasses0() {
        OntModel m = this.createABCDEFModel(OntModelSpec.OWL_MEM);
        OntClass a = m.getOntClass("http://example.com/test#A");
        OntClass b = m.getOntClass("http://example.com/test#B");
        OntClass c = m.getOntClass("http://example.com/test#C");
        OntClass d = m.getOntClass("http://example.com/test#D");
        OntClass e2 = m.getOntClass("http://example.com/test#E");
        TestUtil.assertIteratorValues(this, a.listSubClasses(), new Object[]{b, c});
        TestUtil.assertIteratorValues(this, a.listSubClasses(false), new Object[]{b, c});
        TestUtil.assertIteratorValues(this, a.listSubClasses(true), new Object[]{b, c});
        TestUtil.assertIteratorValues(this, b.listSubClasses(true), new Object[]{d, e2});
    }

    public void testListSubClasses1() {
        OntModel m = this.createABCDEFModel(OntModelSpec.OWL_MEM_RULE_INF);
        OntClass a = m.getOntClass("http://example.com/test#A");
        OntClass b = m.getOntClass("http://example.com/test#B");
        OntClass c = m.getOntClass("http://example.com/test#C");
        OntClass d = m.getOntClass("http://example.com/test#D");
        OntClass e2 = m.getOntClass("http://example.com/test#E");
        OntClass f = m.getOntClass("http://example.com/test#F");
        TestUtil.assertIteratorValues(this, a.listSubClasses(), new Object[]{b, c, d, e2, f});
        TestUtil.assertIteratorValues(this, a.listSubClasses(false), new Object[]{b, c, d, e2, f});
        TestUtil.assertIteratorValues(this, a.listSubClasses(true), new Object[]{b, c});
        TestUtil.assertIteratorValues(this, b.listSubClasses(true), new Object[]{d, e2});
    }

    public void testListSubClasses2() {
        OntModel m = this.createABCDEFModel(OntModelSpec.OWL_MEM_MICRO_RULE_INF);
        OntClass a = m.getOntClass("http://example.com/test#A");
        OntClass b = m.getOntClass("http://example.com/test#B");
        OntClass c = m.getOntClass("http://example.com/test#C");
        OntClass d = m.getOntClass("http://example.com/test#D");
        OntClass e2 = m.getOntClass("http://example.com/test#E");
        OntClass f = m.getOntClass("http://example.com/test#F");
        TestUtil.assertIteratorValues(this, a.listSubClasses(), new Object[]{b, c, d, e2, f, OWL.Nothing});
        TestUtil.assertIteratorValues(this, a.listSubClasses(false), new Object[]{b, c, d, e2, f, OWL.Nothing});
        TestUtil.assertIteratorValues(this, a.listSubClasses(true), new Object[]{b, c});
        TestUtil.assertIteratorValues(this, b.listSubClasses(true), new Object[]{d, e2});
    }

    public void testListSuperClasses0() {
        OntModel m = this.createABCDEFModel(OntModelSpec.OWL_MEM);
        OntClass a = m.getOntClass("http://example.com/test#A");
        OntClass b = m.getOntClass("http://example.com/test#B");
        OntClass c = m.getOntClass("http://example.com/test#C");
        OntClass e2 = m.getOntClass("http://example.com/test#E");
        TestUtil.assertIteratorValues(this, e2.listSuperClasses(), new Object[]{b, c});
        TestUtil.assertIteratorValues(this, e2.listSuperClasses(false), new Object[]{b, c});
        TestUtil.assertIteratorValues(this, e2.listSuperClasses(true), new Object[]{b, c});
        TestUtil.assertIteratorValues(this, b.listSuperClasses(true), new Object[]{a});
    }

    public void testListSuperClasses1() {
        OntModel m = this.createABCDEFModel(OntModelSpec.OWL_MEM_RULE_INF);
        OntClass a = m.getOntClass("http://example.com/test#A");
        OntClass b = m.getOntClass("http://example.com/test#B");
        OntClass c = m.getOntClass("http://example.com/test#C");
        OntClass e2 = m.getOntClass("http://example.com/test#E");
        TestUtil.assertIteratorValues(this, e2.listSuperClasses(), new Object[]{b, c, a, RDFS.Resource, OWL.Thing});
        TestUtil.assertIteratorValues(this, e2.listSuperClasses(false), new Object[]{b, c, a, RDFS.Resource, OWL.Thing});
        TestUtil.assertIteratorValues(this, e2.listSuperClasses(true), new Object[]{b, c});
        TestUtil.assertIteratorValues(this, b.listSuperClasses(true), new Object[]{a});
    }

    public void testListSuperClasses2() {
        OntModel m = this.createABCDEFModel(OntModelSpec.OWL_MEM_MICRO_RULE_INF);
        OntClass a = m.getOntClass("http://example.com/test#A");
        OntClass b = m.getOntClass("http://example.com/test#B");
        OntClass c = m.getOntClass("http://example.com/test#C");
        OntClass e2 = m.getOntClass("http://example.com/test#E");
        TestUtil.assertIteratorValues(this, e2.listSuperClasses(), new Object[]{b, c, a, OWL.Thing});
        TestUtil.assertIteratorValues(this, e2.listSuperClasses(false), new Object[]{b, c, a, OWL.Thing});
        TestUtil.assertIteratorValues(this, e2.listSuperClasses(true), new Object[]{b, c});
        TestUtil.assertIteratorValues(this, b.listSuperClasses(true), new Object[]{a});
    }

    public void testListInstances0() {
        OntModel m = this.createABCDEFModel(OntModelSpec.OWL_MEM);
        OntClass a = m.getOntClass("http://example.com/test#A");
        OntClass b = m.getOntClass("http://example.com/test#B");
        Individual ia = a.createIndividual();
        Individual ib = b.createIndividual();
        TestUtil.assertIteratorValues(this, a.listInstances(), new Object[]{ia});
        TestUtil.assertIteratorValues(this, b.listInstances(), new Object[]{ib});
        TestUtil.assertIteratorValues(this, a.listInstances(true), new Object[]{ia});
        TestUtil.assertIteratorValues(this, b.listInstances(true), new Object[]{ib});
    }

    public void testListInstances1() {
        OntModel m = this.createABCDEFModel(OntModelSpec.OWL_MEM_RULE_INF);
        OntClass a = m.getOntClass("http://example.com/test#A");
        OntClass b = m.getOntClass("http://example.com/test#B");
        OntClass c = m.getOntClass("http://example.com/test#C");
        OntClass d = m.getOntClass("http://example.com/test#D");
        OntClass e2 = m.getOntClass("http://example.com/test#E");
        Individual ia = a.createIndividual("http://example.com/test#iA");
        Individual ib = b.createIndividual("http://example.com/test#iB");
        Individual ic = c.createIndividual("http://example.com/test#iC");
        Individual id = d.createIndividual("http://example.com/test#iD");
        Individual ie = e2.createIndividual("http://example.com/test#iE");
        TestUtil.assertIteratorValues(this, a.listInstances(), new Object[]{ia, ib, ic, id, ie});
        TestUtil.assertIteratorValues(this, b.listInstances(), new Object[]{ib, id, ie});
        TestUtil.assertIteratorValues(this, a.listInstances(true), new Object[]{ia});
        TestUtil.assertIteratorValues(this, b.listInstances(true), new Object[]{ib});
    }

    public void testListInstances2() {
        OntModel m = this.createABCDEFModel(OntModelSpec.OWL_MEM_MICRO_RULE_INF);
        OntClass a = m.getOntClass("http://example.com/test#A");
        OntClass b = m.getOntClass("http://example.com/test#B");
        OntClass c = m.getOntClass("http://example.com/test#C");
        OntClass d = m.getOntClass("http://example.com/test#D");
        OntClass e2 = m.getOntClass("http://example.com/test#E");
        Individual ia = a.createIndividual("http://example.com/test#iA");
        Individual ib = b.createIndividual("http://example.com/test#iB");
        Individual ic = c.createIndividual("http://example.com/test#iC");
        Individual id = d.createIndividual("http://example.com/test#iD");
        Individual ie = e2.createIndividual("http://example.com/test#iE");
        TestUtil.assertIteratorValues(this, a.listInstances(), new Object[]{ia, ib, ic, id, ie});
        TestUtil.assertIteratorValues(this, b.listInstances(), new Object[]{ib, id, ie});
        TestUtil.assertIteratorValues(this, a.listInstances(true), new Object[]{ia});
        TestUtil.assertIteratorValues(this, b.listInstances(true), new Object[]{ib});
    }

    public void testDropIndividual() {
        OntModel m = this.createABCDEFModel(OntModelSpec.OWL_MEM);
        OntClass a = m.getOntClass("http://example.com/test#A");
        OntClass b = m.getOntClass("http://example.com/test#B");
        Individual ia = a.createIndividual("http://example.com/test#iA");
        ia.addOntClass(b);
        TestOntClass.assertTrue((boolean)ia.hasOntClass(a));
        TestOntClass.assertTrue((boolean)ia.hasOntClass(b));
        a.dropIndividual(ia);
        TestOntClass.assertFalse((boolean)ia.hasOntClass(a));
        TestOntClass.assertTrue((boolean)ia.hasOntClass(b));
        a.dropIndividual(ia);
        TestOntClass.assertFalse((boolean)ia.hasOntClass(a));
        TestOntClass.assertTrue((boolean)ia.hasOntClass(b));
        b.dropIndividual(ia);
        TestOntClass.assertFalse((boolean)ia.hasOntClass(a));
        TestOntClass.assertFalse((boolean)ia.hasOntClass(b));
    }

    protected OntModel createABCDEFModel(OntModelSpec spec) {
        OntModel m = ModelFactory.createOntologyModel(spec);
        OntClass a = m.createClass("http://example.com/test#A");
        OntClass b = m.createClass("http://example.com/test#B");
        OntClass c = m.createClass("http://example.com/test#C");
        OntClass d = m.createClass("http://example.com/test#D");
        OntClass e2 = m.createClass("http://example.com/test#E");
        OntClass f = m.createClass("http://example.com/test#F");
        a.addSubClass(b);
        a.addSubClass(c);
        b.addSubClass(d);
        b.addSubClass(e2);
        c.addSubClass(e2);
        c.addSubClass(f);
        return m;
    }
}

