/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.n3.IRIResolver;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.ConfigException;
import com.hp.hpl.jena.shared.JenaException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestModelRead
extends ModelTestBase {
    protected static Log logger = LogFactory.getLog(TestModelRead.class);

    public TestModelRead(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelRead.class);
    }

    public void testReturnsSelf() {
        Model m = ModelFactory.createDefaultModel();
        TestModelRead.assertSame((Object)m, (Object)m.read("file:testing/modelReading/empty.n3", "base", "N3"));
        TestModelRead.assertTrue((boolean)m.isEmpty());
    }

    public void testGRDDLConfigMessage() {
        Model m = ModelFactory.createDefaultModel();
        try {
            m.read("http://www.w3.org/", "GRDDL");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    public void testLoadsSimpleModel() {
        Model expected = ModelFactory.createDefaultModel();
        Model m = ModelFactory.createDefaultModel();
        expected.read("file:testing/modelReading/simple.n3", "N3");
        TestModelRead.assertSame((Object)m, (Object)m.read("file:testing/modelReading/simple.n3", "base", "N3"));
        TestModelRead.assertIsoModels(expected, m);
    }

    public void testSimpleLoadImplictBase() {
        Model mBasedImplicit = ModelFactory.createDefaultModel();
        String fn = IRIResolver.resolveFileURL("file:testing/modelReading/based.n3");
        Model wanted = ModelFactory.createDefaultModel().add(TestModelRead.resource(fn), TestModelRead.property("jms:predicate"), TestModelRead.resource("jms:object"));
        mBasedImplicit.read(fn, "N3");
        TestModelRead.assertIsoModels(wanted, mBasedImplicit);
    }

    public void testSimpleLoadExplicitBase() {
        Model mBasedExplicit = ModelFactory.createDefaultModel();
        mBasedExplicit.read("file:testing/modelReading/based.n3", "http://example/", "N3");
        TestModelRead.assertIsoModels(TestModelRead.modelWithStatements("http://example/ jms:predicate jms:object"), mBasedExplicit);
    }

    public void testDefaultLangXML() {
        Model m = ModelFactory.createDefaultModel();
        m.read("file:testing/modelReading/plain.rdf", null, null);
    }

    public void testContentNegotiation() {
        Model m = ModelFactory.createDefaultModel();
        try {
            m.read("http://jena.sourceforge.net/test/mime/test1");
            TestModelRead.assertEquals((long)m.size(), (long)1L);
        }
        catch (JenaException jx) {
            if (jx.getCause() instanceof NoRouteToHostException || jx.getCause() instanceof UnknownHostException || jx.getCause() instanceof ConnectException || jx.getCause() instanceof IOException) {
                logger.warn("Cannot access public internet - content negotiation test not executed");
            }
            throw jx;
        }
    }
}

