/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.util.ModelQueryUtil;
import com.hp.hpl.jena.util.QueryMapper;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Arrays;
import junit.framework.TestSuite;

public class TestQuery
extends ModelTestBase {
    public TestQuery(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestQuery.class);
    }

    public void testAAA() {
        this.testQueryTranslates("", "");
        this.testQueryTranslates("x R y", "x R y");
        this.testQueryTranslates("x R _y; p S 99", "x R _y; p S 99");
        this.testQueryTranslates("x R ?y", "x R ?y");
        this.testQueryTranslates("jqv:x jqv:H y", "?x ?H y");
    }

    public void testBBB() {
        Model m = ModelFactory.createDefaultModel();
        String[][] tests = new String[][]{{"x", "x"}, {"jqv:x", "?x"}};
        for (int i = 0; i < tests.length; ++i) {
            this.testVariablesTranslate(TestQuery.resources(m, tests[i][0]), TestQuery.nodeArray(tests[i][1]));
        }
    }

    private void testQueryTranslates(String model, String graph) {
        String title = "must translate <" + model + "> to <" + graph + ">";
        Model m = TestQuery.modelWithStatements(model);
        Graph g = GraphTestBase.graphWith(graph);
        QueryMapper qm = new QueryMapper(m, new Resource[0]);
        GraphTestBase.assertIsomorphic(title, g, qm.getGraph());
    }

    public void testVariablesTranslate(Resource[] vIn, Node[] vOut) {
        TestQuery.assertEquals((String)"broken test", (int)vIn.length, (int)vOut.length);
        QueryMapper qm = new QueryMapper(TestQuery.modelWithStatements(""), vIn);
        Node[] result = qm.getVariables();
        TestQuery.assertEquals((int)vOut.length, (int)result.length);
        for (int i = 0; i < result.length; ++i) {
            TestQuery.assertEquals((String)"variable did not convert", (Object)vOut[i], (Object)result[i]);
        }
    }

    public void testModelQuery() {
        Model m = TestQuery.modelWithStatements("a R b; b S c; a R p; p T d");
        Model q = TestQuery.modelWithStatements("jqv:x R jqv:y; jqv:y S jqv:z");
        ExtendedIterator it = ModelQueryUtil.queryBindingsWith(m, q, TestQuery.resources(q, "jqv:x jqv:z"));
        TestQuery.assertTrue((boolean)it.hasNext());
        TestQuery.assertEquals(Arrays.asList(TestQuery.resources(m, "a c b")), it.next());
        TestQuery.assertFalse((boolean)it.hasNext());
    }
}

