/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class TestConfigVocabulary
extends ModelTestBase {
    public TestConfigVocabulary(String name) {
        super(name);
    }

    public void testExistingVocabulary() {
        this.assertIsProperty("name", ReasonerVocabulary.nameP);
        this.assertIsProperty("description", ReasonerVocabulary.descriptionP);
        this.assertIsProperty("version", ReasonerVocabulary.versionP);
        this.assertIsProperty("supports", ReasonerVocabulary.supportsP);
        this.assertIsProperty("configurationProperty", ReasonerVocabulary.configurationP);
        this.assertIsProperty("individualAsThing", ReasonerVocabulary.individualAsThingP);
    }

    public void testPropVocavulary() {
        this.assertIsPropProperty("derivationLogging", ReasonerVocabulary.PROPderivationLogging);
        this.assertIsPropProperty("traceOn", ReasonerVocabulary.PROPtraceOn);
        this.assertIsPropProperty("ruleMode", ReasonerVocabulary.PROPruleMode);
        this.assertIsPropProperty("enableOWLTranslation", ReasonerVocabulary.PROPenableOWLTranslation);
        this.assertIsPropProperty("enableTGCCaching", ReasonerVocabulary.PROPenableTGCCaching);
        this.assertIsPropProperty("enableCMPScan", ReasonerVocabulary.PROPenableCMPScan);
        this.assertIsPropProperty("setRDFSLevel", ReasonerVocabulary.PROPsetRDFSLevel);
        this.assertIsPropProperty("enableFunctorFiltering", ReasonerVocabulary.PROPenableFunctorFiltering);
    }

    public void testDirectVocabulary() {
        this.assertIsDirectProperty(RDFS.subClassOf, ReasonerVocabulary.directSubClassOf);
        this.assertIsDirectProperty(RDFS.subPropertyOf, ReasonerVocabulary.directSubPropertyOf);
        this.assertIsDirectProperty(RDF.type, ReasonerVocabulary.directRDFType);
    }

    public void testRuleSetVocabulary() {
        this.assertIsProperty("ruleSet", ReasonerVocabulary.ruleSet);
        this.assertIsProperty("ruleSetURL", ReasonerVocabulary.ruleSetURL);
        this.assertIsProperty("hasRule", ReasonerVocabulary.hasRule);
        this.assertIsProperty("schemaURL", ReasonerVocabulary.schemaURL);
    }

    private void assertIsDirectProperty(Resource r, Property p) {
        TestConfigVocabulary.assertEquals((String)ReasonerRegistry.makeDirect(r.getURI()), (String)p.getURI());
    }

    private void assertIsProperty(String name, Property p) {
        TestConfigVocabulary.assertEquals((String)(ReasonerVocabulary.getJenaReasonerNS() + name), (String)p.getURI());
    }

    private void assertIsPropProperty(String name, Property p) {
        TestConfigVocabulary.assertEquals((String)("http://jena.hpl.hp.com/2003/RuleReasoner#" + name), (String)p.getURI());
    }
}

