/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify.op;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.modify.op.Update;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class GraphUpdateN
extends Update {
    protected List graphNodes = new ArrayList();

    public boolean hasGraphNames() {
        return !this.graphNodes.isEmpty();
    }

    public void addGraphName(Node node) {
        this.graphNodes.add(node);
    }

    public void addGraphName(String uri) {
        this.graphNodes.add(Node.createURI(uri));
    }

    public List getGraphNames() {
        return this.graphNodes;
    }

    protected abstract void startExec(GraphStore var1);

    protected abstract void finishExec();

    protected abstract void exec(Graph var1);

    public void exec(GraphStore graphStore) {
        this.startExec(graphStore);
        if (this.hasGraphNames()) {
            Iterator iter = this.graphNodes.iterator();
            while (iter.hasNext()) {
                Node gn = (Node)iter.next();
                Graph g = graphStore.getGraph(gn);
                if (g == null) {
                    throw new UpdateException("No such graph: " + gn);
                }
                this.exec(g);
            }
        } else {
            Graph g = graphStore.getDefaultGraph();
            this.exec(g);
        }
        this.finishExec();
    }
}

