/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.sparql.util.DateTimeStruct;
import com.hp.hpl.jena.sparql.util.Utils;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDateTimeParsing
extends TestCase {
    public static Test suite() {
        TestSuite ts = new TestSuite(TestDateTimeParsing.class);
        ts.setName(Utils.classShortName(TestDateTimeParsing.class));
        return ts;
    }

    public void testDT_1() {
        TestDateTimeParsing.dateTimeTest("2007-08-31T12:34:56Z");
    }

    public void testDT_2() {
        TestDateTimeParsing.dateTimeTest("2007-08-31T12:34:56");
    }

    public void testDT_3() {
        TestDateTimeParsing.dateTimeTest("2007-08-31T12:34:56.003");
    }

    public void testDT_4() {
        TestDateTimeParsing.dateTimeTest("2007-08-31T12:34:56.003+05:00");
    }

    public void testDT_5() {
        TestDateTimeParsing.dateTimeTest("-2007-08-31T12:34:56.003-05:00");
    }

    public void testDT_6() {
        TestDateTimeParsing.dateTimeTest("-2007-08-31T12:34:56");
    }

    public void testDT_7() {
        TestDateTimeParsing.dateTimeBad("+2007-08-31T12:34:56");
    }

    public void testDT_8() {
        TestDateTimeParsing.dateTimeBad("2007-08-31");
    }

    public void testDT_10() {
        DateTimeStruct dt = DateTimeStruct.parseDateTime("2007-08-31T12:34:56");
        TestDateTimeParsing.check(dt, null, "2007", "08", "31", "12", "34", "56", null);
    }

    public void testDT_11() {
        DateTimeStruct dt = DateTimeStruct.parseDateTime("2007-08-31T12:34:56Z");
        TestDateTimeParsing.check(dt, null, "2007", "08", "31", "12", "34", "56", "Z");
    }

    public void testDT_12() {
        DateTimeStruct dt = DateTimeStruct.parseDateTime("-2007-08-31T12:34:56.003-05:00");
        TestDateTimeParsing.check(dt, "-", "2007", "08", "31", "12", "34", "56.003", "-05:00");
    }

    public void testD_1() {
        TestDateTimeParsing.dateTest("2007-08-31Z");
    }

    public void testD_2() {
        TestDateTimeParsing.dateTest("2007-08-31");
    }

    public void testD_10() {
        DateTimeStruct dt = DateTimeStruct.parseDate("2007-08-31");
        TestDateTimeParsing.check(dt, null, "2007", "08", "31", null);
    }

    private static void dateTimeTest(String str2) {
        DateTimeStruct dt = DateTimeStruct.parseDateTime(str2);
        TestDateTimeParsing.assertTrue((boolean)dt.xsdDateTime);
        TestDateTimeParsing.check(dt);
        TestDateTimeParsing.assertEquals((String)str2, (String)dt.toString());
    }

    private static void dateTimeBad(String str2) {
        try {
            DateTimeStruct dt = DateTimeStruct.parseDateTime(str2);
            TestDateTimeParsing.fail((String)("No exception; " + str2));
        }
        catch (DateTimeStruct.DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }

    private static void dateTest(String str2) {
        DateTimeStruct dt = DateTimeStruct.parseDate(str2);
        TestDateTimeParsing.assertFalse((boolean)dt.xsdDateTime);
        TestDateTimeParsing.check(dt);
        TestDateTimeParsing.assertEquals((String)str2, (String)dt.toString());
    }

    private static void dateBad(String str2) {
        try {
            DateTimeStruct dt = DateTimeStruct.parseDateTime(str2);
            TestDateTimeParsing.fail((String)("No exception; " + str2));
        }
        catch (DateTimeStruct.DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }

    private static void check(DateTimeStruct dt) {
        TestDateTimeParsing.assertTrue((dt.neg == null || dt.neg.equals("-") ? (byte)1 : 0) != 0);
        TestDateTimeParsing.assertNotNull((Object)dt.year);
        TestDateTimeParsing.assertEquals((int)4, (int)dt.year.length());
        TestDateTimeParsing.assertNotNull((Object)dt.month);
        TestDateTimeParsing.assertEquals((int)2, (int)dt.month.length());
        TestDateTimeParsing.assertNotNull((Object)dt.day);
        TestDateTimeParsing.assertEquals((int)2, (int)dt.day.length());
        TestDateTimeParsing.assertNotNull((Object)dt.hour);
        TestDateTimeParsing.assertEquals((int)2, (int)dt.hour.length());
        TestDateTimeParsing.assertNotNull((Object)dt.minute);
        TestDateTimeParsing.assertEquals((int)2, (int)dt.minute.length());
        TestDateTimeParsing.assertNotNull((Object)dt.second);
        TestDateTimeParsing.assertTrue((dt.hour.length() >= 0 ? (byte)1 : 0) != 0);
        TestDateTimeParsing.assertTrue((dt.timezone == null || dt.timezone.equals("Z") || dt.timezone.length() == 6 ? (byte)1 : 0) != 0);
    }

    private static void check(DateTimeStruct dt, String neg, String year, String month, String day, String hour, String minute, String second, String timezone) {
        TestDateTimeParsing.assertEquals((boolean)true, (boolean)dt.xsdDateTime);
        TestDateTimeParsing.assertEquals((String)neg, (String)dt.neg);
        TestDateTimeParsing.assertEquals((String)year, (String)dt.year);
        TestDateTimeParsing.assertEquals((String)month, (String)dt.month);
        TestDateTimeParsing.assertEquals((String)day, (String)dt.day);
        TestDateTimeParsing.assertEquals((String)hour, (String)dt.hour);
        TestDateTimeParsing.assertEquals((String)minute, (String)dt.minute);
        TestDateTimeParsing.assertEquals((String)second, (String)dt.second);
        TestDateTimeParsing.assertEquals((String)timezone, (String)dt.timezone);
    }

    private static void check(DateTimeStruct dt, String neg, String year, String month, String day, String timezone) {
        TestDateTimeParsing.assertEquals((boolean)false, (boolean)dt.xsdDateTime);
        TestDateTimeParsing.assertEquals((String)neg, (String)dt.neg);
        TestDateTimeParsing.assertEquals((String)year, (String)dt.year);
        TestDateTimeParsing.assertEquals((String)month, (String)dt.month);
        TestDateTimeParsing.assertEquals((String)day, (String)dt.day);
        TestDateTimeParsing.assertEquals((String)"00", (String)dt.hour);
        TestDateTimeParsing.assertEquals((String)"00", (String)dt.minute);
        TestDateTimeParsing.assertEquals((String)"00", (String)dt.second);
        TestDateTimeParsing.assertEquals((String)timezone, (String)dt.timezone);
    }
}

