/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUData;
import com.ibm.icu.impl.ICULocaleData;
import com.ibm.icu.impl.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ICUListResourceBundle
extends ListResourceBundle {
    private static final String ICUDATA = "ICUDATA";
    private static final String ICU_BUNDLE_NAME = "LocaleElements";
    private static final String ICU_PACKAGE_NAME = "com.ibm.icu.impl.data";
    private static final String ENCODING = "UTF-8";
    Locale icuLocale;
    private Hashtable visited = new Hashtable();
    protected Object[][] contents;
    private Object[][] realContents;
    private static final char RES_PATH_SEP_CHAR = '/';

    void setParentX(ResourceBundle b) {
        this.setParent(b);
    }

    public Locale getLocale() {
        return this.icuLocale;
    }

    protected ICUListResourceBundle() {
    }

    protected Object[][] getContents() {
        if (this.realContents == null) {
            this.realContents = this.contents;
            for (int i = 0; i < this.contents.length; ++i) {
                Object newValue = this.getRedirectedResource((String)this.contents[i][0], this.contents[i][1], -1);
                if (newValue == null) continue;
                if (this.realContents == this.contents) {
                    this.realContents = (Object[][])this.contents.clone();
                }
                this.realContents[i] = new Object[]{this.contents[i][0], newValue};
            }
        }
        return this.realContents;
    }

    private Object getRedirectedResource(String key, Object value, int index) {
        if (value instanceof Object[][]) {
            Object[][] aValue = (Object[][])value;
            for (int i = 0; i < aValue.length; ++i) {
                for (int j = 0; j < aValue[i].length; ++j) {
                    aValue[i][j] = this.getRedirectedResource((String)aValue[i][0], aValue[i][j], i);
                }
            }
        } else if (value instanceof Object[]) {
            Object[] aValue = (Object[])value;
            for (int i = 0; i < aValue.length; ++i) {
                aValue[i] = this.getRedirectedResource(key, aValue[i], i);
            }
        } else {
            if (value instanceof Alias) {
                String cName = this.getClass().getName();
                this.visited.clear();
                this.visited.put(cName + key, "");
                return ((Alias)value).getResource(cName, key, index, this.visited);
            }
            if (value instanceof RedirectedResource) {
                return ((RedirectedResource)value).getResource(this);
            }
        }
        return value;
    }

    private static byte[] readToEOS(InputStream stream) {
        try {
            ArrayList<byte[]> vec = new ArrayList<byte[]>();
            int count = 0;
            int length = 512;
            int MAXLENGTH = 32768;
            int pos = -1;
            while (true) {
                int n;
                byte[] buffer = new byte[length];
                pos = 0;
                while ((n = stream.read(buffer, pos, length - pos)) != -1 && (pos += n) < length) {
                }
                count += pos;
                vec.add(buffer);
                if (pos < length) break;
                if (length >= 32768) continue;
                length <<= 1;
            }
            byte[] data = new byte[count];
            pos = 0;
            for (int i = 0; i < vec.size(); ++i) {
                byte[] buf = (byte[])vec.get(i);
                int len = Math.min(buf.length, count - pos);
                System.arraycopy(buf, 0, data, pos, len);
                pos += len;
            }
            return data;
        }
        catch (IOException e2) {
            throw new MissingResourceException(e2.getMessage(), "", "");
        }
    }

    private static char[] readToEOS(InputStreamReader stream) {
        try {
            char[] buffer;
            int n;
            int MAXLENGTH = 0x40000000;
            for (int length = 65536; (n = stream.read(buffer = new char[length], 0, length)) < 0 || n >= length; length <<= 1) {
                if (length < 0x40000000) {
                    stream.reset();
                    continue;
                }
                throw new InternalError("maximum input stream length exceeded");
            }
            char[] data = new char[n];
            System.arraycopy(buffer, 0, data, 0, n);
            return data;
        }
        catch (IOException e2) {
            throw new MissingResourceException(e2.getMessage(), "", "");
        }
    }

    private static String[] split(String source, char delimiter) {
        char[] src = source.toCharArray();
        int index = 0;
        int numdelimit = 0;
        for (int i = 0; i < source.length(); ++i) {
            if (src[i] != delimiter) continue;
            ++numdelimit;
        }
        String[] values = null;
        values = new String[numdelimit + 2];
        int old = 0;
        for (int j = 0; j < src.length; ++j) {
            if (src[j] != delimiter) continue;
            values[index++] = new String(src, old, j - old);
            old = j + 1;
        }
        if (old < src.length) {
            values[index++] = new String(src, old, src.length - old);
        }
        return values;
    }

    public final Object getObjectWithFallback(String path) throws MissingResourceException {
        String[] keys = ICUListResourceBundle.split(path, '/');
        Object result = null;
        ICUListResourceBundle actualBundle = this;
        result = this.findResourceWithFallback(keys, actualBundle);
        if (result == null) {
            throw new MissingResourceException("Could not find the resource in ", this.getClass().getName(), path);
        }
        return result;
    }

    private Object findResourceWithFallback(String[] keys, ICUListResourceBundle actualBundle) {
        Object obj = null;
        while (actualBundle != null) {
            obj = actualBundle.getObject(keys[0], actualBundle);
            if ((obj = this.findResourceWithFallback(obj, keys, 1, 0)) != null) break;
            actualBundle = (ICUListResourceBundle)actualBundle.parent;
        }
        return obj;
    }

    private Object findResourceWithFallback(Object o, String[] keys, int start, int index) {
        Object obj = o;
        if (start < keys.length && keys[start] != null) {
            if (obj instanceof Object[][]) {
                obj = this.findResourceWithFallback((Object[][])obj, keys[start]);
            } else if (obj instanceof Object[] && ICUListResourceBundle.isIndex(keys[start])) {
                obj = ((Object[])obj)[ICUListResourceBundle.getIndex(keys[start])];
            }
            if (start + 1 < keys.length && keys[start + 1] != null) {
                obj = this.findResourceWithFallback(obj, keys, start + 1, index);
            }
        } else if (index >= 0) {
            if (obj instanceof Object[][]) {
                obj = this.findResourceWithFallback((Object[][])obj, Integer.toString(index));
            } else if (obj instanceof Object[]) {
                obj = ((Object[])obj)[index];
            }
        }
        return obj;
    }

    private Object findResourceWithFallback(Object[][] cnts, String key) {
        Object obj = null;
        for (int i = 0; i < cnts.length; ++i) {
            String tempKey = (String)cnts[i][0];
            obj = cnts[i][1];
            if (tempKey == null || !tempKey.equals(key)) continue;
            return obj;
        }
        return null;
    }

    private final Object getObject(String key, ICUListResourceBundle actualBundle) {
        Object obj = this.handleGetObject(key);
        if (obj == null) {
            ICUListResourceBundle p = (ICUListResourceBundle)this.parent;
            while (p != null) {
                obj = p.handleGetObject(key);
                if (obj != null) {
                    actualBundle = p;
                    break;
                }
                p = (ICUListResourceBundle)p.parent;
            }
        }
        return obj;
    }

    private static boolean isIndex(String s) {
        if (s.length() == 1) {
            char c = s.charAt(0);
            return Character.isDigit(c);
        }
        return false;
    }

    private static int getIndex(String s) {
        char c;
        if (s.length() == 1 && Character.isDigit(c = s.charAt(0))) {
            return Integer.valueOf(s);
        }
        return -1;
    }

    public static class Alias {
        private String pathToResource;

        public Alias(String path) {
            this.pathToResource = path;
        }

        private Object getResource(String className, String parentKey, int index, Hashtable visited) {
            int i;
            String packageName = null;
            String bundleName = null;
            String locale = null;
            String keyPath = null;
            if (this.pathToResource.indexOf(47) == 0) {
                i = this.pathToResource.indexOf(47, 1);
                int j = this.pathToResource.indexOf(47, i + 1);
                bundleName = this.pathToResource.substring(1, i);
                locale = this.pathToResource.substring(i + 1);
                if (j != -1) {
                    locale = this.pathToResource.substring(i + 1, j);
                    keyPath = this.pathToResource.substring(j + 1, this.pathToResource.length());
                }
                if (bundleName.equals(ICUListResourceBundle.ICUDATA)) {
                    bundleName = ICUListResourceBundle.ICU_BUNDLE_NAME;
                    packageName = ICUListResourceBundle.ICU_PACKAGE_NAME;
                }
            } else {
                i = this.pathToResource.indexOf(47);
                int j = className.lastIndexOf(".");
                packageName = className.substring(0, j);
                int underScoreIndex = className.indexOf("_");
                bundleName = underScoreIndex >= 0 ? className.substring(j + 1, className.indexOf("_")) : className.substring(j + 1, className.length());
                keyPath = this.pathToResource.substring(i + 1);
                if (i != -1) {
                    locale = this.pathToResource.substring(0, i);
                } else {
                    locale = keyPath;
                    keyPath = parentKey;
                    className = locale == null || locale.equals("root") ? packageName + "." + bundleName : packageName + "." + bundleName + "_" + locale;
                }
            }
            ResourceBundle bundle = null;
            bundle = locale == null || locale.equals("root") ? ICULocaleData.getResourceBundle(packageName, bundleName, "") : ICULocaleData.getResourceBundle(packageName, bundleName, locale);
            return this.findResource(bundle, className, parentKey, index, keyPath, visited);
        }

        private Object findResource(Object[][] contents, String key) {
            for (int i = 0; i < contents.length; ++i) {
                String tempKey = (String)contents[i][0];
                Object value = contents[i][1];
                if (tempKey == null || value == null) {
                    throw new NullPointerException();
                }
                if (!tempKey.equals(key)) continue;
                return value;
            }
            return null;
        }

        private Object findResource(Object o, String[] keys, int start, int index) {
            Object obj = o;
            if (start < keys.length && keys[start] != null) {
                if (obj instanceof Object[][]) {
                    obj = this.findResource((Object[][])obj, keys[start]);
                } else if (obj instanceof Object[] && ICUListResourceBundle.isIndex(keys[start])) {
                    obj = ((Object[])obj)[ICUListResourceBundle.getIndex(keys[start])];
                }
                if (start + 1 < keys.length && keys[start + 1] != null) {
                    obj = this.findResource(obj, keys, start + 1, index);
                }
            } else if (index >= 0) {
                if (obj instanceof Object[][]) {
                    obj = this.findResource((Object[][])obj, Integer.toString(index));
                } else if (obj instanceof Object[]) {
                    obj = ((Object[])obj)[index];
                }
            }
            return obj;
        }

        private Object findResource(ResourceBundle bundle, String className, String requestedKey, int index, String aliasKey, Hashtable visited) {
            if (aliasKey != null && visited.get(className + aliasKey) != null) {
                throw new MissingResourceException("Circular Aliases in bundle.", bundle.getClass().getName(), requestedKey);
            }
            if (aliasKey == null) {
                aliasKey = requestedKey;
            }
            visited.put(className + requestedKey, "");
            String[] keys = ICUListResourceBundle.split(aliasKey, '/');
            Object o = null;
            if (keys.length > 0) {
                o = bundle.getObject(keys[0]);
                o = this.findResource(o, keys, 1, index);
            }
            o = this.resolveAliases(o, className, aliasKey, visited);
            return o;
        }

        private Object resolveAliases(Object o, String className, String key, Hashtable visited) {
            if (o instanceof Object[][]) {
                o = this.resolveAliases((Object[][])o, className, key, visited);
            } else if (o instanceof Object[]) {
                o = this.resolveAliases((Object[])o, className, key, visited);
            } else if (o instanceof Alias) {
                return ((Alias)o).getResource(className, key, -1, visited);
            }
            return o;
        }

        private Object resolveAliases(Object[][] o, String className, String key, Hashtable visited) {
            for (int i = 0; i < o.length; ++i) {
                o[i][1] = this.resolveAliases(o[i][1], className, key, visited);
            }
            return o;
        }

        private Object resolveAliases(Object[] o, String className, String key, Hashtable visited) {
            for (int i = 0; i < o.length; ++i) {
                o[i] = this.resolveAliases(o[i], className, key, visited);
            }
            return o;
        }
    }

    public static class ResourceString
    implements RedirectedResource {
        private char[] expanded = null;
        private String resName = null;

        public ResourceString(String name) {
            this.resName = "data/" + name;
        }

        public Object getResource(Object obj) {
            InputStream stream;
            if (this.expanded == null && (stream = ICUData.getStream(this.resName)) != null) {
                try {
                    InputStreamReader reader = new InputStreamReader(stream, ICUListResourceBundle.ENCODING);
                    this.expanded = ICUListResourceBundle.readToEOS(reader);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException("Could open converter for encoding: UTF-8");
                }
                return new String(this.expanded);
            }
            return "";
        }
    }

    public static class ResourceBinary
    implements RedirectedResource {
        private byte[] expanded = null;
        private String resName = null;

        public ResourceBinary(String name) {
            this.resName = "data/" + name;
        }

        public Object getResource(Object obj) {
            InputStream stream;
            if (this.expanded == null && (stream = ICUData.getStream(this.resName)) != null) {
                this.expanded = ICUListResourceBundle.readToEOS(stream);
                return this.expanded;
            }
            return "";
        }
    }

    private static interface RedirectedResource {
        public Object getResource(Object var1);
    }

    public static class CompressedBinary
    implements RedirectedResource {
        private byte[] expanded = null;
        private String compressed = null;

        public CompressedBinary(String str2) {
            this.compressed = str2;
        }

        public Object getResource(Object obj) {
            if (this.compressed == null) {
                return null;
            }
            if (this.expanded == null) {
                this.expanded = Utility.RLEStringToByteArray(this.compressed);
            }
            return this.expanded;
        }
    }
}

