/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.impl.ICUResourceBundleImpl;
import com.ibm.icu.impl.ICUResourceBundleIterator;
import com.ibm.icu.impl.ICUResourceBundleReader;
import com.ibm.icu.impl.URLHandler;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import com.ibm.icu.util.UResourceTypeMismatchException;
import com.ibm.icu.util.VersionInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Vector;

public abstract class ICUResourceBundle
extends UResourceBundle {
    protected static final String ICU_DATA_PATH = "com/ibm/icu/impl/";
    public static final String ICU_BUNDLE = "data/icudt34b";
    public static final String ICU_BASE_NAME = "com/ibm/icu/impl/data/icudt34b";
    public static final String ICU_COLLATION_BASE_NAME = "com/ibm/icu/impl/data/icudt34b/coll";
    public static final String ICU_RBNF_BASE_NAME = "com/ibm/icu/impl/data/icudt34b/rbnf";
    public static final String ICU_TRANSLIT_BASE_NAME = "com/ibm/icu/impl/data/icudt34b/translit";
    public static final ClassLoader ICU_DATA_CLASS_LOADER;
    protected static final String INSTALLED_LOCALES = "InstalledLocales";
    public static final int NONE = -1;
    public static final int STRING = 0;
    public static final int BINARY = 1;
    public static final int TABLE = 2;
    protected static final int ALIAS = 3;
    protected static final int TABLE32 = 4;
    public static final int INT = 7;
    public static final int ARRAY = 8;
    public static final int INT_VECTOR = 14;
    public static final int FROM_FALLBACK = 1;
    public static final int FROM_ROOT = 2;
    public static final int FROM_DEFAULT = 3;
    public static final int FROM_LOCALE = 4;
    private int loadingStatus = -1;
    private Vector keys = null;
    protected String key;
    protected int size = 1;
    protected String resPath;
    protected long resource = -1L;
    protected boolean isTopLevel = false;
    protected static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;
    protected static final long RES_BOGUS = -1L;
    private static final String ICU_RESOURCE_INDEX = "res_index";
    private static final String DEFAULT_TAG = "default";
    private static final boolean DEBUG;
    private static SoftReference GET_AVAILABLE_CACHE;
    static /* synthetic */ Class class$com$ibm$icu$impl$ICUData;

    public void setLoadingStatus(int newStatus) {
        this.loadingStatus = newStatus;
    }

    public int getLoadingStatus() {
        return this.loadingStatus;
    }

    protected boolean getNoFallback() {
        return false;
    }

    public VersionInfo getVersion() {
        return null;
    }

    public String getString() {
        throw new UResourceTypeMismatchException("");
    }

    public String[] getStringArray() {
        throw new UResourceTypeMismatchException("");
    }

    public ByteBuffer getBinary() {
        throw new UResourceTypeMismatchException("");
    }

    public int[] getIntVector() {
        throw new UResourceTypeMismatchException("");
    }

    public int getInt() {
        throw new UResourceTypeMismatchException("");
    }

    public int getUInt() {
        throw new UResourceTypeMismatchException("");
    }

    public int getSize() {
        return this.size;
    }

    public int getType() {
        int type = ICUResourceBundleImpl.RES_GET_TYPE(this.resource);
        if (type == 4) {
            return 2;
        }
        return type;
    }

    public String getKey() {
        return this.key;
    }

    public ICUResourceBundleIterator getIterator() {
        return new ICUResourceBundleIterator(this);
    }

    public ICUResourceBundle get(int index) {
        return this.getImpl(index, null, this);
    }

    protected ICUResourceBundle getImpl(int index, HashMap table, ICUResourceBundle requested) {
        ICUResourceBundle obj = this.handleGet(index, table, requested);
        if (obj == null) {
            obj = (ICUResourceBundle)this.getParent();
            if (obj != null) {
                obj = obj.getImpl(index, table, requested);
            }
            if (obj == null) {
                throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + this.getKey(), this.getClass().getName(), this.getKey());
            }
        }
        ICUResourceBundle.setLoadingStatus(obj, requested.getLocaleID());
        return obj;
    }

    public ICUResourceBundle get(String key) {
        return this.getImpl(key, null, this);
    }

    protected ICUResourceBundle getImpl(String key, HashMap table, ICUResourceBundle requested) {
        ICUResourceBundle obj = this.handleGet(key, table, requested);
        if (obj == null) {
            obj = (ICUResourceBundle)this.getParent();
            if (obj != null) {
                obj = obj.getImpl(key, table, requested);
            }
            if (obj == null) {
                String fullName = ICUResourceBundleReader.getFullName(this.getBaseName(), this.getLocaleID());
                throw new MissingResourceException("Can't find resource for bundle " + fullName + ", key " + key, this.getClass().getName(), key);
            }
        }
        ICUResourceBundle.setLoadingStatus(obj, requested.getLocaleID());
        return obj;
    }

    private static void setLoadingStatus(ICUResourceBundle bundle, String requestedLocale) {
        String locale = bundle.getLocaleID();
        if (locale.equals("root")) {
            bundle.setLoadingStatus(2);
            return;
        }
        if (locale.equals(requestedLocale)) {
            bundle.setLoadingStatus(4);
        } else {
            bundle.setLoadingStatus(1);
        }
    }

    public String getString(int index) {
        ICUResourceBundle temp = this.get(index);
        if (temp.getType() == 0) {
            return temp.getString();
        }
        throw new UResourceTypeMismatchException("");
    }

    public abstract UResourceBundle getParent();

    protected abstract String getLocaleID();

    public static final ULocale getFunctionalEquivalent(String baseName, String resName, String keyword, ULocale locID, boolean[] fillinIsAvailable) {
        ICUResourceBundle irb;
        String kwVal = locID.getKeywordValue(keyword);
        String baseLoc = locID.getBaseName();
        String defStr = null;
        ULocale parent = new ULocale(baseLoc);
        ULocale found = locID;
        ULocale defLoc = null;
        boolean lookForDefault = false;
        ULocale fullBase = null;
        int defDepth = 0;
        int resDepth = 0;
        if (fillinIsAvailable != null) {
            fillinIsAvailable[0] = true;
        }
        if (kwVal == null || kwVal.length() == 0 || kwVal.equals(DEFAULT_TAG)) {
            kwVal = "";
            lookForDefault = true;
        }
        ICUResourceBundle r = null;
        r = (ICUResourceBundle)UResourceBundle.getBundleInstance(baseName, parent);
        found = r.getULocale();
        if (fillinIsAvailable != null && !found.equals(parent)) {
            fillinIsAvailable[0] = false;
        }
        do {
            try {
                irb = r.get(resName);
                defStr = irb.getString(DEFAULT_TAG);
                if (lookForDefault) {
                    kwVal = defStr;
                    lookForDefault = false;
                }
                defLoc = r.getULocale();
            }
            catch (MissingResourceException t) {
                // empty catch block
            }
            if (defLoc != null) continue;
            r = (ICUResourceBundle)r.getParent();
            ++defDepth;
        } while (r != null && defLoc == null);
        parent = new ULocale(baseLoc);
        r = (ICUResourceBundle)UResourceBundle.getBundleInstance(baseName, parent);
        do {
            try {
                irb = r.get(resName);
                irb.get(kwVal);
                fullBase = irb.getULocale();
                if (fullBase != null && resDepth > defDepth) {
                    defStr = irb.getString(DEFAULT_TAG);
                    defLoc = r.getULocale();
                    defDepth = resDepth;
                }
            }
            catch (MissingResourceException t) {
                // empty catch block
            }
            if (fullBase != null) continue;
            r = (ICUResourceBundle)r.getParent();
            ++resDepth;
        } while (r != null && fullBase == null);
        if (fullBase == null && defStr != null && !defStr.equals(kwVal)) {
            kwVal = defStr;
            parent = new ULocale(baseLoc);
            r = (ICUResourceBundle)UResourceBundle.getBundleInstance(baseName, parent);
            resDepth = 0;
            do {
                try {
                    irb = r.get(resName);
                    ICUResourceBundle urb = irb.get(kwVal);
                    fullBase = r.getULocale();
                    if (!fullBase.toString().equals(((UResourceBundle)urb).getLocale().toString())) {
                        fullBase = null;
                    }
                    if (fullBase != null && resDepth > defDepth) {
                        defStr = irb.getString(DEFAULT_TAG);
                        defLoc = r.getULocale();
                        defDepth = resDepth;
                    }
                }
                catch (MissingResourceException t) {
                    // empty catch block
                }
                if (fullBase != null) continue;
                r = (ICUResourceBundle)r.getParent();
                ++resDepth;
            } while (r != null && fullBase == null);
        }
        if (fullBase == null) {
            throw new MissingResourceException("Could not find locale containing requested or default keyword.", baseName, keyword + "=" + kwVal);
        }
        if (defStr.equals(kwVal) && resDepth <= defDepth) {
            return fullBase;
        }
        return new ULocale(fullBase.toString() + "@" + keyword + "=" + kwVal);
    }

    public static final String[] getKeywordValues(String baseName, String keyword) {
        HashSet keywords = new HashSet();
        ULocale[] locales = ICUResourceBundle.createULocaleList(baseName, ICU_DATA_CLASS_LOADER);
        for (int i = 0; i < locales.length; ++i) {
            try {
                UResourceBundle b = UResourceBundle.getBundleInstance(baseName, locales[i]);
                ICUResourceBundle irb = (ICUResourceBundle)b.getObject(keyword);
                Enumeration e2 = irb.getKeys();
                while (e2.hasMoreElements()) {
                    Object s = e2.nextElement();
                    if (!(s instanceof String) || DEFAULT_TAG.equals(s)) continue;
                    keywords.add(s);
                }
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return keywords.toArray(new String[0]);
    }

    public ICUResourceBundle getWithFallback(String path) throws MissingResourceException {
        ICUResourceBundle result = null;
        ICUResourceBundle actualBundle = this;
        result = ICUResourceBundle.findResourceWithFallback(path, actualBundle, null);
        if (result == null) {
            throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + this.getType(), path, this.getKey());
        }
        return result;
    }

    public String getStringWithFallback(String path) throws MissingResourceException {
        return this.getWithFallback(path).getString();
    }

    public static Set getAvailableLocaleNameSet(String bundlePrefix) {
        return ICUResourceBundle.getAvailEntry(bundlePrefix).getLocaleNameSet();
    }

    public static Set getFullLocaleNameSet() {
        return ICUResourceBundle.getFullLocaleNameSet(ICU_BASE_NAME);
    }

    public static Set getFullLocaleNameSet(String bundlePrefix) {
        return ICUResourceBundle.getAvailEntry(bundlePrefix).getFullLocaleNameSet();
    }

    public static Set getAvailableLocaleNameSet() {
        return ICUResourceBundle.getAvailableLocaleNameSet(ICU_BASE_NAME);
    }

    public static final ULocale[] getAvailableULocales(String baseName) {
        return ICUResourceBundle.getAvailEntry(baseName).getULocaleList();
    }

    public static final ULocale[] getAvailableULocales() {
        return ICUResourceBundle.getAvailableULocales(ICU_BASE_NAME);
    }

    public static final Locale[] getAvailableLocales(String baseName) {
        return ICUResourceBundle.getAvailEntry(baseName).getLocaleList();
    }

    public static final Locale[] getAvailableLocales() {
        return ICUResourceBundle.getAvailEntry(ICU_BASE_NAME).getLocaleList();
    }

    public static final Locale[] getLocaleList(ULocale[] ulocales) {
        ArrayList<Locale> list = new ArrayList<Locale>();
        for (int i = 0; i < ulocales.length; ++i) {
            if (ulocales[i].getScript().length() != 0) continue;
            list.add(ulocales[i].toLocale());
        }
        return list.toArray(new Locale[list.size()]);
    }

    public Enumeration getKeys() {
        this.initKeysVector();
        return this.keys.elements();
    }

    private synchronized void initKeysVector() {
        if (this.keys != null) {
            return;
        }
        this.keys = new Vector();
        for (ICUResourceBundle current = this; current != null; current = (ICUResourceBundle)current.getParent()) {
            Enumeration e2 = current.handleGetKeys();
            while (e2.hasMoreElements()) {
                String elem = (String)e2.nextElement();
                if (this.keys.contains(elem)) continue;
                this.keys.add(elem);
            }
        }
    }

    protected Enumeration handleGetKeys() {
        Vector<String> keys = new Vector<String>();
        ICUResourceBundle item = null;
        for (int i = 0; i < this.size; ++i) {
            item = this.get(i);
            keys.add(item.getKey());
        }
        return keys.elements();
    }

    public static ICUResourceBundle createBundle(String baseName, String localeID, ClassLoader root2) {
        ICUResourceBundle b = ICUResourceBundleImpl.createBundle(baseName, localeID, root2);
        if (b == null) {
            throw new MissingResourceException("Could not find the bundle " + baseName + "/" + localeID + ".res", "", "");
        }
        return b;
    }

    protected ICUResourceBundle handleGet(String key, HashMap table, ICUResourceBundle requested) {
        throw new UResourceTypeMismatchException("");
    }

    protected ICUResourceBundle handleGet(int index, HashMap table, ICUResourceBundle requested) {
        throw new UResourceTypeMismatchException("");
    }

    public Locale getLocale() {
        return this.getULocale().toLocale();
    }

    protected Object handleGetObject(String key) {
        return this.handleGetObjectImpl(key, this);
    }

    private Object handleGetObjectImpl(String key, ICUResourceBundle requested) {
        Object obj = this.resolveObject(key, requested);
        if (obj == null) {
            ICUResourceBundle parent = (ICUResourceBundle)this.getParent();
            if (parent != null) {
                obj = parent.handleGetObjectImpl(key, requested);
            }
            if (obj == null) {
                throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + key, this.getClass().getName(), key);
            }
        }
        return obj;
    }

    private Object resolveObject(String key, ICUResourceBundle requested) {
        if (this.getType() == 0) {
            return this.getString();
        }
        ICUResourceBundle obj = this.handleGet(key, requested);
        if (obj != null) {
            if (obj.getType() == 0) {
                return obj.getString();
            }
            try {
                if (obj.getType() == 8) {
                    return obj.handleGetStringArray();
                }
            }
            catch (UResourceTypeMismatchException ex) {
                return obj;
            }
        }
        return obj;
    }

    protected ICUResourceBundle handleGet(int index, ICUResourceBundle requested) {
        return null;
    }

    protected ICUResourceBundle handleGet(String key, ICUResourceBundle requested) {
        return null;
    }

    protected String[] handleGetStringArray() {
        return null;
    }

    private static final ULocale[] createULocaleList(String baseName, ClassLoader root2) {
        ICUResourceBundle bundle = ICUResourceBundle.createBundle(baseName, ICU_RESOURCE_INDEX, root2);
        bundle = bundle.get(INSTALLED_LOCALES);
        int length = bundle.getSize();
        int i = 0;
        ULocale[] locales = new ULocale[length];
        ICUResourceBundleIterator iter = bundle.getIterator();
        iter.reset();
        while (iter.hasNext()) {
            locales[i++] = new ULocale(iter.next().getKey());
        }
        bundle = null;
        return locales;
    }

    private static final Locale[] createLocaleList(String baseName) {
        ULocale[] ulocales = ICUResourceBundle.getAvailEntry(baseName).getULocaleList();
        return ICUResourceBundle.getLocaleList(ulocales);
    }

    private static final String[] createLocaleNameArray(String baseName, ClassLoader root2) {
        ICUResourceBundle bundle = ICUResourceBundle.createBundle(baseName, ICU_RESOURCE_INDEX, root2);
        bundle = bundle.get(INSTALLED_LOCALES);
        int length = bundle.getSize();
        int i = 0;
        String[] locales = new String[length];
        ICUResourceBundleIterator iter = bundle.getIterator();
        iter.reset();
        while (iter.hasNext()) {
            locales[i++] = iter.next().getKey();
        }
        bundle = null;
        return locales;
    }

    private static final ArrayList createFullLocaleNameArray(final String baseName, final ClassLoader root2) {
        ArrayList list = (ArrayList)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String bn = baseName.endsWith("/") ? baseName : baseName + "/";
                try {
                    InputStream s = root2.getResourceAsStream(bn + ICUResourceBundle.ICU_RESOURCE_INDEX + ".txt");
                    if (s != null) {
                        String line;
                        ArrayList<String> list = new ArrayList<String>();
                        BufferedReader br = new BufferedReader(new InputStreamReader(s, "ASCII"));
                        while ((line = br.readLine()) != null) {
                            if (line.length() == 0 || line.startsWith("#")) continue;
                            list.add(line);
                        }
                        return list;
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                URL url = root2.getResource(bn);
                URLHandler handler = URLHandler.get(url);
                if (handler != null) {
                    ArrayList list = new ArrayList();
                    URLHandler.URLVisitor v = new URLHandler.URLVisitor(this, list){
                        private final /* synthetic */ ArrayList val$list;
                        private final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = this$0;
                            this.val$list = val$list;
                        }

                        public void visit(String s) {
                            if (s.endsWith(".res") && !"res_index.res".equals(s)) {
                                this.val$list.add(s.substring(0, s.length() - 4));
                            }
                        }
                    };
                    handler.guide(v, false);
                    return list;
                }
                return null;
            }
        });
        return list;
    }

    private static Set createFullLocaleNameSet(String baseName) {
        ArrayList list = ICUResourceBundle.createFullLocaleNameArray(baseName, ICU_DATA_CLASS_LOADER);
        HashSet set = new HashSet();
        if (list == null) {
            throw new MissingResourceException("Could not find res_index", "", "");
        }
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static Set createLocaleNameSet(String baseName) {
        try {
            String[] locales = ICUResourceBundle.createLocaleNameArray(baseName, ICU_DATA_CLASS_LOADER);
            HashSet<String> set = new HashSet<String>();
            set.addAll(Arrays.asList(locales));
            return Collections.unmodifiableSet(set);
        }
        catch (MissingResourceException e2) {
            if (DEBUG) {
                System.out.println("couldn't find index for bundleName: " + baseName);
                Thread.dumpStack();
            }
            return Collections.EMPTY_SET;
        }
    }

    private static AvailEntry getAvailEntry(String key) {
        AvailEntry ae = null;
        HashMap<String, AvailEntry> lcache = null;
        if (GET_AVAILABLE_CACHE != null && (lcache = (HashMap<String, AvailEntry>)GET_AVAILABLE_CACHE.get()) != null) {
            ae = (AvailEntry)lcache.get(key);
        }
        if (ae == null) {
            ae = new AvailEntry(key);
            if (lcache == null) {
                lcache = new HashMap<String, AvailEntry>();
                lcache.put(key, ae);
                GET_AVAILABLE_CACHE = new SoftReference(lcache);
            } else {
                lcache.put(key, ae);
            }
        }
        return ae;
    }

    protected static final ICUResourceBundle findResourceWithFallback(String path, ICUResourceBundle actualBundle, ICUResourceBundle requested) {
        ICUResourceBundle sub = null;
        if (requested == null) {
            requested = actualBundle;
        }
        while (actualBundle != null) {
            String subKey;
            StringTokenizer st = new StringTokenizer(path, "/");
            ICUResourceBundle current = actualBundle;
            while (st.hasMoreTokens() && (sub = current.handleGet(subKey = st.nextToken(), requested)) != null) {
                current = sub;
            }
            if (sub != null) break;
            if (actualBundle.resPath.length() != 0) {
                path = actualBundle.resPath + "/" + path;
            }
            actualBundle = (ICUResourceBundle)actualBundle.getParent();
        }
        if (sub != null) {
            ICUResourceBundle.setLoadingStatus(sub, requested.getLocaleID());
        }
        return sub;
    }

    public boolean equals(Object other) {
        if (other instanceof ICUResourceBundle) {
            ICUResourceBundle o = (ICUResourceBundle)other;
            if (this.getBaseName().equals(o.getBaseName()) && this.getLocaleID().equals(o.getLocaleID())) {
                return true;
            }
        }
        return false;
    }

    public static UResourceBundle getBundleInstance(String baseName, String localeID, ClassLoader root2, boolean disableFallback) {
        UResourceBundle b = ICUResourceBundle.instantiateBundle(baseName, localeID, root2, disableFallback);
        if (b == null) {
            throw new MissingResourceException("Could not find the bundle " + baseName + "/" + localeID + ".res", "", "");
        }
        return b;
    }

    protected static synchronized UResourceBundle instantiateBundle(String baseName, String localeID, ClassLoader root2, boolean disableFallback) {
        ULocale defaultLocale = ULocale.getDefault();
        String localeName = localeID;
        if (localeName.indexOf(64) > 0) {
            localeName = ULocale.getBaseName(localeID);
        }
        String fullName = ICUResourceBundleReader.getFullName(baseName, localeName);
        ICUResourceBundle b = (ICUResourceBundle)ICUResourceBundle.loadFromCache(root2, fullName, defaultLocale);
        String rootLocale = baseName.indexOf(46) == -1 ? "root" : "";
        String defaultID = ULocale.getDefault().toString();
        if (localeName.equals("")) {
            localeName = rootLocale;
        }
        if (DEBUG) {
            System.out.println("Creating " + fullName + " currently b is " + b);
        }
        if (b == null) {
            b = ICUResourceBundleImpl.createBundle(baseName, localeName, root2);
            if (DEBUG) {
                System.out.println("The bundle created is: " + b + " and disableFallback=" + disableFallback + " and bundle.getNoFallback=" + (b != null && b.getNoFallback()));
            }
            if (disableFallback || b != null && b.getNoFallback()) {
                return b;
            }
            if (b == null) {
                int i = localeName.lastIndexOf(95);
                if (i != -1) {
                    String temp = localeName.substring(0, i);
                    b = (ICUResourceBundle)ICUResourceBundle.instantiateBundle(baseName, temp, root2, disableFallback);
                    if (b != null && b.getULocale().equals(temp)) {
                        b.setLoadingStatus(1);
                    }
                } else if (defaultID.indexOf(localeName) == -1) {
                    b = (ICUResourceBundle)ICUResourceBundle.instantiateBundle(baseName, defaultID, root2, disableFallback);
                    if (b != null) {
                        b.setLoadingStatus(3);
                    }
                } else if (rootLocale.length() != 0 && (b = ICUResourceBundleImpl.createBundle(baseName, rootLocale, root2)) != null) {
                    b.setLoadingStatus(2);
                }
            } else {
                UResourceBundle parent = null;
                localeName = b.getLocaleID();
                int i = localeName.lastIndexOf(95);
                ICUResourceBundle.addToCache(root2, fullName, defaultLocale, b);
                if (i != -1) {
                    parent = ICUResourceBundle.instantiateBundle(baseName, localeName.substring(0, i), root2, disableFallback);
                } else if (!localeName.equals(rootLocale)) {
                    parent = ICUResourceBundleImpl.createBundle(baseName, rootLocale, root2);
                }
                if (!b.equals(parent)) {
                    b.setParent(parent);
                }
            }
        }
        return b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ClassLoader loader = (class$com$ibm$icu$impl$ICUData == null ? (class$com$ibm$icu$impl$ICUData = ICUResourceBundle.class$("com.ibm.icu.impl.ICUData")) : class$com$ibm$icu$impl$ICUData).getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        ICU_DATA_CLASS_LOADER = loader;
        DEBUG = ICUDebug.enabled("localedata");
    }

    private static final class AvailEntry {
        private String prefix;
        private ULocale[] ulocales;
        private Locale[] locales;
        private Set nameSet;
        private Set fullNameSet;

        AvailEntry(String prefix) {
            this.prefix = prefix;
        }

        ULocale[] getULocaleList() {
            if (this.ulocales == null) {
                this.ulocales = ICUResourceBundle.createULocaleList(this.prefix, ICU_DATA_CLASS_LOADER);
            }
            return this.ulocales;
        }

        Locale[] getLocaleList() {
            if (this.locales == null) {
                this.locales = ICUResourceBundle.createLocaleList(this.prefix);
            }
            return this.locales;
        }

        Set getLocaleNameSet() {
            if (this.nameSet == null) {
                this.nameSet = ICUResourceBundle.createLocaleNameSet(this.prefix);
            }
            return this.nameSet;
        }

        Set getFullLocaleNameSet() {
            if (this.fullNameSet == null) {
                this.fullNameSet = ICUResourceBundle.createFullLocaleNameSet(this.prefix);
            }
            return this.fullNameSet;
        }
    }
}

