/*
 * Decompiled with CFR 0.152.
 */
package jena.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import jena.rdfcat;
import junit.framework.TestCase;

public class Test_rdfcat
extends TestCase {
    public void testAbbreviationTable() {
        Test_rdfcat.assertEquals((Object)"RDF/XML", rdfcat.unabbreviate.get("x"));
        Test_rdfcat.assertEquals((Object)"RDF/XML", rdfcat.unabbreviate.get("rdf"));
        Test_rdfcat.assertEquals((Object)"RDF/XML", rdfcat.unabbreviate.get("rdfxml"));
        Test_rdfcat.assertEquals((Object)"RDF/XML", rdfcat.unabbreviate.get("xml"));
        Test_rdfcat.assertEquals((Object)"N3", rdfcat.unabbreviate.get("n3"));
        Test_rdfcat.assertEquals((Object)"N3", rdfcat.unabbreviate.get("n"));
        Test_rdfcat.assertEquals((Object)"N3", rdfcat.unabbreviate.get("ttl"));
        Test_rdfcat.assertEquals((Object)"N-TRIPLE", rdfcat.unabbreviate.get("ntriples"));
        Test_rdfcat.assertEquals((Object)"N-TRIPLE", rdfcat.unabbreviate.get("ntriple"));
        Test_rdfcat.assertEquals((Object)"N-TRIPLE", rdfcat.unabbreviate.get("t"));
        Test_rdfcat.assertEquals((Object)"RDF/XML-ABBREV", rdfcat.unabbreviate.get("owl"));
        Test_rdfcat.assertEquals((Object)"RDF/XML-ABBREV", rdfcat.unabbreviate.get("abbrev"));
    }

    public void testExistingLanguage() {
        Test_rdfcat.assertEquals((String)"RDF/XML", (String)rdfcat.getCheckedLanguage("x"));
        Test_rdfcat.assertEquals((String)"RDF/XML", (String)rdfcat.getCheckedLanguage("xml"));
        Test_rdfcat.assertEquals((String)"RDF/XML-ABBREV", (String)rdfcat.getCheckedLanguage("owl"));
        Test_rdfcat.assertEquals((String)"N3", (String)rdfcat.getCheckedLanguage("N3"));
        Test_rdfcat.assertEquals((String)"N-TRIPLE", (String)rdfcat.getCheckedLanguage("N-TRIPLE"));
    }

    public void testNonexistantLanguage() {
        try {
            rdfcat.getCheckedLanguage("noSuchLanguageAsThisOneFruitcake");
            Test_rdfcat.fail((String)"should trap non-existant language");
        }
        catch (IllegalArgumentException e2) {
            Test_rdfcat.assertTrue((String)"message should mention bad language", (e2.getMessage().indexOf("Fruitcake") > 0 ? (byte)1 : 0) != 0);
        }
    }

    public void testRdfcatIdentity() {
        Model source = ModelFactory.createDefaultModel();
        source.read("file:testing/cmd/rdfcat.xml", "RDF/XML");
        ByteArrayOutputStream so = new ByteArrayOutputStream();
        rdfcatFixture rc = new rdfcatFixture(so);
        rc.testGo(new String[]{"file:testing/cmd/rdfcat.xml"});
        Model output = this.asModel(so, "RDF/XML");
        Test_rdfcat.assertTrue((boolean)output.isIsomorphicWith(source));
    }

    public void testRdfcatConcat() {
        Model source = ModelFactory.createDefaultModel();
        source.read("file:testing/cmd/rdfcat.xml", "RDF/XML");
        ByteArrayOutputStream so = new ByteArrayOutputStream();
        rdfcatFixture rc = new rdfcatFixture(so);
        rc.testGo(new String[]{"file:testing/cmd/rdfcat_1.xml", "file:testing/cmd/rdfcat_2.xml"});
        Model output = this.asModel(so, "RDF/XML");
        Test_rdfcat.assertTrue((boolean)output.isIsomorphicWith(source));
    }

    public void testRdfcatConcat1() {
        Model source = ModelFactory.createDefaultModel();
        source.read("file:testing/cmd/rdfcat.xml", "RDF/XML");
        ByteArrayOutputStream so = new ByteArrayOutputStream();
        rdfcatFixture rc = new rdfcatFixture(so);
        rc.testGo(new String[]{"-in", "N3", "file:testing/cmd/rdfcat_1_n3", "file:testing/cmd/rdfcat_2_n3"});
        Model output = this.asModel(so, "RDF/XML");
        Test_rdfcat.assertTrue((boolean)output.isIsomorphicWith(source));
    }

    public void testRdfcatN3ToRDFXML_0() {
        this.doTestRdfcatOutput("-n", "file:testing/cmd/rdfcat.n3", "RDF/XML", "RDF/XML");
    }

    public void testRdfcatN3ToRDFXML_1() {
        this.doTestRdfcatOutput("-n3", "file:testing/cmd/rdfcat.n3", "RDF/XML", "RDF/XML");
    }

    public void testRdfcatN3ToRDFXML_2() {
        this.doTestRdfcatOutput("-ttl", "file:testing/cmd/rdfcat.n3", "RDF/XML", "RDF/XML");
    }

    public void testRdfcatN3ToRDFXML_3() {
        this.doTestRdfcatOutput("-N3", "file:testing/cmd/rdfcat.n3", "RDF/XML", "RDF/XML");
    }

    public void testRdfcatN3ToNtriple() {
        this.doTestRdfcatOutput("-n", "file:testing/cmd/rdfcat.n3", "N-TRIPLE", "N-TRIPLE");
    }

    public void testRdfcatN3ToN3() {
        this.doTestRdfcatOutput("-n", "file:testing/cmd/rdfcat.n3", "N3", "N3");
    }

    public void testRdfcatN3ToRDFXMLDefault() {
        this.doTestRdfcatOutput(null, "file:testing/cmd/rdfcat.n3", "RDF/XML", "RDF/XML");
    }

    public void testRdfcatRDFXMLToRDFXML_0() {
        this.doTestRdfcatOutput("-x", "file:testing/cmd/rdfcat.xml", "RDF/XML", "RDF/XML");
    }

    public void testRdfcatRDFXMLToRDFXML_1() {
        this.doTestRdfcatOutput("-xml", "file:testing/cmd/rdfcat.xml", "RDF/XML", "RDF/XML");
    }

    public void testRdfcatRDFXMLToRDFXML_2() {
        this.doTestRdfcatOutput("-rdfxml", "file:testing/cmd/rdfcat.xml", "RDF/XML", "RDF/XML");
    }

    public void testRdfcatRDFXMLToRDFXML_3() {
        this.doTestRdfcatOutput("-rdf", "file:testing/cmd/rdfcat.xml", "RDF/XML", "RDF/XML");
    }

    public void testRdfcatRDFXMLToNtriple() {
        this.doTestRdfcatOutput("-x", "file:testing/cmd/rdfcat.xml", "N-TRIPLE", "N-TRIPLE");
    }

    public void testRdfcatRDFXMLToN3() {
        this.doTestRdfcatOutput("-x", "file:testing/cmd/rdfcat.xml", "N3", "N3");
    }

    public void testRdfcatRDFXMLToRDFXMLDefault() {
        this.doTestRdfcatOutput(null, "file:testing/cmd/rdfcat.xml", "RDF/XML", "RDF/XML");
    }

    public void testRdfcatNtripleToRDFXML_0() {
        this.doTestRdfcatOutput("-t", "file:testing/cmd/rdfcat.nt", "RDF/XML", "RDF/XML");
    }

    public void testRdfcatNtripleToRDFXML_1() {
        this.doTestRdfcatOutput("-ntriple", "file:testing/cmd/rdfcat.nt", "RDF/XML", "RDF/XML");
    }

    public void testRdfcatNtripleToRDFXML_2() {
        this.doTestRdfcatOutput("-ntriples", "file:testing/cmd/rdfcat.nt", "RDF/XML", "RDF/XML");
    }

    public void testRdfcatNtripleToRDFXML_3() {
        this.doTestRdfcatOutput("-n-triple", "file:testing/cmd/rdfcat.nt", "RDF/XML", "RDF/XML");
    }

    public void testRdfcatNtripleToNtriple() {
        this.doTestRdfcatOutput("-t", "file:testing/cmd/rdfcat.nt", "N-TRIPLE", "N-TRIPLE");
    }

    public void testRdfcatNtripleToN3() {
        this.doTestRdfcatOutput("-t", "file:testing/cmd/rdfcat.nt", "N3", "N3");
    }

    public void testRdfcatNtripleToRDFXMLDefault() {
        this.doTestRdfcatOutput(null, "file:testing/cmd/rdfcat.nt", "RDF/XML", "RDF/XML");
    }

    public void doTestRdfcatOutput(String inFormArg, String inputArg, String outFormArg, String parseAs) {
        Model source = ModelFactory.createDefaultModel();
        source.read("file:testing/cmd/rdfcat.xml");
        ByteArrayOutputStream so = new ByteArrayOutputStream();
        rdfcatFixture rc = new rdfcatFixture(so);
        ArrayList<String> l = new ArrayList<String>();
        if (outFormArg != null) {
            l.add("-out");
            l.add(outFormArg);
        }
        if (inFormArg != null) {
            l.add(inFormArg);
        }
        l.add(inputArg);
        String[] args = new String[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            args[i] = (String)l.get(i);
        }
        rc.testGo(args);
        Model output = this.asModel(so, parseAs);
        Test_rdfcat.assertTrue((boolean)output.isIsomorphicWith(source));
    }

    protected Model asModel(OutputStream so, String syntax) {
        String out = so.toString();
        Model output = ModelFactory.createDefaultModel();
        output.read(new StringReader(out), "http://example.com/foo", syntax);
        return output;
    }

    protected class rdfcatFixture
    extends rdfcat {
        private OutputStream m_so;

        protected rdfcatFixture(OutputStream so) {
            this.m_so = so;
        }

        protected OutputStream getOutputStream() {
            return this.m_so;
        }

        protected void testGo(String[] args) {
            this.go(args);
        }
    }
}

