/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public final class SequenceOutputter
extends SequenceWriter {
    private List<Item<?>> list;

    public SequenceOutputter(PipelineConfiguration pipe) {
        this(pipe, 50);
    }

    public SequenceOutputter(PipelineConfiguration pipe, int estimatedSize) {
        super(pipe);
        this.list = new ArrayList(estimatedSize);
    }

    public static SequenceOutputter allocateSequenceOutputter(XPathContext context, int hostLang) {
        Controller controller = context.getController();
        SequenceOutputter seq2 = controller.allocateSequenceOutputter(20);
        seq2.getPipelineConfiguration().setHostLanguage(hostLang);
        return seq2;
    }

    public void reset() {
        this.list = new ArrayList(Math.min(this.list.size() + 10, 50));
    }

    @Override
    public void write(Item item) {
        this.list.add(item);
    }

    public Sequence<?> getSequence() {
        switch (this.list.size()) {
            case 0: {
                return EmptySequence.getInstance();
            }
            case 1: {
                return this.list.get(0);
            }
        }
        return new SequenceExtent(this.list);
    }

    public SequenceIterator<Item<?>> iterate() {
        if (this.list.isEmpty()) {
            return EmptyIterator.emptyIterator();
        }
        return new ListIterator(this.list);
    }

    public List<Item<?>> getList() {
        return this.list;
    }

    public Item getFirstItem() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.get(0);
    }

    public Item popLastItem() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.remove(this.list.size() - 1);
    }
}

