/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.expr.sort.GenericSorter;
import net.sf.saxon.expr.sort.Sortable;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.ma.arrays.ArraySort;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;

public class Sort_1
extends SystemFunction {
    @Override
    public Sequence<?> call(XPathContext context, Sequence[] arguments) throws XPathException {
        List<ItemToBeSorted> inputList = this.getItemsToBeSorted(arguments[0]);
        StringCollator collation2 = context.getConfiguration().getCollation(this.getRetainedStaticContext().getDefaultCollationName());
        return this.doSort(inputList, collation2, context);
    }

    protected List<ItemToBeSorted> getItemsToBeSorted(Sequence<?> input) throws XPathException {
        Object item;
        ArrayList<ItemToBeSorted> inputList = new ArrayList<ItemToBeSorted>();
        int i = 0;
        SequenceIterator<?> iterator = input.iterate();
        while ((item = iterator.next()) != null) {
            ItemToBeSorted member = new ItemToBeSorted();
            member.value = item;
            member.originalPosition = i++;
            member.sortKey = item.atomize();
            inputList.add(member);
        }
        return inputList;
    }

    protected Sequence<?> doSort(final List<ItemToBeSorted> inputList, StringCollator collation2, XPathContext context) throws XPathException {
        final AtomicComparer atomicComparer = AtomicSortComparer.makeSortComparer(collation2, 632, context);
        Sortable sortable = new Sortable(){

            @Override
            public int compare(int a, int b) {
                int result = ArraySort.compareSortKeys(((ItemToBeSorted)inputList.get((int)a)).sortKey, ((ItemToBeSorted)inputList.get((int)b)).sortKey, atomicComparer);
                if (result == 0) {
                    return ((ItemToBeSorted)inputList.get((int)a)).originalPosition - ((ItemToBeSorted)inputList.get((int)b)).originalPosition;
                }
                return result;
            }

            @Override
            public void swap(int a, int b) {
                ItemToBeSorted temp = (ItemToBeSorted)inputList.get(a);
                inputList.set(a, inputList.get(b));
                inputList.set(b, temp);
            }
        };
        try {
            GenericSorter.quickSort(0, inputList.size(), sortable);
        }
        catch (ClassCastException e2) {
            XPathException err = new XPathException("Non-comparable types found while sorting: " + e2.getMessage());
            err.setErrorCode("XPTY0004");
            throw err;
        }
        ArrayList<Item> outputList = new ArrayList<Item>(inputList.size());
        for (ItemToBeSorted member : inputList) {
            outputList.add(member.value);
        }
        return new SequenceExtent(outputList);
    }

    public static class ItemToBeSorted {
        public Item value;
        public GroundedValue sortKey;
        public int originalPosition;
    }
}

