/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.io.Printable;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonBoolean;
import org.apache.jena.atlas.json.JsonException;
import org.apache.jena.atlas.json.JsonNumber;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonString;
import org.apache.jena.atlas.json.JsonVisitor;
import org.apache.jena.atlas.json.io.JsonWriter;

public abstract class JsonValue
implements Printable {
    public boolean isObject() {
        return false;
    }

    public JsonObject getAsObject() {
        throw new JsonException("Not a JSON object");
    }

    public boolean isArray() {
        return this instanceof JsonArray;
    }

    public JsonArray getAsArray() {
        throw new JsonException("Not a JSON array");
    }

    public boolean isPrimitive() {
        return this.isString() || this.isNumber() || this.isBoolean() || this.isNull();
    }

    public boolean isNull() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public JsonNumber getAsNumber() {
        throw new JsonException("Not a JSON number");
    }

    public boolean isString() {
        return false;
    }

    public JsonString getAsString() {
        throw new JsonException("Not a JSON string");
    }

    public boolean isBoolean() {
        return false;
    }

    public JsonBoolean getAsBoolean() {
        throw new JsonException("Not a JSON boolean");
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract void visit(JsonVisitor var1);

    public String toString() {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        this.output(buff);
        return buff.asString();
    }

    @Override
    public void output(IndentedWriter out) {
        JsonWriter w = new JsonWriter(out);
        w.startOutput();
        this.visit(w);
        w.finishOutput();
    }
}

