/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.setup;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonParseException;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.base.block.FileMode;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.setup.StoreParams;
import org.apache.jena.tdb.setup.StoreParamsBuilder;

public class StoreParamsCodec {
    private static final String jsonKeyPrefix = "tdb.";

    public static void write(Location location, StoreParams params) {
        StoreParamsCodec.write(location.getPath("tdb.cfg"), params);
    }

    public static void write(String filename, StoreParams params) {
        try (FileOutputStream out = new FileOutputStream(filename);
             BufferedOutputStream out2 = new BufferedOutputStream(out);){
            JsonObject object = StoreParamsCodec.encodeToJson(params);
            JSON.write(out2, (JsonValue)object);
            ((OutputStream)out2).write(10);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static StoreParams read(Location location) {
        return StoreParamsCodec.read(location.getPath("tdb.cfg"));
    }

    public static StoreParams read(String filename) {
        try {
            JsonObject obj = JSON.read(filename);
            return StoreParamsCodec.decode(obj);
        }
        catch (JsonParseException ex) {
            return null;
        }
        catch (AtlasException ex) {
            return null;
        }
    }

    public static JsonObject encodeToJson(StoreParams params) {
        JsonBuilder builder = new JsonBuilder();
        builder.startObject("StoreParams");
        StoreParamsCodec.encode(builder, StoreParamsCodec.key("file_mode"), params.getFileMode().name());
        StoreParamsCodec.encode(builder, StoreParamsCodec.key("block_size"), params.getBlockSize());
        StoreParamsCodec.encode(builder, StoreParamsCodec.key("block_read_cache_size"), params.getBlockReadCacheSize());
        StoreParamsCodec.encode(builder, StoreParamsCodec.key("block_write_cache_size"), params.getBlockWriteCacheSize());
        StoreParamsCodec.encode(builder, StoreParamsCodec.key("node2nodeid_cache_size"), params.getNode2NodeIdCacheSize());
        StoreParamsCodec.encode(builder, StoreParamsCodec.key("nodeid2node_cache_size"), params.getNodeId2NodeCacheSize());
        StoreParamsCodec.encode(builder, StoreParamsCodec.key("node_miss_cache_size"), params.getNodeMissCacheSize());
        StoreParamsCodec.encode(builder, StoreParamsCodec.key("index_node2id"), params.getIndexNode2Id());
        StoreParamsCodec.encode(builder, StoreParamsCodec.key("index_id2node"), params.getIndexId2Node());
        StoreParamsCodec.encode(builder, StoreParamsCodec.key("triple_index_primary"), params.getPrimaryIndexTriples());
        StoreParamsCodec.encode(builder, StoreParamsCodec.key("triple_indexes"), params.getTripleIndexes());
        StoreParamsCodec.encode(builder, StoreParamsCodec.key("quad_index_primary"), params.getPrimaryIndexQuads());
        StoreParamsCodec.encode(builder, StoreParamsCodec.key("quad_indexes"), params.getQuadIndexes());
        StoreParamsCodec.encode(builder, StoreParamsCodec.key("prefix_index_primary"), params.getPrimaryIndexPrefix());
        StoreParamsCodec.encode(builder, StoreParamsCodec.key("prefix_indexes"), params.getPrefixIndexes());
        StoreParamsCodec.encode(builder, StoreParamsCodec.key("file_prefix_index"), params.getIndexPrefix());
        StoreParamsCodec.encode(builder, StoreParamsCodec.key("file_prefix_nodeid"), params.getPrefixNode2Id());
        StoreParamsCodec.encode(builder, StoreParamsCodec.key("file_prefix_id2node"), params.getPrefixId2Node());
        builder.finishObject("StoreParams");
        return (JsonObject)builder.build();
    }

    private static String key(String string) {
        if (string.startsWith(jsonKeyPrefix)) {
            throw new TDBException("Key name already starts with 'tdb.'");
        }
        return jsonKeyPrefix + string;
    }

    private static String unkey(String string) {
        if (!string.startsWith(jsonKeyPrefix)) {
            throw new TDBException("JSON key name does not start with 'tdb.'");
        }
        return string.substring(jsonKeyPrefix.length());
    }

    public static StoreParams decode(JsonObject json) {
        StoreParamsBuilder builder = StoreParams.builder();
        block40: for (String key : json.keys()) {
            String short_key;
            switch (short_key = StoreParamsCodec.unkey(key)) {
                case "file_mode": {
                    builder.fileMode(FileMode.valueOf(StoreParamsCodec.getString(json, key)));
                    continue block40;
                }
                case "block_size": {
                    builder.blockSize(StoreParamsCodec.getInt(json, key));
                    continue block40;
                }
                case "block_read_cache_size": {
                    builder.blockReadCacheSize(StoreParamsCodec.getInt(json, key));
                    continue block40;
                }
                case "block_write_cache_size": {
                    builder.blockWriteCacheSize(StoreParamsCodec.getInt(json, key));
                    continue block40;
                }
                case "node2nodeid_cache_size": {
                    builder.node2NodeIdCacheSize(StoreParamsCodec.getInt(json, key));
                    continue block40;
                }
                case "nodeid2node_cache_size": {
                    builder.nodeId2NodeCacheSize(StoreParamsCodec.getInt(json, key));
                    continue block40;
                }
                case "node_miss_cache_size": {
                    builder.nodeMissCacheSize(StoreParamsCodec.getInt(json, key));
                    continue block40;
                }
                case "index_node2id": {
                    builder.indexNode2Id(StoreParamsCodec.getString(json, key));
                    continue block40;
                }
                case "index_id2node": {
                    builder.indexId2Node(StoreParamsCodec.getString(json, key));
                    continue block40;
                }
                case "triple_index_primary": {
                    builder.primaryIndexTriples(StoreParamsCodec.getString(json, key));
                    continue block40;
                }
                case "triple_indexes": {
                    builder.tripleIndexes(StoreParamsCodec.getStringArray(json, key));
                    continue block40;
                }
                case "quad_index_primary": {
                    builder.primaryIndexQuads(StoreParamsCodec.getString(json, key));
                    continue block40;
                }
                case "quad_indexes": {
                    builder.quadIndexes(StoreParamsCodec.getStringArray(json, key));
                    continue block40;
                }
                case "prefix_index_primary": {
                    builder.primaryIndexPrefix(StoreParamsCodec.getString(json, key));
                    continue block40;
                }
                case "prefix_indexes": {
                    builder.prefixIndexes(StoreParamsCodec.getStringArray(json, key));
                    continue block40;
                }
                case "file_prefix_index": {
                    builder.indexPrefix(StoreParamsCodec.getString(json, key));
                    continue block40;
                }
                case "file_prefix_nodeid": {
                    builder.prefixNode2Id(StoreParamsCodec.getString(json, key));
                    continue block40;
                }
                case "file_prefix_id2node": {
                    builder.prefixId2Node(StoreParamsCodec.getString(json, key));
                    continue block40;
                }
            }
            throw new TDBException("StoreParams key no recognized: " + key);
        }
        return builder.build();
    }

    private static String getString(JsonObject json, String key) {
        if (!json.hasKey(key)) {
            throw new TDBException("StoreParamsCodec.getString: no such key: " + key);
        }
        String x = json.get(key).getAsString().value();
        return x;
    }

    private static Integer getInt(JsonObject json, String key) {
        if (!json.hasKey(key)) {
            throw new TDBException("StoreParamsCodec.getInt: no such key: " + key);
        }
        Integer x = json.get(key).getAsNumber().value().intValue();
        return x;
    }

    private static String[] getStringArray(JsonObject json, String key) {
        if (!json.hasKey(key)) {
            throw new TDBException("StoreParamsCodec.getStringArray: no such key: " + key);
        }
        JsonArray a = json.get(key).getAsArray();
        String[] x = new String[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            x[i] = a.get(i).getAsString().value();
        }
        return x;
    }

    private static void encode(JsonBuilder builder, String name, Object value) {
        if (value instanceof Number) {
            long x = ((Number)value).longValue();
            builder.key(name).value(x);
            return;
        }
        if (value instanceof String) {
            builder.key(name).value(value.toString());
            return;
        }
        if (value instanceof String[]) {
            String[] x = (String[])value;
            builder.key(name);
            builder.startArray();
            for (String s : x) {
                builder.value(s);
            }
            builder.finishArray();
            return;
        }
        throw new TDBException("Class of value not recognized: " + Lib.classShortName(value.getClass()));
    }
}

