/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.sys;

import java.util.Properties;
import java.util.Set;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.tdb.TDB;

public class EnvTDB {
    static final String prefix = "tdb:";

    public static void processGlobalSystemProperties() {
        Context context = EnvTDB.processProperties(System.getProperties());
        TDB.getContext().putAll(context);
    }

    public static Context processProperties(Properties properties) {
        Context context = new Context();
        Set<Object> keys = properties.keySet();
        for (Object key : keys) {
            if (!(key instanceof String)) continue;
            String keyStr = (String)key;
            if (keyStr.startsWith(prefix)) {
                keyStr = "http://jena.hpl.hp.com/TDB#" + keyStr.substring(prefix.length());
            }
            if (!keyStr.startsWith("http://jena.hpl.hp.com/TDB#")) continue;
            Object value = properties.get(key);
            Symbol symbol = Symbol.create(keyStr);
            context.set(symbol, value);
        }
        return context;
    }
}

