/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.transaction;

import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphTrackActive;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.tdb.StoreConnection;
import org.apache.jena.tdb.TDB;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.store.GraphNonTxnTDB;
import org.apache.jena.tdb.store.GraphTxnTDB;
import org.apache.jena.tdb.transaction.DatasetGraphTxn;
import org.apache.jena.tdb.transaction.TDBTransactionException;
import org.apache.jena.tdb.transaction.Transaction;
import org.apache.jena.tdb.transaction.TransactionManager;

public class DatasetGraphTransaction
extends DatasetGraphTrackActive
implements Sync {
    private ThreadLocal<DatasetGraphTxn> dsgtxn = ThreadLocal.withInitial(() -> null);
    private ThreadLocal<Boolean> inTransaction = ThreadLocal.withInitial(() -> false);
    private final StoreConnection sConn;
    private boolean isClosed = false;

    public DatasetGraphTransaction(Location location) {
        this.sConn = StoreConnection.make(location);
    }

    public Location getLocation() {
        return this.sConn.getLocation();
    }

    public DatasetGraphTDB getDatasetGraphToQuery() {
        this.checkNotClosed();
        return this.get();
    }

    public DatasetGraphTDB getBaseDatasetGraph() {
        this.checkNotClosed();
        return this.sConn.getBaseDataset();
    }

    @Override
    public DatasetGraph getW() {
        DatasetGraphTxn dsgTxn;
        if (this.isInTransaction() && (dsgTxn = this.dsgtxn.get()).getTransaction().isRead()) {
            Transactional.Promote mode;
            TxnType txnType = dsgTxn.getTransaction().getTxnType();
            switch (txnType) {
                case READ: {
                    throw new JenaTransactionException("Attempt to update in a read transaction");
                }
                case WRITE: {
                    throw new TDBException("Internal inconsistency: read-mode write transaction");
                }
                case READ_PROMOTE: {
                    mode = Transactional.Promote.ISOLATED;
                    break;
                }
                case READ_COMMITTED_PROMOTE: {
                    mode = Transactional.Promote.READ_COMMITTED;
                    break;
                }
                default: {
                    throw new TDBException("Internal inconsistency: null transaction type");
                }
            }
            TransactionManager txnMgr = dsgTxn.getTransaction().getTxnMgr();
            DatasetGraphTxn dsgTxn2 = txnMgr.promote(dsgTxn, txnType, mode);
            if (dsgTxn2 == null) {
                throw new JenaTransactionException("Can't promote " + (Object)((Object)txnType) + "- dataset has been written to");
            }
            this.dsgtxn.set(dsgTxn2);
        }
        return super.getW();
    }

    @Override
    public DatasetGraphTDB get() {
        if (this.isInTransaction()) {
            DatasetGraphTxn dsgTxn = this.dsgtxn.get();
            if (dsgTxn == null) {
                throw new TDBTransactionException("In a transaction but no transactional DatasetGraph");
            }
            return dsgTxn.getView();
        }
        if (this.sConn.haveUsedInTransaction()) {
            throw new TDBTransactionException("Not in a transaction");
        }
        return this.sConn.getBaseDataset();
    }

    @Override
    protected void checkActive() {
        this.checkNotClosed();
        if (!this.isInTransaction()) {
            throw new JenaTransactionException("Not in a transaction (" + this.getLocation() + ")");
        }
    }

    @Override
    protected void checkNotActive() {
        this.checkNotClosed();
        if (this.sConn.haveUsedInTransaction() && this.isInTransaction()) {
            throw new JenaTransactionException("Currently in a transaction (" + this.getLocation() + ")");
        }
    }

    protected void checkNotClosed() {
        if (this.isClosed) {
            throw new JenaTransactionException("Already closed");
        }
    }

    @Override
    public boolean isInTransaction() {
        this.checkNotClosed();
        return this.inTransaction.get();
    }

    @Override
    public ReadWrite transactionMode() {
        this.checkNotClosed();
        if (!this.isInTransaction()) {
            return null;
        }
        return this.dsgtxn.get().getTransaction().getTxnMode();
    }

    @Override
    public TxnType transactionType() {
        this.checkNotClosed();
        if (!this.isInTransaction()) {
            return null;
        }
        return this.dsgtxn.get().getTransaction().getTxnType();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void syncIfNotTransactional() {
        if (!this.sConn.haveUsedInTransaction()) {
            this.sConn.getBaseDataset().sync();
        }
    }

    @Override
    public Graph getDefaultGraph() {
        if (this.sConn.haveUsedInTransaction()) {
            return new GraphTxnTDB(this, null);
        }
        return new GraphNonTxnTDB(this.getBaseDatasetGraph(), null);
    }

    @Override
    public Graph getUnionGraph() {
        return this.getGraph(Quad.unionGraph);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        if (this.sConn.haveUsedInTransaction()) {
            return new GraphTxnTDB(this, graphNode);
        }
        return new GraphNonTxnTDB(this.getBaseDatasetGraph(), graphNode);
    }

    @Override
    protected void _begin(TxnType txnType) {
        this.checkNotClosed();
        DatasetGraphTxn dsgTxn = this.sConn.begin(txnType);
        this.dsgtxn.set(dsgTxn);
        this.inTransaction.set(true);
    }

    @Override
    protected boolean _promote(Transactional.Promote promoteMode) {
        this.checkNotClosed();
        DatasetGraphTxn dsgTxn = this.dsgtxn.get();
        Transaction transaction = dsgTxn.getTransaction();
        DatasetGraphTxn dsgTxn2 = transaction.getTxnMgr().promote(dsgTxn, transaction.getTxnType(), promoteMode);
        if (dsgTxn2 == null) {
            return false;
        }
        this.dsgtxn.set(dsgTxn2);
        return true;
    }

    @Override
    protected void _commit() {
        this.checkNotClosed();
        this.dsgtxn.get().commit();
        this.inTransaction.set(false);
    }

    @Override
    protected void _abort() {
        this.checkNotClosed();
        this.dsgtxn.get().abort();
        this.inTransaction.set(false);
    }

    @Override
    protected void _end() {
        this.checkNotClosed();
        DatasetGraphTxn dsg = this.dsgtxn.get();
        if (dsg == null) {
            TDB.logInfo.warn("Transaction already ended");
            return;
        }
        try {
            this.dsgtxn.get().end();
        }
        finally {
            this.inTransaction.set(false);
            this.dsgtxn.set(null);
        }
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionAbort() {
        return true;
    }

    @Override
    public String toString() {
        try {
            if (this.isInTransaction()) {
                return this.get().toString();
            }
            return this.getBaseDatasetGraph().toString();
        }
        catch (Throwable th) {
            return "DatasetGraphTransaction";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _close() {
        if (this.isClosed) {
            return;
        }
        if (!this.sConn.haveUsedInTransaction()) {
            DatasetGraphTransaction datasetGraphTransaction = this;
            synchronized (datasetGraphTransaction) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
                if (!this.sConn.isValid()) {
                    return;
                }
                DatasetGraphTDB dsg = this.sConn.getBaseDataset();
                dsg.sync();
                dsg.close();
                StoreConnection.release(this.getLocation());
                return;
            }
        }
        if (this.isInTransaction()) {
            TDB.logInfo.warn("Attempt to close a DatasetGraphTransaction while a transaction is active - ignored close (" + this.getLocation() + ")");
            return;
        }
        this.dsgtxn.remove();
        this.inTransaction.remove();
        this.isClosed = true;
    }

    @Override
    public Context getContext() {
        return this.getBaseDatasetGraph().getContext();
    }

    public StoreConnection getStoreConnection() {
        return this.sConn;
    }

    @Override
    public void sync() {
        if (!this.sConn.haveUsedInTransaction() && this.get() != null) {
            this.get().sync();
        }
    }
}

