/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTools {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final SimpleDateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy");
    private static final SimpleDateFormat MONTH_FORMAT = new SimpleDateFormat("yyyyMM");
    private static final SimpleDateFormat DAY_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat HOUR_FORMAT = new SimpleDateFormat("yyyyMMddHH");
    private static final SimpleDateFormat MINUTE_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
    private static final SimpleDateFormat SECOND_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final SimpleDateFormat MILLISECOND_FORMAT = new SimpleDateFormat("yyyyMMddHHmmssSSS");

    private DateTools() {
    }

    public static String dateToString(Date date2, Resolution resolution) {
        return DateTools.timeToString(date2.getTime(), resolution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String timeToString(long time, Resolution resolution) {
        String result;
        Calendar cal = Calendar.getInstance(GMT);
        cal.setTime(new Date(DateTools.round(time, resolution)));
        if (resolution == Resolution.YEAR) {
            SimpleDateFormat simpleDateFormat = YEAR_FORMAT;
            synchronized (simpleDateFormat) {
                result = YEAR_FORMAT.format(cal.getTime());
            }
        } else if (resolution == Resolution.MONTH) {
            SimpleDateFormat simpleDateFormat = MONTH_FORMAT;
            synchronized (simpleDateFormat) {
                result = MONTH_FORMAT.format(cal.getTime());
            }
        } else if (resolution == Resolution.DAY) {
            SimpleDateFormat simpleDateFormat = DAY_FORMAT;
            synchronized (simpleDateFormat) {
                result = DAY_FORMAT.format(cal.getTime());
            }
        } else if (resolution == Resolution.HOUR) {
            SimpleDateFormat simpleDateFormat = HOUR_FORMAT;
            synchronized (simpleDateFormat) {
                result = HOUR_FORMAT.format(cal.getTime());
            }
        } else if (resolution == Resolution.MINUTE) {
            SimpleDateFormat simpleDateFormat = MINUTE_FORMAT;
            synchronized (simpleDateFormat) {
                result = MINUTE_FORMAT.format(cal.getTime());
            }
        } else if (resolution == Resolution.SECOND) {
            SimpleDateFormat simpleDateFormat = SECOND_FORMAT;
            synchronized (simpleDateFormat) {
                result = SECOND_FORMAT.format(cal.getTime());
            }
        } else if (resolution == Resolution.MILLISECOND) {
            SimpleDateFormat simpleDateFormat = MILLISECOND_FORMAT;
            synchronized (simpleDateFormat) {
                result = MILLISECOND_FORMAT.format(cal.getTime());
            }
        } else {
            throw new IllegalArgumentException("unknown resolution " + resolution);
        }
        return result;
    }

    public static long stringToTime(String dateString) throws ParseException {
        return DateTools.stringToDate(dateString).getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date stringToDate(String dateString) throws ParseException {
        Date date2;
        if (dateString.length() == 4) {
            SimpleDateFormat simpleDateFormat = YEAR_FORMAT;
            synchronized (simpleDateFormat) {
                date2 = YEAR_FORMAT.parse(dateString);
            }
        } else if (dateString.length() == 6) {
            SimpleDateFormat simpleDateFormat = MONTH_FORMAT;
            synchronized (simpleDateFormat) {
                date2 = MONTH_FORMAT.parse(dateString);
            }
        } else if (dateString.length() == 8) {
            SimpleDateFormat simpleDateFormat = DAY_FORMAT;
            synchronized (simpleDateFormat) {
                date2 = DAY_FORMAT.parse(dateString);
            }
        } else if (dateString.length() == 10) {
            SimpleDateFormat simpleDateFormat = HOUR_FORMAT;
            synchronized (simpleDateFormat) {
                date2 = HOUR_FORMAT.parse(dateString);
            }
        } else if (dateString.length() == 12) {
            SimpleDateFormat simpleDateFormat = MINUTE_FORMAT;
            synchronized (simpleDateFormat) {
                date2 = MINUTE_FORMAT.parse(dateString);
            }
        } else if (dateString.length() == 14) {
            SimpleDateFormat simpleDateFormat = SECOND_FORMAT;
            synchronized (simpleDateFormat) {
                date2 = SECOND_FORMAT.parse(dateString);
            }
        } else if (dateString.length() == 17) {
            SimpleDateFormat simpleDateFormat = MILLISECOND_FORMAT;
            synchronized (simpleDateFormat) {
                date2 = MILLISECOND_FORMAT.parse(dateString);
            }
        } else {
            throw new ParseException("Input is not valid date string: " + dateString, 0);
        }
        return date2;
    }

    public static Date round(Date date2, Resolution resolution) {
        return new Date(DateTools.round(date2.getTime(), resolution));
    }

    public static long round(long time, Resolution resolution) {
        Calendar cal = Calendar.getInstance(GMT);
        cal.setTime(new Date(time));
        if (resolution == Resolution.YEAR) {
            cal.set(2, 0);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        } else if (resolution == Resolution.MONTH) {
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        } else if (resolution == Resolution.DAY) {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        } else if (resolution == Resolution.HOUR) {
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        } else if (resolution == Resolution.MINUTE) {
            cal.set(13, 0);
            cal.set(14, 0);
        } else if (resolution == Resolution.SECOND) {
            cal.set(14, 0);
        } else if (resolution != Resolution.MILLISECOND) {
            throw new IllegalArgumentException("unknown resolution " + resolution);
        }
        return cal.getTime().getTime();
    }

    static {
        YEAR_FORMAT.setTimeZone(GMT);
        MONTH_FORMAT.setTimeZone(GMT);
        DAY_FORMAT.setTimeZone(GMT);
        HOUR_FORMAT.setTimeZone(GMT);
        MINUTE_FORMAT.setTimeZone(GMT);
        SECOND_FORMAT.setTimeZone(GMT);
        MILLISECOND_FORMAT.setTimeZone(GMT);
    }

    public static class Resolution {
        public static final Resolution YEAR = new Resolution("year");
        public static final Resolution MONTH = new Resolution("month");
        public static final Resolution DAY = new Resolution("day");
        public static final Resolution HOUR = new Resolution("hour");
        public static final Resolution MINUTE = new Resolution("minute");
        public static final Resolution SECOND = new Resolution("second");
        public static final Resolution MILLISECOND = new Resolution("millisecond");
        private String resolution;

        private Resolution() {
        }

        private Resolution(String resolution) {
            this.resolution = resolution;
        }

        public String toString() {
            return this.resolution;
        }
    }
}

