/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DisjunctionMaxScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;

public class DisjunctionMaxQuery
extends Query {
    private ArrayList disjuncts = new ArrayList();
    private float tieBreakerMultiplier = 0.0f;

    public DisjunctionMaxQuery(float tieBreakerMultiplier) {
        this.tieBreakerMultiplier = tieBreakerMultiplier;
    }

    public DisjunctionMaxQuery(Collection disjuncts, float tieBreakerMultiplier) {
        this.tieBreakerMultiplier = tieBreakerMultiplier;
        this.add(disjuncts);
    }

    public void add(Query query2) {
        this.disjuncts.add(query2);
    }

    public void add(Collection disjuncts) {
        this.disjuncts.addAll(disjuncts);
    }

    public Iterator iterator() {
        return this.disjuncts.iterator();
    }

    protected Weight createWeight(Searcher searcher) throws IOException {
        return new DisjunctionMaxWeight(searcher);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.disjuncts.size() == 1) {
            Query singleton = (Query)this.disjuncts.get(0);
            Query result = singleton.rewrite(reader);
            if (this.getBoost() != 1.0f) {
                if (result == singleton) {
                    result = (Query)result.clone();
                }
                result.setBoost(this.getBoost() * result.getBoost());
            }
            return result;
        }
        DisjunctionMaxQuery clone = null;
        for (int i = 0; i < this.disjuncts.size(); ++i) {
            Query clause = (Query)this.disjuncts.get(i);
            Query rewrite = clause.rewrite(reader);
            if (rewrite == clause) continue;
            if (clone == null) {
                clone = (DisjunctionMaxQuery)this.clone();
            }
            clone.disjuncts.set(i, rewrite);
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    public Object clone() {
        DisjunctionMaxQuery clone = (DisjunctionMaxQuery)super.clone();
        clone.disjuncts = (ArrayList)this.disjuncts.clone();
        return clone;
    }

    public void extractTerms(Set terms) {
        for (int i = 0; i < this.disjuncts.size(); ++i) {
            ((Query)this.disjuncts.get(i)).extractTerms(terms);
        }
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        for (int i = 0; i < this.disjuncts.size(); ++i) {
            Query subquery = (Query)this.disjuncts.get(i);
            if (subquery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subquery.toString(field));
                buffer.append(")");
            } else {
                buffer.append(subquery.toString(field));
            }
            if (i == this.disjuncts.size() - 1) continue;
            buffer.append(" | ");
        }
        buffer.append(")");
        if (this.tieBreakerMultiplier != 0.0f) {
            buffer.append("~");
            buffer.append(this.tieBreakerMultiplier);
        }
        if ((double)this.getBoost() != 1.0) {
            buffer.append("^");
            buffer.append(this.getBoost());
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DisjunctionMaxQuery)) {
            return false;
        }
        DisjunctionMaxQuery other = (DisjunctionMaxQuery)o;
        return this.getBoost() == other.getBoost() && this.tieBreakerMultiplier == other.tieBreakerMultiplier && this.disjuncts.equals(other.disjuncts);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) + Float.floatToIntBits(this.tieBreakerMultiplier) + this.disjuncts.hashCode();
    }

    private class DisjunctionMaxWeight
    implements Weight {
        private Searcher searcher;
        private ArrayList weights = new ArrayList();

        public DisjunctionMaxWeight(Searcher searcher) throws IOException {
            this.searcher = searcher;
            for (int i = 0; i < DisjunctionMaxQuery.this.disjuncts.size(); ++i) {
                this.weights.add(((Query)DisjunctionMaxQuery.this.disjuncts.get(i)).createWeight(searcher));
            }
        }

        public Query getQuery() {
            return DisjunctionMaxQuery.this;
        }

        public float getValue() {
            return DisjunctionMaxQuery.this.getBoost();
        }

        public float sumOfSquaredWeights() throws IOException {
            float max2 = 0.0f;
            float sum = 0.0f;
            for (int i = 0; i < this.weights.size(); ++i) {
                float sub = ((Weight)this.weights.get(i)).sumOfSquaredWeights();
                sum += sub;
                max2 = Math.max(max2, sub);
            }
            return ((sum - max2) * DisjunctionMaxQuery.this.tieBreakerMultiplier * DisjunctionMaxQuery.this.tieBreakerMultiplier + max2) * DisjunctionMaxQuery.this.getBoost() * DisjunctionMaxQuery.this.getBoost();
        }

        public void normalize(float norm) {
            norm *= DisjunctionMaxQuery.this.getBoost();
            for (int i = 0; i < this.weights.size(); ++i) {
                ((Weight)this.weights.get(i)).normalize(norm);
            }
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            DisjunctionMaxScorer result = new DisjunctionMaxScorer(DisjunctionMaxQuery.this.tieBreakerMultiplier, DisjunctionMaxQuery.this.getSimilarity(this.searcher));
            for (int i = 0; i < this.weights.size(); ++i) {
                Weight w = (Weight)this.weights.get(i);
                Scorer subScorer = w.scorer(reader);
                if (subScorer == null) {
                    return null;
                }
                result.add(subScorer);
            }
            return result;
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            if (DisjunctionMaxQuery.this.disjuncts.size() == 1) {
                return ((Weight)this.weights.get(0)).explain(reader, doc);
            }
            ComplexExplanation result = new ComplexExplanation();
            float max2 = 0.0f;
            float sum = 0.0f;
            result.setDescription(DisjunctionMaxQuery.this.tieBreakerMultiplier == 0.0f ? "max of:" : "max plus " + DisjunctionMaxQuery.this.tieBreakerMultiplier + " times others of:");
            for (int i = 0; i < this.weights.size(); ++i) {
                Explanation e2 = ((Weight)this.weights.get(i)).explain(reader, doc);
                if (!e2.isMatch()) continue;
                result.setMatch(Boolean.TRUE);
                result.addDetail(e2);
                sum += e2.getValue();
                max2 = Math.max(max2, e2.getValue());
            }
            result.setValue(max2 + (sum - max2) * DisjunctionMaxQuery.this.tieBreakerMultiplier);
            return result;
        }
    }
}

