/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.util.NamedList;

public class SpellCheckResponse {
    private boolean correctlySpelled;
    private List<Collation> collations;
    private List<Suggestion> suggestions = new ArrayList<Suggestion>();
    Map<String, Suggestion> suggestionMap = new LinkedHashMap<String, Suggestion>();

    public SpellCheckResponse(NamedList<Object> spellInfo) {
        NamedList coll;
        NamedList sugg = (NamedList)spellInfo.get("suggestions");
        if (sugg == null) {
            this.correctlySpelled = true;
            return;
        }
        for (int i = 0; i < sugg.size(); ++i) {
            String n = sugg.getName(i);
            Suggestion s = new Suggestion(n, (NamedList)sugg.getVal(i));
            this.suggestionMap.put(n, s);
            this.suggestions.add(s);
        }
        Boolean correctlySpelled = (Boolean)spellInfo.get("correctlySpelled");
        if (correctlySpelled != null) {
            this.correctlySpelled = correctlySpelled;
        }
        if ((coll = (NamedList)spellInfo.get("collations")) != null) {
            List collationInfo = coll.getAll("collation");
            this.collations = new ArrayList<Collation>(collationInfo.size());
            for (Object o : collationInfo) {
                if (o instanceof String) {
                    this.collations.add(new Collation().setCollationQueryString((String)o));
                    continue;
                }
                if (o instanceof NamedList) {
                    NamedList expandedCollation = (NamedList)o;
                    String collationQuery = (String)expandedCollation.get("collationQuery");
                    int hits = (Integer)expandedCollation.get("hits");
                    NamedList misspellingsAndCorrections = (NamedList)expandedCollation.get("misspellingsAndCorrections");
                    Collation collation2 = new Collation();
                    collation2.setCollationQueryString(collationQuery);
                    collation2.setNumberOfHits(hits);
                    for (int ii = 0; ii < misspellingsAndCorrections.size(); ++ii) {
                        String misspelling = misspellingsAndCorrections.getName(ii);
                        String correction = (String)misspellingsAndCorrections.getVal(ii);
                        collation2.addMisspellingsAndCorrection(new Correction(misspelling, correction));
                    }
                    this.collations.add(collation2);
                    continue;
                }
                throw new AssertionError((Object)"Should get Lists of Strings or List of NamedLists here.");
            }
        }
    }

    public boolean isCorrectlySpelled() {
        return this.correctlySpelled;
    }

    public List<Suggestion> getSuggestions() {
        return this.suggestions;
    }

    public Map<String, Suggestion> getSuggestionMap() {
        return this.suggestionMap;
    }

    public Suggestion getSuggestion(String token) {
        return this.suggestionMap.get(token);
    }

    public String getFirstSuggestion(String token) {
        Suggestion s = this.suggestionMap.get(token);
        if (s == null || s.getAlternatives().isEmpty()) {
            return null;
        }
        return s.getAlternatives().get(0);
    }

    public String getCollatedResult() {
        return this.collations == null || this.collations.size() == 0 ? null : this.collations.get(0).collationQueryString;
    }

    public List<Collation> getCollatedResults() {
        return this.collations;
    }

    public class Correction {
        private String original;
        private String correction;

        public Correction(String original, String correction) {
            this.original = original;
            this.correction = correction;
        }

        public String getOriginal() {
            return this.original;
        }

        public void setOriginal(String original) {
            this.original = original;
        }

        public String getCorrection() {
            return this.correction;
        }

        public void setCorrection(String correction) {
            this.correction = correction;
        }
    }

    public class Collation {
        private String collationQueryString;
        private List<Correction> misspellingsAndCorrections = new ArrayList<Correction>();
        private long numberOfHits;

        public long getNumberOfHits() {
            return this.numberOfHits;
        }

        public void setNumberOfHits(long numberOfHits) {
            this.numberOfHits = numberOfHits;
        }

        public String getCollationQueryString() {
            return this.collationQueryString;
        }

        public Collation setCollationQueryString(String collationQueryString) {
            this.collationQueryString = collationQueryString;
            return this;
        }

        public List<Correction> getMisspellingsAndCorrections() {
            return this.misspellingsAndCorrections;
        }

        public Collation addMisspellingsAndCorrection(Correction correction) {
            this.misspellingsAndCorrections.add(correction);
            return this;
        }
    }

    public static class Suggestion {
        private String token;
        private int numFound;
        private int startOffset;
        private int endOffset;
        private int originalFrequency;
        private List<String> alternatives = new ArrayList<String>();
        private List<Integer> alternativeFrequencies;

        public Suggestion(String token, NamedList<Object> suggestion) {
            this.token = token;
            for (int i = 0; i < suggestion.size(); ++i) {
                String n = suggestion.getName(i);
                if ("numFound".equals(n)) {
                    this.numFound = (Integer)suggestion.getVal(i);
                    continue;
                }
                if ("startOffset".equals(n)) {
                    this.startOffset = (Integer)suggestion.getVal(i);
                    continue;
                }
                if ("endOffset".equals(n)) {
                    this.endOffset = (Integer)suggestion.getVal(i);
                    continue;
                }
                if ("origFreq".equals(n)) {
                    this.originalFrequency = (Integer)suggestion.getVal(i);
                    continue;
                }
                if (!"suggestion".equals(n)) continue;
                List list = (List)suggestion.getVal(i);
                if (list.size() > 0 && list.get(0) instanceof NamedList) {
                    List extended = list;
                    this.alternativeFrequencies = new ArrayList<Integer>();
                    for (NamedList nl : extended) {
                        this.alternatives.add((String)nl.get("word"));
                        this.alternativeFrequencies.add((Integer)nl.get("freq"));
                    }
                    continue;
                }
                List alts = list;
                this.alternatives.addAll(alts);
            }
        }

        public String getToken() {
            return this.token;
        }

        public int getNumFound() {
            return this.numFound;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getOriginalFrequency() {
            return this.originalFrequency;
        }

        public List<String> getAlternatives() {
            return this.alternatives;
        }

        public List<Integer> getAlternativeFrequencies() {
            return this.alternativeFrequencies;
        }
    }
}

