/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtil {
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    private static final Collection<String> DEFAULT_HTTP_CLIENT_PATTERNS = Arrays.asList("EEE MMM d HH:mm:ss yyyy", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm:ss zzz");
    private static final Date DEFAULT_TWO_DIGIT_YEAR_START;
    private static final TimeZone GMT;
    public static final Collection<String> DEFAULT_DATE_FORMATS;
    public static TimeZone UTC;
    private static ThreadLocalDateFormat fmtThreadLocal;

    public static Date parseDate(String d) throws ParseException {
        return DateUtil.parseDate(d, DEFAULT_DATE_FORMATS);
    }

    public static Date parseDate(String d, Collection<String> fmts) throws ParseException {
        if (d.endsWith("Z") && d.length() > 20) {
            return DateUtil.getThreadLocalDateFormat().parse(d);
        }
        return DateUtil.parseDate(d, fmts, null);
    }

    public static Date parseDate(String dateValue, Collection<String> dateFormats, Date startDate) throws ParseException {
        if (dateValue == null) {
            throw new IllegalArgumentException("dateValue is null");
        }
        if (dateFormats == null) {
            dateFormats = DEFAULT_HTTP_CLIENT_PATTERNS;
        }
        if (startDate == null) {
            startDate = DEFAULT_TWO_DIGIT_YEAR_START;
        }
        if (dateValue.length() > 1 && dateValue.startsWith("'") && dateValue.endsWith("'")) {
            dateValue = dateValue.substring(1, dateValue.length() - 1);
        }
        SimpleDateFormat dateParser = null;
        for (String format : dateFormats) {
            if (dateParser == null) {
                dateParser = new SimpleDateFormat(format, Locale.ROOT);
                dateParser.setTimeZone(GMT);
                dateParser.set2DigitYearStart(startDate);
            } else {
                dateParser.applyPattern(format);
            }
            try {
                return dateParser.parse(dateValue);
            }
            catch (ParseException pe) {
            }
        }
        throw new ParseException("Unable to parse the date " + dateValue, 0);
    }

    public static DateFormat getThreadLocalDateFormat() {
        return (DateFormat)fmtThreadLocal.get();
    }

    public static Calendar formatDate(Date date2, Calendar cal, Appendable out) throws IOException {
        StringBuilder sb;
        StringBuilder stringBuilder = sb = out instanceof StringBuilder ? (StringBuilder)out : new StringBuilder();
        if (cal == null) {
            cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ROOT);
        }
        cal.setTime(date2);
        int i = cal.get(1);
        sb.append(i);
        sb.append('-');
        i = cal.get(2) + 1;
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i);
        sb.append('-');
        i = cal.get(5);
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i);
        sb.append('T');
        i = cal.get(11);
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i);
        sb.append(':');
        i = cal.get(12);
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i);
        sb.append(':');
        i = cal.get(13);
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i);
        i = cal.get(14);
        if (i != 0) {
            sb.append('.');
            if (i < 100) {
                sb.append('0');
            }
            if (i < 10) {
                sb.append('0');
            }
            sb.append(i);
            int lastIdx = sb.length() - 1;
            if (sb.charAt(lastIdx) == '0') {
                if (sb.charAt(--lastIdx) == '0') {
                    --lastIdx;
                }
                sb.setLength(lastIdx + 1);
            }
        }
        sb.append('Z');
        if (out != sb) {
            out.append(sb);
        }
        return cal;
    }

    static {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ROOT);
        calendar.set(2000, 0, 1, 0, 0);
        DEFAULT_TWO_DIGIT_YEAR_START = calendar.getTime();
        GMT = TimeZone.getTimeZone("GMT");
        DEFAULT_DATE_FORMATS = new ArrayList<String>();
        DEFAULT_DATE_FORMATS.add("yyyy-MM-dd'T'HH:mm:ss'Z'");
        DEFAULT_DATE_FORMATS.add("yyyy-MM-dd'T'HH:mm:ss");
        DEFAULT_DATE_FORMATS.add("yyyy-MM-dd");
        DEFAULT_DATE_FORMATS.add("yyyy-MM-dd hh:mm:ss");
        DEFAULT_DATE_FORMATS.add("yyyy-MM-dd HH:mm:ss");
        DEFAULT_DATE_FORMATS.add("EEE MMM d hh:mm:ss z yyyy");
        DEFAULT_DATE_FORMATS.addAll(DEFAULT_HTTP_CLIENT_PATTERNS);
        UTC = TimeZone.getTimeZone("UTC");
        fmtThreadLocal = new ThreadLocalDateFormat();
    }

    private static class ThreadLocalDateFormat
    extends ThreadLocal<DateFormat> {
        DateFormat proto;

        public ThreadLocalDateFormat() {
            SimpleDateFormat tmp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ROOT);
            tmp.setTimeZone(UTC);
            this.proto = tmp;
        }

        @Override
        protected DateFormat initialValue() {
            return (DateFormat)this.proto.clone();
        }
    }
}

