/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.Translet;
import org.apache.xalan.xsltc.dom.NodeCounter;
import org.apache.xml.dtm.DTMAxisIterator;

public abstract class AnyNodeCounter
extends NodeCounter {
    public AnyNodeCounter(Translet translet, DOM document, DTMAxisIterator iterator) {
        super(translet, document, iterator);
    }

    public NodeCounter setStartNode(int node) {
        this._node = node;
        this._nodeType = this._document.getExpandedTypeID(node);
        return this;
    }

    public String getCounter() {
        if (this._value != -2.147483648E9) {
            if (this._value == 0.0) {
                return "0";
            }
            if (Double.isNaN(this._value)) {
                return "NaN";
            }
            if (this._value < 0.0 && Double.isInfinite(this._value)) {
                return "-Infinity";
            }
            if (Double.isInfinite(this._value)) {
                return "Infinity";
            }
            return this.formatNumbers((int)this._value);
        }
        int next = this._node;
        int root2 = this._document.getDocument();
        int result = 0;
        while (next >= root2 && !this.matchesFrom(next)) {
            if (this.matchesCount(next)) {
                ++result;
            }
            --next;
        }
        return this.formatNumbers(result);
    }

    public static NodeCounter getDefaultNodeCounter(Translet translet, DOM document, DTMAxisIterator iterator) {
        return new DefaultAnyNodeCounter(translet, document, iterator);
    }

    static class DefaultAnyNodeCounter
    extends AnyNodeCounter {
        public DefaultAnyNodeCounter(Translet translet, DOM document, DTMAxisIterator iterator) {
            super(translet, document, iterator);
        }

        public String getCounter() {
            int result;
            if (this._value != -2.147483648E9) {
                if (this._value == 0.0) {
                    return "0";
                }
                if (Double.isNaN(this._value)) {
                    return "NaN";
                }
                if (this._value < 0.0 && Double.isInfinite(this._value)) {
                    return "-Infinity";
                }
                if (Double.isInfinite(this._value)) {
                    return "Infinity";
                }
                result = (int)this._value;
            } else {
                int next = this._node;
                result = 0;
                int ntype = this._document.getExpandedTypeID(this._node);
                int root2 = this._document.getDocument();
                while (next >= 0) {
                    if (ntype == this._document.getExpandedTypeID(next)) {
                        ++result;
                    }
                    if (next == root2) break;
                    --next;
                }
            }
            return this.formatNumbers(result);
        }
    }
}

