/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.tar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.codehaus.plexus.archiver.ArchiveFile;
import org.codehaus.plexus.archiver.tar.TarEntry;
import org.codehaus.plexus.archiver.tar.TarInputStream;

public class TarFile
implements ArchiveFile {
    private final File file;
    private TarInputStream inputStream;
    private TarEntry currentEntry;

    public TarFile(File file) {
        this.file = file;
    }

    public Enumeration getEntries() throws IOException {
        if (this.inputStream != null) {
            this.close();
        }
        this.open();
        return new Enumeration(){
            boolean currentEntryValid;

            public boolean hasMoreElements() {
                if (!this.currentEntryValid) {
                    try {
                        TarFile.this.currentEntry = TarFile.this.inputStream.getNextEntry();
                    }
                    catch (IOException e2) {
                        throw new UndeclaredThrowableException(e2);
                    }
                }
                return TarFile.this.currentEntry != null;
            }

            public Object nextElement() {
                if (TarFile.this.currentEntry == null) {
                    throw new NoSuchElementException();
                }
                this.currentEntryValid = false;
                return TarFile.this.currentEntry;
            }
        };
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
    }

    public InputStream getInputStream(ArchiveFile.Entry entry) throws IOException {
        return this.getInputStream((TarEntry)entry);
    }

    public InputStream getInputStream(TarEntry entry) throws IOException {
        if (entry.equals((Object)this.currentEntry) && this.inputStream != null) {
            return new FilterInputStream(this.inputStream){

                public void close() throws IOException {
                }
            };
        }
        return this.getInputStream(entry, this.currentEntry);
    }

    protected InputStream getInputStream(File file) throws IOException {
        return new FileInputStream(file);
    }

    private InputStream getInputStream(TarEntry entry, TarEntry currentEntry) throws IOException {
        if (currentEntry == null || this.inputStream == null) {
            if (this.inputStream != null) {
                this.close();
            }
            this.open();
            if (!this.findEntry(entry, null)) {
                throw new IOException("Unknown entry: " + entry.getName());
            }
        } else {
            if (this.findEntry(entry, null)) {
                return this.getInputStream(entry);
            }
            this.close();
            this.open();
            if (!this.findEntry(entry, currentEntry)) {
                throw new IOException("No such entry: " + entry.getName());
            }
        }
        return this.getInputStream(entry);
    }

    private void open() throws IOException {
        this.inputStream = new TarInputStream(this.getInputStream(this.file));
    }

    private boolean findEntry(TarEntry entry, TarEntry currentEntry) throws IOException {
        do {
            this.currentEntry = this.inputStream.getNextEntry();
            if (this.currentEntry != null && (currentEntry == null || !this.currentEntry.equals(currentEntry))) continue;
            return false;
        } while (!this.currentEntry.equals(entry));
        return true;
    }
}

