/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index.processor;

import java.util.HashMap;
import java.util.Map;

public class QueuePrioritizer {
    private Map<String, Integer> subCounts = new HashMap<String, Integer>();
    public int windowSize = 100;
    private int priorities = 2;
    private int headIndex = 0;
    private int grandTotal = 0;
    private String[] latest;

    public QueuePrioritizer(int lookback, int priorities) {
        this.windowSize = lookback;
        this.priorities = priorities;
        this.latest = new String[this.windowSize];
    }

    public float pushNext(String group) {
        ++this.grandTotal;
        if (this.subCounts.containsKey(group)) {
            this.subCounts.put(group, this.subCounts.get(group) + 1);
        } else {
            this.subCounts.put(group, 1);
        }
        String bumped = this.addToList(group);
        if (bumped != null) {
            this.subCounts.put(bumped, this.subCounts.get(bumped) - 1);
            --this.grandTotal;
        }
        if (this.grandTotal * 2 < this.windowSize) {
            return this.priorities;
        }
        int subCount = this.subCounts.get(group);
        return (float)((this.grandTotal - subCount) * this.priorities) / (float)this.grandTotal + 1.0f;
    }

    private String addToList(String group) {
        String bumped = null;
        if (this.latest[this.headIndex] != null) {
            bumped = this.latest[this.headIndex];
        }
        this.latest[this.headIndex++] = group;
        if (this.headIndex >= this.windowSize) {
            this.headIndex = 0;
        }
        return bumped;
    }
}

