/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dataone.cn.index.util.PerformanceLogger;
import org.dataone.cn.indexer.D1IndexerSolrClient;
import org.dataone.cn.indexer.parser.IDocumentSubprocessorV2;
import org.dataone.cn.indexer.parser.UpdateAssembler;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractStubMergingSubprocessor
implements IDocumentSubprocessorV2 {
    private PerformanceLogger perfLog = PerformanceLogger.getInstance();
    private static Logger log = Logger.getLogger(AbstractStubMergingSubprocessor.class);
    @Autowired
    @Qualifier(value="solrQueryUri")
    protected String solrQueryUri;
    @Autowired
    protected D1IndexerSolrClient d1IndexerSolrClient;

    protected abstract Map<String, SolrDoc> parseDocument(String var1, InputStream var2) throws Exception;

    @Override
    public void processDocument(String identifier, UpdateAssembler collector, InputStream is) throws Exception {
        long processStart = System.currentTimeMillis();
        Map<String, SolrDoc> docMap = this.parseDocument(identifier, is);
        log.info("number of documents from parseDocuments: " + docMap.size());
        this.perfLog.log("AbstractMultiDocSubProcessor.parseDocument() for id " + identifier, System.currentTimeMillis() - processStart);
        SolrDoc mainDoc = docMap.get(identifier);
        log.info(" main document from parseDocuments: " + mainDoc);
        if (mainDoc != null) {
            List<SolrDoc> existingSidStubs;
            log.info(" main document id from parseDocuments: " + mainDoc.getIdentifier());
            collector.addToUpdate(identifier, null, mainDoc);
            String seriesId = mainDoc.getSeriesId();
            if (seriesId != null && (existingSidStubs = this.d1IndexerSolrClient.getDocumentBySolrId(this.solrQueryUri, seriesId)) != null && !existingSidStubs.isEmpty()) {
                SolrDoc newRelationships = existingSidStubs.get(0);
                SolrElementField idField = newRelationships.getField("id");
                String mainIdentifier = mainDoc.getIdentifier();
                idField.setValue(mainIdentifier);
                collector.addToUpdate(mainIdentifier, null, newRelationships);
            }
        }
        docMap.remove(identifier);
        if (!docMap.isEmpty()) {
            for (Map.Entry<String, SolrDoc> n : docMap.entrySet()) {
                String id = n.getKey();
                SolrDoc parsedStub = n.getValue();
                log.info(" other document to process: " + id);
                List<SolrDoc> otherExisting = this.d1IndexerSolrClient.getDocumentBySolrId(this.solrQueryUri, id);
                if (otherExisting != null && !otherExisting.isEmpty()) {
                    log.info("found existing record for the stub, id = " + id);
                    log.info("    .... version is: " + otherExisting.get(0).getFirstFieldValue("_version_"));
                    collector.addToUpdate(id, otherExisting.get(0), parsedStub);
                    continue;
                }
                collector.addToUpdate(id, null, parsedStub);
                List<SolrDoc> associatedExistingDocs = this.d1IndexerSolrClient.getDocumentsByField(this.solrQueryUri, Collections.singletonList(id), "seriesId", true);
                if (associatedExistingDocs == null) continue;
                for (SolrDoc assocExisting : associatedExistingDocs) {
                    String associatedPid = assocExisting.getIdentifier();
                    log.info("found existing records for the stub by seriesId.  existing pid = " + associatedPid);
                    SolrDoc stubToAdd = parsedStub.clone();
                    stubToAdd.getField("id").setValue(associatedPid);
                    collector.addToUpdate(associatedPid, assocExisting, stubToAdd);
                }
            }
        }
        this.perfLog.log("AbstractMultiDocSubProcessor.processDocument() for id " + identifier, System.currentTimeMillis() - processStart);
    }
}

