/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.log4j.Logger;
import org.apache.solr.common.util.IOUtils;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.index.task.IndexTask;
import org.dataone.cn.index.util.PerformanceLogger;
import org.dataone.cn.indexer.D1IndexerSolrClient;
import org.dataone.cn.indexer.parser.IDocumentDeleteSubprocessor;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.parser.SubprocessorUtility;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.SAXException;

public class SolrIndexService {
    private static Logger log = Logger.getLogger(SolrIndexService.class);
    private static final String OUTPUT_ENCODING = "UTF-8";
    private List<IDocumentSubprocessor> subprocessors = null;
    private List<IDocumentDeleteSubprocessor> deleteSubprocessors = null;
    private IDocumentSubprocessor systemMetadataProcessor = null;
    @Autowired
    private D1IndexerSolrClient d1IndexerSolrClient = null;
    @Autowired
    private String solrIndexUri = null;
    @Autowired
    private String solrQueryUri = null;
    @Autowired
    private SubprocessorUtility subprocessorUtility;
    private boolean usePartialUpdate = Settings.getConfiguration().getBoolean("dataone.indexing.usePartialUpdate", false);
    private PerformanceLogger perfLog = PerformanceLogger.getInstance();

    public void removeFromIndex(String identifier) throws Exception {
        HashMap<String, SolrDoc> docs = new HashMap<String, SolrDoc>();
        for (IDocumentDeleteSubprocessor deleteSubprocessor : this.getDeleteSubprocessors()) {
            if (log.isDebugEnabled()) {
                log.debug("... invoking processDocForDelete for identifier " + identifier + "[" + deleteSubprocessor.getClass().getSimpleName() + "/" + deleteSubprocessor.getInstanceLabel() + "]");
            }
            docs.putAll(deleteSubprocessor.processDocForDelete(identifier, docs));
        }
        ArrayList<SolrDoc> docsToUpdate = new ArrayList<SolrDoc>();
        ArrayList<String> idsToIndex = new ArrayList<String>();
        for (String idToUpdate : docs.keySet()) {
            if (docs.get(idToUpdate) != null) {
                docsToUpdate.add((SolrDoc)docs.get(idToUpdate));
                log.debug("...updating doc with id " + idToUpdate);
                continue;
            }
            idsToIndex.add(idToUpdate);
        }
        this.sendCommand(docsToUpdate);
        this.deleteDocFromIndex(identifier);
        for (String idToIndex : idsToIndex) {
            Identifier pid = new Identifier();
            pid.setValue(idToIndex);
            SystemMetadata sysMeta = HazelcastClientFactory.getSystemMetadataMap().get(pid);
            if (!SolrDoc.visibleInIndex(sysMeta)) continue;
            String objectPath = HazelcastClientFactory.getObjectPathMap().get(pid);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            TypeMarshaller.marshalTypeToOutputStream(sysMeta, os);
            this.insertIntoIndex(idToIndex, new ByteArrayInputStream(os.toByteArray()), objectPath);
            log.debug("...reindexing doc with id " + idToIndex);
        }
    }

    public void removeFromIndex(List<IndexTask> tasks) throws Exception {
        for (IndexTask indexTask : tasks) {
            String identifier = indexTask.getPid();
            try {
                this.removeFromIndex(identifier);
            }
            catch (Exception e2) {
                log.error("Unable to remove from index: " + identifier, e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SolrDoc> parseTaskObject(String id, InputStream systemMetaDataStream, String objectPath) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException, EncoderException {
        Map<String, SolrDoc> accumulatedParsedFieldValues;
        block14: {
            block12: {
                accumulatedParsedFieldValues = new HashMap<String, SolrDoc>();
                try {
                    long sysmetaProcStart = System.currentTimeMillis();
                    Date d = new Date();
                    accumulatedParsedFieldValues = this.systemMetadataProcessor.processDocument(id, accumulatedParsedFieldValues, systemMetaDataStream);
                    if (log.isDebugEnabled()) {
                        log.debug("...subprocessor SystemMetadataProcessor invoked for " + id);
                    }
                    this.perfLog.log(this.systemMetadataProcessor.getClass().getSimpleName() + ".processDocument() processing sysmeta for id " + id, System.currentTimeMillis() - sysmetaProcStart);
                }
                catch (Exception e2) {
                    log.error("Error parsing system metadata for id: " + id + e2.getMessage(), e2);
                }
                if (objectPath == null) break block12;
                SolrDoc sDoc = accumulatedParsedFieldValues.get(id);
                String formatId = sDoc.getFirstFieldValue("formatId");
                int i = 1;
                for (IDocumentSubprocessor subprocessor : this.getSubprocessors()) {
                    if (subprocessor.canProcess(formatId)) {
                        FileInputStream objectStream;
                        block11: {
                            objectStream = null;
                            try {
                                if (log.isDebugEnabled()) {
                                    log.debug("...subprocessor " + subprocessor.getClass().getSimpleName() + ".processDocument(...) invoked for " + id);
                                }
                                long startFechingFile = System.currentTimeMillis();
                                objectStream = new FileInputStream(objectPath);
                                this.perfLog.log("Loop " + i + ". SolrIndexService.processObject() fetch file for id " + id, System.currentTimeMillis() - startFechingFile);
                                if (!objectStream.getFD().valid()) {
                                    log.error("Could not load OBJECT file for ID,Path=" + id + ", " + objectPath);
                                    break block11;
                                }
                                Date dd = new Date();
                                long scimetaProcStart = System.currentTimeMillis();
                                accumulatedParsedFieldValues = subprocessor.processDocument(id, accumulatedParsedFieldValues, objectStream);
                                this.perfLog.log(String.format("Loop %d. SolrIndexService.processObject() %s.processDocument() total subprocessor processing time for id %s with format: %s", i, subprocessor.getClass().getSimpleName(), id, formatId), System.currentTimeMillis() - scimetaProcStart);
                            }
                            catch (Exception e3) {
                                try {
                                    log.warn(String.format("The subprocessor %s can't process the id %s since %s. However, the index still can be achieved without this part of information provided by the processor.", subprocessor.getClass().getName(), id, e3.getMessage()), e3);
                                }
                                catch (Throwable throwable) {
                                    IOUtils.closeQuietly(objectStream);
                                    throw throwable;
                                }
                                IOUtils.closeQuietly(objectStream);
                            }
                        }
                        IOUtils.closeQuietly(objectStream);
                    }
                    ++i;
                }
                break block14;
            }
            log.warn("The optional objectPath for pid " + id + " is null, so skipping processing with content subprocessors");
        }
        return accumulatedParsedFieldValues;
    }

    public List<SolrDoc> processObject(String id, InputStream systemMetaDataStream, String objectPath) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException, EncoderException {
        long processObjStart = System.currentTimeMillis();
        Map<String, SolrDoc> docs = this.parseTaskObject(id, systemMetaDataStream, objectPath);
        log.debug(docs.size() + " SolrDocs parsed for id '" + id + "'");
        long mergeProcStart = System.currentTimeMillis();
        HashMap<String, SolrDoc> mergedDocs = new HashMap<String, SolrDoc>();
        int index = 1;
        for (SolrDoc mergeDoc : docs.values()) {
            int innerIndex = 1;
            if (this.usePartialUpdate) {
                log.debug("...SubprocessorUtility.diffWithIndexedDocument(...) to be invoked for " + mergeDoc.getIdentifier());
                long before = System.currentTimeMillis();
                mergeDoc = this.subprocessorUtility.diffWithIndexedDocument(mergeDoc);
                this.perfLog.log("Outer loop " + index + ", inner loop" + innerIndex + " SolrIndexService.processObject() merging (by diff) docs for id " + id, System.currentTimeMillis() - before);
                mergedDocs.put(mergeDoc.getIdentifier(), mergeDoc);
                continue;
            }
            for (IDocumentSubprocessor subprocessor : this.getSubprocessors()) {
                log.debug("...subprocessor " + subprocessor.getClass().getSimpleName() + ".mergeWithIndexedDocument(...) invoked for " + mergeDoc.getIdentifier());
                long before = System.currentTimeMillis();
                mergeDoc = subprocessor.mergeWithIndexedDocument(mergeDoc);
                this.perfLog.log("Outer loop " + index + ", inner loop" + innerIndex + " SolrIndexService.processObject() merging docs for id " + id, System.currentTimeMillis() - before);
                ++innerIndex;
            }
            mergedDocs.put(mergeDoc.getIdentifier(), mergeDoc);
            ++index;
        }
        this.perfLog.log("Total - SolrIndexService.processObject() merging docs for id " + id, System.currentTimeMillis() - mergeProcStart);
        this.perfLog.log("SolrIndexService.processObject() total processing time for id " + id, System.currentTimeMillis() - processObjStart);
        return new ArrayList<SolrDoc>(mergedDocs.values());
    }

    public void insertIntoIndex(String id, InputStream systemMetaDataStream, String objectPath) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException, EncoderException, Exception {
        List<SolrDoc> addCommands = this.processObject(id, systemMetaDataStream, objectPath);
        long solrAddStart = System.currentTimeMillis();
        this.sendCommand(addCommands);
        this.perfLog.log("SolrIndexService.sendCommand(SolrElementAdd) adding docs into Solr index for id " + id, System.currentTimeMillis() - solrAddStart);
    }

    public void insertIntoIndex(List<IndexTask> tasks) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException, EncoderException, Exception {
        List<SolrDoc> batchAddCommands = new ArrayList<SolrDoc>();
        for (IndexTask task : tasks) {
            ByteArrayInputStream smdStream = new ByteArrayInputStream(task.getSysMetadata().getBytes());
            List<SolrDoc> addCommand = this.processObject(task.getPid(), smdStream, task.getObjectPath());
            batchAddCommands = this.mergeAddCommands(batchAddCommands, addCommand);
        }
        long solrAddStart = System.currentTimeMillis();
        this.sendCommand(batchAddCommands);
        this.perfLog.log("SolrIndexService.sendCommand(SolrElementAdd) batch adding (" + tasks.size() + ") docs into Solr index", System.currentTimeMillis() - solrAddStart);
    }

    private List<SolrDoc> mergeAddCommands(List<SolrDoc> original, List<SolrDoc> addition) {
        if (original == null) {
            original = new ArrayList<SolrDoc>();
        }
        if (addition == null) {
            addition = new ArrayList<SolrDoc>();
        }
        original.addAll(addition);
        return original;
    }

    private void sendCommand(List<SolrDoc> addCommands) throws IOException {
        D1IndexerSolrClient client = this.getD1IndexerSolrClient();
        log.info("sendCommand using partial update: " + this.usePartialUpdate);
        client.sendUpdate(this.getSolrindexUri(), addCommands, OUTPUT_ENCODING, this.usePartialUpdate);
    }

    private void deleteDocFromIndex(String identifier) {
        this.d1IndexerSolrClient.sendSolrDelete(identifier);
    }

    public String getSolrindexUri() {
        return this.solrIndexUri;
    }

    public void setSolrIndexUri(String solrindexUri) {
        this.solrIndexUri = solrindexUri;
    }

    public void setD1IndexerSolrClient(D1IndexerSolrClient service) {
        this.d1IndexerSolrClient = service;
    }

    public D1IndexerSolrClient getD1IndexerSolrClient() {
        return this.d1IndexerSolrClient;
    }

    public String getSolrQueryUri() {
        return this.solrQueryUri;
    }

    public void setSolrQueryUri(String solrQueryUri) {
        this.solrQueryUri = solrQueryUri;
    }

    public List<IDocumentSubprocessor> getSubprocessors() {
        if (this.subprocessors == null) {
            this.subprocessors = new ArrayList<IDocumentSubprocessor>();
        }
        return this.subprocessors;
    }

    public List<IDocumentDeleteSubprocessor> getDeleteSubprocessors() {
        if (this.deleteSubprocessors == null) {
            this.deleteSubprocessors = new ArrayList<IDocumentDeleteSubprocessor>();
        }
        return this.deleteSubprocessors;
    }

    public void setSubprocessors(List<IDocumentSubprocessor> subprocessorList) {
        this.subprocessors = subprocessorList;
    }

    public void setDeleteSubprocessors(List<IDocumentDeleteSubprocessor> deleteSubprocessorList) {
        this.deleteSubprocessors = deleteSubprocessorList;
    }

    public IDocumentSubprocessor getSystemMetadataProcessor() {
        return this.systemMetadataProcessor;
    }

    public void setSystemMetadataProcessor(IDocumentSubprocessor systemMetadataProcessor) {
        this.systemMetadataProcessor = systemMetadataProcessor;
    }

    public void setUsePartialUpdate(boolean value) {
        this.usePartialUpdate = value;
    }

    public boolean getUsePartialUpdate() {
        return this.usePartialUpdate;
    }
}

