/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dataone.cn.indexer.parser.ISolrField;
import org.dataone.cn.indexer.parser.SolrField;
import org.dataone.cn.indexer.parser.utility.SpatialBoxParsingUtility;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.w3c.dom.Document;

public class DublinCoreSpatialBoxGeohashSolrField
extends SolrField
implements ISolrField {
    private static Logger logger = Logger.getLogger(DublinCoreSpatialBoxGeohashSolrField.class.getName());
    private static SpatialBoxParsingUtility boxParsingUtility = new SpatialBoxParsingUtility();

    public DublinCoreSpatialBoxGeohashSolrField() {
    }

    public DublinCoreSpatialBoxGeohashSolrField(String xpath) {
        this.xpath = xpath;
    }

    @Override
    public List<SolrElementField> getFields(Document doc, String identifier) throws Exception {
        return this.parseBox(doc);
    }

    private List<SolrElementField> parseBox(Document doc) {
        ArrayList<SolrElementField> fields = new ArrayList<SolrElementField>();
        String nodeValue = boxParsingUtility.extractNodeValue(doc, this.xPathExpression);
        String northValue = boxParsingUtility.extractDublinCoreDirectionalValue(nodeValue, "northlimit");
        String southValue = boxParsingUtility.extractDublinCoreDirectionalValue(nodeValue, "southlimit");
        String eastValue = boxParsingUtility.extractDublinCoreDirectionalValue(nodeValue, "eastlimit");
        String westValue = boxParsingUtility.extractDublinCoreDirectionalValue(nodeValue, "westlimit");
        String latLongValue = northValue + " " + southValue + " " + eastValue + " " + westValue;
        if (latLongValue != null && StringUtils.isNotEmpty(latLongValue)) {
            latLongValue = latLongValue.trim();
            boxParsingUtility.addGeohashLevelField(1, "geohash_1", latLongValue, fields);
            boxParsingUtility.addGeohashLevelField(2, "geohash_2", latLongValue, fields);
            boxParsingUtility.addGeohashLevelField(3, "geohash_3", latLongValue, fields);
            boxParsingUtility.addGeohashLevelField(4, "geohash_4", latLongValue, fields);
            boxParsingUtility.addGeohashLevelField(5, "geohash_5", latLongValue, fields);
            boxParsingUtility.addGeohashLevelField(6, "geohash_6", latLongValue, fields);
            boxParsingUtility.addGeohashLevelField(7, "geohash_7", latLongValue, fields);
            boxParsingUtility.addGeohashLevelField(8, "geohash_8", latLongValue, fields);
            boxParsingUtility.addGeohashLevelField(9, "geohash_9", latLongValue, fields);
        }
        return fields;
    }
}

