/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.ldap;

import java.io.IOException;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamingListener;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.dataone.cn.ldap.DirContextUnsolicitedNotificationListener;
import org.dataone.configuration.Settings;

public class DirContextPooledObjectFactory
extends BasePooledObjectFactory<DirContext> {
    public static Log log = LogFactory.getLog(DirContextPooledObjectFactory.class);
    protected String server = Settings.getConfiguration().getString("cn.ldap.server");
    protected String admin = Settings.getConfiguration().getString("cn.ldap.admin");
    protected String password = Settings.getConfiguration().getString("cn.ldap.password");
    protected boolean useTLS = Boolean.parseBoolean(Settings.getConfiguration().getString("cn.ldap.useTLS"));
    private static ConcurrentHashMap<DirContext, DirContextStash> tlsHashMap = new ConcurrentHashMap();

    @Override
    public DirContext create() throws Exception {
        DirContext context = null;
        log.debug("creating new context");
        if (this.useTLS) {
            try {
                context = this.getSecureContext();
            }
            catch (Throwable e2) {
                log.error("Could not set up TLS connection, using non-secure communication", e2);
                context = this.getDefaultContext();
            }
        } else {
            context = this.getDefaultContext();
        }
        DirContextUnsolicitedNotificationListener d1Listener = new DirContextUnsolicitedNotificationListener(context);
        EventDirContext eventDirContext = (EventDirContext)context.lookup("");
        eventDirContext.addNamingListener("", 1, (NamingListener)d1Listener);
        if (tlsHashMap.containsKey(context)) {
            DirContextPooledObjectFactory.tlsHashMap.get((Object)context).eventDirContext = eventDirContext;
            DirContextPooledObjectFactory.tlsHashMap.get((Object)context).d1Listener = d1Listener;
        }
        return context;
    }

    private DirContext getDefaultContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.server);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.admin);
        env.put("java.naming.security.credentials", this.password);
        env.put("com.sun.jndi.ldap.read.timeout", "1000");
        env.put("com.sun.jndi.ldap.connect.timeout", "1000");
        env.put("com.sun.jndi.ldap.connect.pool", "false");
        InitialDirContext ctx = new InitialDirContext(env);
        return ctx;
    }

    private DirContext getSecureContext() throws NamingException, IOException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.server);
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        StartTlsResponse tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
        if (this.server.contains("localhost")) {
            tls.setHostnameVerifier(new AllowAllHostnameVerifier());
        }
        SSLSession sess = tls.negotiate();
        ctx.addToEnvironment("java.naming.security.authentication", "simple");
        ctx.addToEnvironment("java.naming.security.principal", this.admin);
        ctx.addToEnvironment("java.naming.security.credentials", this.password);
        DirContextStash dirContextStash = new DirContextStash(tls);
        tlsHashMap.put(ctx, dirContextStash);
        return ctx;
    }

    @Override
    public PooledObject<DirContext> wrap(DirContext dirContext) {
        return new DefaultPooledObject<DirContext>(dirContext);
    }

    @Override
    public boolean validateObject(PooledObject<DirContext> p) {
        DirContext dirContext = p.getObject();
        try {
            Attributes attributes = dirContext.getAttributes("dc=org");
            NamingEnumeration<? extends Attribute> all = attributes.getAll();
            all.close();
        }
        catch (NamingException ex) {
            log.error(ex, ex);
            return false;
        }
        return super.validateObject(p);
    }

    /*
     * Loose catch block
     */
    @Override
    public void destroyObject(PooledObject<DirContext> p) throws Exception {
        block14: {
            log.debug("Destroying context");
            DirContext dirContext = p.getObject();
            dirContext.close();
            if (!tlsHashMap.containsKey(dirContext)) break block14;
            DirContextStash dirContextStash = tlsHashMap.remove(dirContext);
            dirContextStash.eventDirContext.removeNamingListener(dirContextStash.d1Listener);
            try {
                dirContextStash.startTlsResponse.close();
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), ex);
            }
            break block14;
            catch (NamingException ex) {
                if (!(ex instanceof CommunicationException)) {
                    log.error(ex.getMessage(), ex);
                    throw ex;
                }
                log.warn(ex.getMessage());
                if (!tlsHashMap.containsKey(dirContext)) break block14;
                dirContextStash = tlsHashMap.remove(dirContext);
                dirContextStash.eventDirContext.removeNamingListener(dirContextStash.d1Listener);
                try {
                    dirContextStash.startTlsResponse.close();
                }
                catch (Exception ex2) {
                    log.error(ex2.getMessage(), ex2);
                }
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), e2);
                throw e2;
                {
                    catch (Throwable throwable) {
                        if (tlsHashMap.containsKey(dirContext)) {
                            DirContextStash dirContextStash2 = tlsHashMap.remove(dirContext);
                            dirContextStash2.eventDirContext.removeNamingListener(dirContextStash2.d1Listener);
                            try {
                                dirContextStash2.startTlsResponse.close();
                            }
                            catch (Exception ex2) {
                                log.error(ex2.getMessage(), ex2);
                            }
                        }
                        throw throwable;
                    }
                }
            }
        }
        super.destroyObject(p);
    }

    private class DirContextStash {
        public StartTlsResponse startTlsResponse;
        public DirContextUnsolicitedNotificationListener d1Listener;
        EventDirContext eventDirContext;

        public DirContextStash(StartTlsResponse startTlsResponse) {
            this.startTlsResponse = startTlsResponse;
        }
    }
}

