/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.foresite;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dspace.foresite.OREParserException;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateParser {
    public static final String timestamp = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String incompleteTimestamp = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public static Date parse(String str2) throws OREParserException {
        return DateParser.parse(str2, 0);
    }

    private static Date parse(String str2, int type) throws OREParserException {
        try {
            switch (type) {
                case 0: {
                    SimpleDateFormat sdf = new SimpleDateFormat(timestamp);
                    return sdf.parse(str2);
                }
                case 1: {
                    SimpleDateFormat sdf = new SimpleDateFormat(incompleteTimestamp);
                    return sdf.parse(str2);
                }
                case 2: {
                    DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime();
                    return dateTimeFormatter.parseDateTime(str2).toDate();
                }
                case 3: {
                    DateTimeFormatter dateTimeFormatterNoMillis = ISODateTimeFormat.dateTimeNoMillis();
                    return dateTimeFormatterNoMillis.parseDateTime(str2).toDate();
                }
            }
            throw new OREParserException("Unable to parse date: " + str2);
        }
        catch (ParseException e2) {
            return DateParser.parse(str2, ++type);
        }
        catch (IllegalArgumentException e3) {
            return DateParser.parse(str2, ++type);
        }
        catch (NullPointerException e4) {
            return DateParser.parse(str2, ++type);
        }
    }
}

