/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.foresite.atom;

import com.sun.syndication.feed.atom.Category;
import com.sun.syndication.feed.atom.Content;
import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.feed.atom.Generator;
import com.sun.syndication.feed.atom.Link;
import com.sun.syndication.feed.atom.Person;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.dspace.foresite.Agent;
import org.dspace.foresite.AggregatedResource;
import org.dspace.foresite.Aggregation;
import org.dspace.foresite.OREException;
import org.dspace.foresite.OREFactory;
import org.dspace.foresite.OREParser;
import org.dspace.foresite.OREParserException;
import org.dspace.foresite.OREVocabulary;
import org.dspace.foresite.Proxy;
import org.dspace.foresite.ReMSerialisation;
import org.dspace.foresite.ResourceMap;
import org.dspace.foresite.Vocab;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomOREParser
implements OREParser {
    public static Namespace rdfNS = Namespace.getNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");

    @Override
    public ResourceMap parse(InputStream is, URI uri) throws OREParserException {
        return null;
    }

    @Override
    public ResourceMap parse(InputStream is) throws OREParserException {
        try {
            XmlReader reader = new XmlReader(is);
            WireFeedInput input = new WireFeedInput();
            Feed atom = (Feed)input.build(reader);
            URI uri_a = new URI(atom.getId());
            List links = atom.getOtherLinks();
            List altLinks = atom.getAlternateLinks();
            links.addAll(altLinks);
            List authors = atom.getAuthors();
            String title = atom.getTitle();
            List categories = atom.getCategories();
            List contributors = atom.getContributors();
            Date updated = atom.getUpdated();
            Generator generator = atom.getGenerator();
            String rights = atom.getRights();
            List rdf = (List)atom.getForeignMarkup();
            List entries = atom.getEntries();
            this.validate(categories);
            URI uri_r = this.getURIR(links);
            Aggregation agg = OREFactory.createAggregation(uri_a);
            ResourceMap rem = agg.createResourceMap(uri_r);
            for (Person author : authors) {
                String mbox;
                String auri = author.getUri();
                Agent creator = auri != null ? OREFactory.createAgent(new URI(auri)) : OREFactory.createAgent();
                String name = author.getName();
                if (name != null) {
                    creator.addName(name);
                }
                if ((mbox = author.getEmail()) != null) {
                    if (!mbox.startsWith("mailto:")) {
                        mbox = "mailto:" + mbox;
                    }
                    creator.addMbox(new URI(mbox));
                }
                agg.addCreator(creator);
            }
            if (title != null) {
                agg.addTitle(title);
            }
            for (Category category : categories) {
                String aggURI = Vocab.ore_Aggregation.uri().toString();
                if (aggURI.equals(category.getTerm())) continue;
                String type = category.getTerm();
                URI typeURI = new URI(type);
                agg.addType(typeURI);
                String label = category.getLabel();
                agg.createTriple(Vocab.rdfs_label, (Object)label);
            }
            for (Link link : links) {
                if ("related".equals(link.getRel())) {
                    agg.addSimilarTo(new URI(link.getHref()));
                }
                if ("alternate".equals(link.getRel())) {
                    ReMSerialisation serial = new ReMSerialisation();
                    serial.setURI(new URI(link.getHref()));
                    agg.addReMSerialisation(serial);
                }
                if (!"license".equals(link.getRel())) continue;
            }
            String iconURI = atom.getIcon();
            if (updated != null) {
                rem.setModified(updated);
            }
            if (generator != null) {
                String genURL = generator.getUrl();
                Agent remCreator = genURL != null ? OREFactory.createAgent(new URI(genURL)) : OREFactory.createAgent();
                String name = generator.getValue();
                if (name != null) {
                    remCreator.addName(generator.getValue());
                }
                rem.addCreator(remCreator);
            }
            if (rights != null) {
                rem.setRights(rights);
            }
            for (Object entry : entries) {
                this.aggregatedResource((Entry)entry, agg);
            }
            Element root2 = new Element("RDF", rdfNS);
            for (Element element : rdf) {
                root2.addContent(element);
            }
            XMLOutputter out = new XMLOutputter();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            out.output(root2, (OutputStream)os);
            agg.addRDF(os.toString(), "RDF/XML");
            if (rem.getCreated() == null) {
                rem.setCreated(new Date());
            }
            if (agg.getCreated() == null) {
                agg.setCreated(new Date());
            }
            return rem;
        }
        catch (IOException e2) {
            throw new OREParserException(e2);
        }
        catch (FeedException e3) {
            throw new OREParserException(e3);
        }
        catch (URISyntaxException e4) {
            throw new OREParserException(e4);
        }
        catch (OREException e5) {
            throw new OREParserException(e5);
        }
    }

    private void aggregatedResource(Entry entry, Aggregation agg) throws URISyntaxException, OREException, OREParserException, IOException {
        URI uri_p = null;
        String proxyURI = entry.getId();
        if (proxyURI != null) {
            uri_p = new URI(proxyURI);
        }
        List links = entry.getOtherLinks();
        List altLinks = entry.getAlternateLinks();
        links.addAll(altLinks);
        List authors = entry.getAuthors();
        String title = entry.getTitle();
        List categories = entry.getCategories();
        List contributors = entry.getContributors();
        Content summary = entry.getSummary();
        List rdf = (List)entry.getForeignMarkup();
        URI uri_ar = this.getURIAR(links);
        AggregatedResource ar = agg.createAggregatedResource(uri_ar);
        Proxy proxy = null;
        if (uri_p != null) {
            proxy = ar.createProxy(uri_p);
        }
        for (Link link : links) {
            if ("alternate".equals(link.getRel())) {
                // empty if block
            }
            if ("related".equals(link.getRel())) {
                ar.addAggregation(new URI(link.getHref()));
            }
            if (!"via".equals(link.getRel()) || proxy == null) continue;
            proxy.setLineage(new URI(link.getRel()));
        }
        if (authors != null) {
            for (Person author : authors) {
                String mbox;
                String authorURI = author.getUri();
                Agent creator = authorURI != null ? OREFactory.createAgent(new URI(authorURI)) : OREFactory.createAgent();
                String name = author.getName();
                if (name != null) {
                    creator.addName(name);
                }
                if ((mbox = author.getEmail()) != null) {
                    if (!mbox.startsWith("mailto:")) {
                        mbox = "mailto:" + mbox;
                    }
                    creator.addMbox(new URI(mbox));
                }
                ar.addCreator(creator);
            }
        }
        for (Object category : categories) {
            ar.addType(new URI(((Category)category).getTerm()));
        }
        Element root2 = new Element("RDF", rdfNS);
        for (Element element : rdf) {
            root2.addContent(element);
        }
        XMLOutputter out = new XMLOutputter();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        out.output(root2, (OutputStream)os);
        ar.addRDF(os.toString(), "RDF/XML");
    }

    private void validate(List<Category> categories) throws OREParserException {
        for (Category category : categories) {
            String aggURI = OREVocabulary.aggregation.getUri().toString();
            if (!aggURI.equals(category.getTerm())) continue;
            return;
        }
        throw new OREParserException("Passed ATOM document is not an ORE Resource Map; it is missing a valid atom:category statement");
    }

    private URI getURIR(List<Link> links) throws OREParserException {
        try {
            for (Link link : links) {
                String rel = link.getRel();
                if (!"self".equals(rel)) continue;
                return new URI(link.getHref());
            }
            throw new OREParserException("Passed ATOM document does not contain a URI for the Resource Map; atom:link[@rel='self']");
        }
        catch (URISyntaxException e2) {
            throw new OREParserException("unable to parse link in atom:link[@rel='self']", e2);
        }
    }

    private URI getURIAR(List<Link> links) throws OREParserException {
        try {
            for (Link link : links) {
                String rel = link.getRel();
                if (!"alternate".equals(rel)) continue;
                return new URI(link.getHref());
            }
            throw new OREParserException("Passed ATOM document does not contain a URI for the Aggregated Resource");
        }
        catch (URISyntaxException e2) {
            throw new OREParserException("unable to parse link in atom:link[@rel='alternate']", e2);
        }
    }

    @Override
    public void configure(Properties properties) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemRDF {
        private String about;
        private List<Date> created;

        private RemRDF() {
        }

        public String getAbout() {
            return this.about;
        }

        public void setAbout(String about) {
            this.about = about;
        }

        public List<Date> getCreated() {
            return this.created;
        }

        public void setCreated(List<Date> created) {
            this.created = created;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AggregationRDF {
        private String about;
        private List<String> isAggregatedBy;
        private List<Date> created;

        private AggregationRDF() {
        }

        public String getAbout() {
            return this.about;
        }

        public void setAbout(String about) {
            this.about = about;
        }

        public List<String> getAggregatedBy() {
            return this.isAggregatedBy;
        }

        public void setAggregatedBy(List<String> aggregatedBy) {
            this.isAggregatedBy = aggregatedBy;
        }

        public List<Date> getCreated() {
            return this.created;
        }

        public void setCreated(List<Date> created) {
            this.created = created;
        }
    }
}

