/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.foresite.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.ByteArrayOutputStream;
import java.util.Properties;
import org.dspace.foresite.OREException;
import org.dspace.foresite.ORESerialiser;
import org.dspace.foresite.ORESerialiserException;
import org.dspace.foresite.REMValidator;
import org.dspace.foresite.ResourceMap;
import org.dspace.foresite.ResourceMapDocument;
import org.dspace.foresite.jena.JenaOREFactory;
import org.dspace.foresite.jena.REMValidatorJena;
import org.dspace.foresite.jena.ResourceMapJena;

public class JenaORESerialiser
implements ORESerialiser {
    private String type = "RDF/XML";

    public ResourceMapDocument serialise(ResourceMap rem) throws ORESerialiserException {
        try {
            ResourceMap resMap = this.cloneResourceMap(rem);
            this.prepForSerialisation(resMap);
            return this.serialiseRaw(resMap);
        }
        catch (OREException e2) {
            throw new ORESerialiserException(e2);
        }
    }

    public ResourceMapDocument serialiseRaw(ResourceMap resMap) throws ORESerialiserException {
        try {
            Model model = ((ResourceMapJena)resMap).getModel();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            model.write(out, this.type);
            ResourceMapDocument rmd = new ResourceMapDocument();
            rmd.setSerialisation(((Object)out).toString());
            rmd.setMimeType(this.getMimeType());
            rmd.setUri(resMap.getURI());
            return rmd;
        }
        catch (OREException e2) {
            throw new ORESerialiserException(e2);
        }
    }

    public void configure(Properties properties) {
        this.type = properties.getProperty("type");
    }

    private void prepForSerialisation(ResourceMap rem) throws OREException {
        REMValidatorJena validator = new REMValidatorJena();
        ((REMValidator)validator).prepForSerialisation(rem);
    }

    private String getMimeType() {
        if ("RDF/XML".equals(this.type)) {
            return "text/xml";
        }
        return "text/plain";
    }

    private ResourceMap cloneResourceMap(ResourceMap rem) throws OREException {
        Model model = ((ResourceMapJena)rem).getModel();
        StmtIterator itr = model.listStatements();
        Model nModel = ModelFactory.createDefaultModel();
        nModel.add(itr);
        ResourceMap nrem = JenaOREFactory.createResourceMap(nModel, rem.getURI());
        return nrem;
    }
}

