/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.util;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.util.StringHelper;

public final class ReflectHelper {
    public static final Class[] NO_PARAM_SIGNATURE;
    public static final Object[] NO_PARAMS;
    public static final Class[] SINGLE_OBJECT_PARAM_SIGNATURE;
    private static final Method OBJECT_EQUALS;
    private static final Method OBJECT_HASHCODE;

    private ReflectHelper() {
    }

    public static Method extractEqualsMethod(Class clazz) throws NoSuchMethodException {
        return clazz.getMethod("equals", SINGLE_OBJECT_PARAM_SIGNATURE);
    }

    public static Method extractHashCodeMethod(Class clazz) throws NoSuchMethodException {
        return clazz.getMethod("hashCode", NO_PARAM_SIGNATURE);
    }

    public static boolean overridesEquals(Class clazz) {
        Method equals;
        try {
            equals = ReflectHelper.extractEqualsMethod(clazz);
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        return !OBJECT_EQUALS.equals(equals);
    }

    public static boolean overridesHashCode(Class clazz) {
        Method hashCode;
        try {
            hashCode = ReflectHelper.extractHashCodeMethod(clazz);
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        return !OBJECT_HASHCODE.equals(hashCode);
    }

    public static Class classForName(String name, Class caller) throws ClassNotFoundException {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(name);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Class.forName(name, true, caller.getClassLoader());
    }

    public static Class classForName(String name) throws ClassNotFoundException {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(name);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Class.forName(name);
    }

    public static boolean isPublic(Class clazz, Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(clazz.getModifiers());
    }

    public static Object getConstantValue(String name) {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(StringHelper.qualifier(name));
        }
        catch (Throwable t) {
            return null;
        }
        try {
            return clazz.getField(StringHelper.unqualify(name)).get(null);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean isAbstractClass(Class clazz) {
        int modifier = clazz.getModifiers();
        return Modifier.isAbstract(modifier) || Modifier.isInterface(modifier);
    }

    public static boolean isFinalClass(Class clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static Method getMethod(Class clazz, Method method) {
        try {
            return clazz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (Exception e2) {
            return null;
        }
    }

    static {
        Method hash;
        Method eq;
        NO_PARAM_SIGNATURE = new Class[0];
        NO_PARAMS = new Object[0];
        SINGLE_OBJECT_PARAM_SIGNATURE = new Class[]{Object.class};
        try {
            eq = ReflectHelper.extractEqualsMethod(Object.class);
            hash = ReflectHelper.extractHashCodeMethod(Object.class);
        }
        catch (Exception e2) {
            throw new AssertionFailure("Could not find Object.equals() or Object.hashCode()", e2);
        }
        OBJECT_EQUALS = eq;
        OBJECT_HASHCODE = hash;
    }
}

