/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.beanvalidation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.event.EventListeners;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidationActivator {
    private static final String BV_DISCOVERY_CLASS = "javax.validation.Validation";
    private static final String TYPE_SAFE_ACTIVATOR_CLASS = "org.hibernate.cfg.beanvalidation.TypeSafeActivator";
    private static final String TYPE_SAFE_DDL_METHOD = "applyDDL";
    private static final String TYPE_SAFE_ACTIVATOR_METHOD = "activateBeanValidation";
    private static final String MODE_PROPERTY = "javax.persistence.validation.mode";

    public static void activateBeanValidation(EventListeners eventListeners, Properties properties) {
        Set<ValidationMode> modes;
        block10: {
            modes = ValidationMode.getModes(properties.get(MODE_PROPERTY));
            try {
                ReflectHelper.classForName(BV_DISCOVERY_CLASS, BeanValidationActivator.class);
            }
            catch (ClassNotFoundException e2) {
                if (modes.contains((Object)ValidationMode.CALLBACK)) {
                    throw new HibernateException("Bean Validation not available in the class path but required in javax.persistence.validation.mode");
                }
                if (!modes.contains((Object)ValidationMode.AUTO)) break block10;
                return;
            }
        }
        if (properties.getProperty("hibernate.check_nullability") == null) {
            properties.setProperty("hibernate.check_nullability", "false");
        }
        if (!modes.contains((Object)ValidationMode.CALLBACK) && !modes.contains((Object)ValidationMode.AUTO)) {
            return;
        }
        try {
            Class activator = ReflectHelper.classForName(TYPE_SAFE_ACTIVATOR_CLASS, BeanValidationActivator.class);
            Method activateBeanValidation = activator.getMethod(TYPE_SAFE_ACTIVATOR_METHOD, EventListeners.class, Properties.class);
            activateBeanValidation.invoke(null, eventListeners, properties);
        }
        catch (NoSuchMethodException e3) {
            throw new HibernateException("Unable to get the default Bean Validation factory", e3);
        }
        catch (IllegalAccessException e4) {
            throw new HibernateException("Unable to get the default Bean Validation factory", e4);
        }
        catch (InvocationTargetException e5) {
            throw new HibernateException("Unable to get the default Bean Validation factory", e5);
        }
        catch (ClassNotFoundException e6) {
            throw new HibernateException("Unable to get the default Bean Validation factory", e6);
        }
    }

    public static void applyDDL(Collection<PersistentClass> persistentClasses, Properties properties) {
        block9: {
            Set<ValidationMode> modes = ValidationMode.getModes(properties.get(MODE_PROPERTY));
            if (!modes.contains((Object)ValidationMode.DDL) && !modes.contains((Object)ValidationMode.AUTO)) {
                return;
            }
            try {
                ReflectHelper.classForName(BV_DISCOVERY_CLASS, BeanValidationActivator.class);
            }
            catch (ClassNotFoundException e2) {
                if (modes.contains((Object)ValidationMode.DDL)) {
                    throw new HibernateException("Bean Validation not available in the class path but required in javax.persistence.validation.mode");
                }
                if (!modes.contains((Object)ValidationMode.AUTO)) break block9;
                return;
            }
        }
        try {
            Class activator = ReflectHelper.classForName(TYPE_SAFE_ACTIVATOR_CLASS, BeanValidationActivator.class);
            Method applyDDL = activator.getMethod(TYPE_SAFE_DDL_METHOD, Collection.class, Properties.class);
            applyDDL.invoke(null, persistentClasses, properties);
        }
        catch (NoSuchMethodException e3) {
            throw new HibernateException("Unable to get the default Bean Validation factory", e3);
        }
        catch (IllegalAccessException e4) {
            throw new HibernateException("Unable to get the default Bean Validation factory", e4);
        }
        catch (InvocationTargetException e5) {
            throw new HibernateException("Unable to get the default Bean Validation factory", e5);
        }
        catch (ClassNotFoundException e6) {
            throw new HibernateException("Unable to get the default Bean Validation factory", e6);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ValidationMode {
        AUTO,
        CALLBACK,
        NONE,
        DDL;


        public static Set<ValidationMode> getModes(Object modeProperty) {
            HashSet<ValidationMode> modes = new HashSet<ValidationMode>(3);
            if (modeProperty == null) {
                modes.add(AUTO);
            } else {
                String[] modesInString;
                for (String modeInString : modesInString = modeProperty.toString().split(",")) {
                    modes.add(ValidationMode.getMode(modeInString));
                }
            }
            if (modes.size() > 1 && (modes.contains((Object)AUTO) || modes.contains((Object)NONE))) {
                StringBuilder message = new StringBuilder("Incompatible validation modes mixed: ");
                for (ValidationMode mode : modes) {
                    message.append((Object)mode).append(", ");
                }
                throw new HibernateException(message.substring(0, message.length() - 2));
            }
            return modes;
        }

        private static ValidationMode getMode(String modeProperty) {
            if (modeProperty == null || modeProperty.length() == 0) {
                return AUTO;
            }
            try {
                return ValidationMode.valueOf(modeProperty.trim().toUpperCase());
            }
            catch (IllegalArgumentException e2) {
                throw new HibernateException("Unknown validation mode in javax.persistence.validation.mode: " + modeProperty.toString());
            }
        }
    }
}

