/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.CriteriaSubqueryImpl;
import org.hibernate.ejb.criteria.FromImplementor;
import org.hibernate.ejb.criteria.JoinImplementor;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.Renderable;
import org.hibernate.ejb.criteria.path.RootImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryStructure<T>
implements Serializable {
    private final AbstractQuery<T> owner;
    private final CriteriaBuilderImpl criteriaBuilder;
    private final boolean isSubQuery;
    private boolean distinct;
    private Selection<? extends T> selection;
    private Set<Root<?>> roots = new LinkedHashSet();
    private Set<FromImplementor> correlationRoots;
    private Predicate restriction;
    private List<Expression<?>> groupings = Collections.emptyList();
    private Predicate having;
    private List<Subquery<?>> subqueries;

    public QueryStructure(AbstractQuery<T> owner, CriteriaBuilderImpl criteriaBuilder) {
        this.owner = owner;
        this.criteriaBuilder = criteriaBuilder;
        this.isSubQuery = Subquery.class.isInstance(owner);
    }

    public Set<ParameterExpression<?>> getParameters() {
        final LinkedHashSet parameters = new LinkedHashSet();
        ParameterRegistry registry = new ParameterRegistry(){

            @Override
            public void registerParameter(ParameterExpression<?> parameter) {
                parameters.add(parameter);
            }
        };
        ParameterContainer.Helper.possibleParameter(this.selection, registry);
        ParameterContainer.Helper.possibleParameter(this.restriction, registry);
        ParameterContainer.Helper.possibleParameter(this.having, registry);
        if (this.subqueries != null) {
            for (Subquery<?> subquery : this.subqueries) {
                ParameterContainer.Helper.possibleParameter(subquery, registry);
            }
        }
        ParameterContainer.Helper.possibleParameter(this.having, registry);
        if (this.groupings != null) {
            for (Expression<?> grouping : this.groupings) {
                ParameterContainer.Helper.possibleParameter(grouping, registry);
            }
        }
        return parameters;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public Selection<? extends T> getSelection() {
        return this.selection;
    }

    public void setSelection(Selection<? extends T> selection) {
        this.selection = selection;
    }

    public Set<Root<?>> getRoots() {
        return this.roots;
    }

    public <X> Root<X> from(Class<X> entityClass) {
        EntityType<X> entityType = this.criteriaBuilder.getEntityManagerFactory().getMetamodel().entity(entityClass);
        if (entityType == null) {
            throw new IllegalArgumentException(entityClass + " is not an entity");
        }
        return this.from(entityType);
    }

    public <X> Root<X> from(EntityType<X> entityType) {
        RootImpl<X> root2 = new RootImpl<X>(this.criteriaBuilder, entityType);
        this.roots.add(root2);
        return root2;
    }

    public void addCorrelationRoot(FromImplementor fromImplementor) {
        if (!this.isSubQuery) {
            throw new IllegalStateException("Query is not identified as sub-query");
        }
        if (this.correlationRoots == null) {
            this.correlationRoots = new HashSet<FromImplementor>();
        }
        this.correlationRoots.add(fromImplementor);
    }

    public Set<Join<?, ?>> collectCorrelatedJoins() {
        Set<Join<?, ?>> correlatedJoins;
        if (!this.isSubQuery) {
            throw new IllegalStateException("Query is not identified as sub-query");
        }
        if (this.correlationRoots != null) {
            correlatedJoins = new HashSet();
            for (FromImplementor correlationRoot : this.correlationRoots) {
                correlatedJoins.addAll(correlationRoot.getJoins());
            }
        } else {
            correlatedJoins = Collections.emptySet();
        }
        return correlatedJoins;
    }

    public Predicate getRestriction() {
        return this.restriction;
    }

    public void setRestriction(Predicate restriction) {
        this.restriction = restriction;
    }

    public List<Expression<?>> getGroupings() {
        return this.groupings;
    }

    public void setGroupings(List<Expression<?>> groupings) {
        this.groupings = groupings;
    }

    public void setGroupings(Expression<?> ... groupings) {
        this.groupings = groupings != null && groupings.length > 0 ? Arrays.asList(groupings) : Collections.emptyList();
    }

    public Predicate getHaving() {
        return this.having;
    }

    public void setHaving(Predicate having) {
        this.having = having;
    }

    public List<Subquery<?>> getSubqueries() {
        return this.subqueries;
    }

    public List<Subquery<?>> internalGetSubqueries() {
        if (this.subqueries == null) {
            this.subqueries = new ArrayList();
        }
        return this.subqueries;
    }

    public <U> Subquery<U> subquery(Class<U> subqueryType) {
        CriteriaSubqueryImpl<U> subquery = new CriteriaSubqueryImpl<U>(this.criteriaBuilder, subqueryType, this.owner);
        this.internalGetSubqueries().add(subquery);
        return subquery;
    }

    public void render(StringBuilder jpaqlQuery, CriteriaQueryCompiler.RenderingContext renderingContext) {
        jpaqlQuery.append("select ");
        if (this.isDistinct()) {
            jpaqlQuery.append("distinct ");
        }
        if (this.getSelection() == null) {
            jpaqlQuery.append(this.locateImplicitSelection().renderProjection(renderingContext));
        } else {
            jpaqlQuery.append(((Renderable)((Object)this.getSelection())).renderProjection(renderingContext));
        }
        this.renderFromClause(jpaqlQuery, renderingContext);
        if (this.getRestriction() != null) {
            jpaqlQuery.append(" where ").append(((Renderable)((Object)this.getRestriction())).render(renderingContext));
        }
        if (!this.getGroupings().isEmpty()) {
            jpaqlQuery.append(" group by ");
            String sep = "";
            for (Expression<?> grouping : this.getGroupings()) {
                jpaqlQuery.append(sep).append(((Renderable)((Object)grouping)).render(renderingContext));
                sep = ", ";
            }
            if (this.getHaving() != null) {
                jpaqlQuery.append(" having ").append(((Renderable)((Object)this.getHaving())).render(renderingContext));
            }
        }
    }

    private FromImplementor locateImplicitSelection() {
        FromImplementor implicitSelection = null;
        if (!this.isSubQuery) {
            implicitSelection = (FromImplementor)((Object)this.getRoots().iterator().next());
        } else {
            Set<Join<?, ?>> correlatedJoins = this.collectCorrelatedJoins();
            if (correlatedJoins != null && correlatedJoins.size() == 1) {
                implicitSelection = (FromImplementor)((Object)correlatedJoins.iterator().next());
            }
        }
        if (implicitSelection == null) {
            throw new IllegalStateException("No explicit selection and an implicit one cold not be determined");
        }
        return implicitSelection;
    }

    private void renderFromClause(StringBuilder jpaqlQuery, CriteriaQueryCompiler.RenderingContext renderingContext) {
        jpaqlQuery.append(" from ");
        String sep = "";
        for (Root<?> root2 : this.getRoots()) {
            ((FromImplementor)((Object)root2)).prepareAlias(renderingContext);
            jpaqlQuery.append(sep);
            jpaqlQuery.append(((FromImplementor)((Object)root2)).renderTableExpression(renderingContext));
            sep = ", ";
        }
        for (Root<?> root2 : this.getRoots()) {
            this.renderJoins(jpaqlQuery, renderingContext, root2.getJoins());
            this.renderFetches(jpaqlQuery, renderingContext, root2.getFetches());
        }
        if (this.isSubQuery && this.correlationRoots != null) {
            for (FromImplementor correlationRoot : this.correlationRoots) {
                FromImplementor correlationParent = correlationRoot.getCorrelationParent();
                correlationParent.prepareAlias(renderingContext);
                String correlationRootAlias = correlationParent.getAlias();
                for (Join correlationJoin : correlationRoot.getJoins()) {
                    JoinImplementor correlationJoinImpl = (JoinImplementor)correlationJoin;
                    jpaqlQuery.append(sep);
                    correlationJoinImpl.prepareAlias(renderingContext);
                    jpaqlQuery.append(correlationRootAlias).append('.').append(correlationJoinImpl.getAttribute().getName()).append(" as ").append(correlationJoinImpl.getAlias());
                    sep = ", ";
                    this.renderJoins(jpaqlQuery, renderingContext, correlationJoinImpl.getJoins());
                }
            }
        }
    }

    private void renderJoins(StringBuilder jpaqlQuery, CriteriaQueryCompiler.RenderingContext renderingContext, Collection<Join<?, ?>> joins) {
        if (joins == null) {
            return;
        }
        for (Join<?, ?> join : joins) {
            ((FromImplementor)((Object)join)).prepareAlias(renderingContext);
            jpaqlQuery.append(this.renderJoinType(join.getJoinType())).append(((FromImplementor)((Object)join)).renderTableExpression(renderingContext));
            this.renderJoins(jpaqlQuery, renderingContext, join.getJoins());
            this.renderFetches(jpaqlQuery, renderingContext, join.getFetches());
        }
    }

    private String renderJoinType(JoinType joinType) {
        switch (joinType) {
            case INNER: {
                return " inner join ";
            }
            case LEFT: {
                return " left join ";
            }
            case RIGHT: {
                return " right join ";
            }
        }
        throw new IllegalStateException("Unknown join type " + (Object)((Object)joinType));
    }

    private void renderFetches(StringBuilder jpaqlQuery, CriteriaQueryCompiler.RenderingContext renderingContext, Collection<Fetch> fetches) {
        if (fetches == null) {
            return;
        }
        for (Fetch fetch : fetches) {
            ((FromImplementor)((Object)fetch)).prepareAlias(renderingContext);
            jpaqlQuery.append(this.renderJoinType(fetch.getJoinType())).append("fetch ").append(((FromImplementor)((Object)fetch)).renderTableExpression(renderingContext));
            this.renderFetches(jpaqlQuery, renderingContext, fetch.getFetches());
        }
    }
}

