/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Clob;
import org.hibernate.engine.jdbc.SerializableClobProxy;
import org.hibernate.engine.jdbc.WrappedClob;

public class SerializableNClobProxy
extends SerializableClobProxy {
    private static final Class NCLOB_CLASS = SerializableNClobProxy.loadNClobClassIfAvailable();
    private static final Class[] PROXY_INTERFACES = new Class[]{SerializableNClobProxy.determineNClobInterface(), WrappedClob.class};

    private static Class loadNClobClassIfAvailable() {
        try {
            return SerializableNClobProxy.getProxyClassLoader().loadClass("java.sql.NClob");
        }
        catch (ClassNotFoundException e2) {
            return null;
        }
    }

    private static Class determineNClobInterface() {
        return NCLOB_CLASS == null ? Clob.class : NCLOB_CLASS;
    }

    public static boolean isNClob(Clob clob) {
        return NCLOB_CLASS != null && NCLOB_CLASS.isInstance(clob);
    }

    protected SerializableNClobProxy(Clob clob) {
        super(clob);
    }

    public static Clob generateProxy(Clob clob) {
        return (Clob)Proxy.newProxyInstance(SerializableNClobProxy.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)new SerializableNClobProxy(clob));
    }

    public static ClassLoader getProxyClassLoader() {
        return SerializableClobProxy.getProxyClassLoader();
    }
}

